/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DownsamplingIterator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Murmur3;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Iterator;

class ConstantMemoryDownsamplingIterator
extends DownsamplingIterator {
    private final PeekableIterator<SAMRecord> underlyingIterator;
    private final int maxHashValue;
    private final Murmur3 hasher;

    ConstantMemoryDownsamplingIterator(Iterator<SAMRecord> iterator, double proportion, int seed) {
        super(proportion);
        this.hasher = new Murmur3(seed);
        this.underlyingIterator = new PeekableIterator<SAMRecord>(iterator);
        long range = 0xFFFFFFFFL;
        this.maxHashValue = Integer.MIN_VALUE + (int)Math.round(4.294967295E9 * proportion);
        this.advanceToNextAcceptedRead();
    }

    @Override
    public boolean hasNext() {
        return this.underlyingIterator.hasNext();
    }

    private boolean advanceToNextAcceptedRead() {
        while (this.underlyingIterator.hasNext() && this.hasher.hashUnencodedChars(this.underlyingIterator.peek().getReadName()) > this.maxHashValue) {
            this.underlyingIterator.next();
            this.recordDiscardedRecord();
        }
        return this.underlyingIterator.hasNext();
    }

    @Override
    public SAMRecord next() {
        SAMRecord rec = this.underlyingIterator.next();
        this.recordAcceptedRecord();
        this.advanceToNextAcceptedRead();
        return rec;
    }
}

