/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.ucsc.BPIndex;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;
import org.broad.igv.ucsc.twobit.UnsignedByteBufferImpl;

public class BPTree
implements BPIndex {
    static int SIGNATURE = 2026540177;
    String path;
    private long fileOffset;
    ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    Map<Long, Node> nodeCache;
    int blockSize;
    int keySize;
    int valSize;
    long itemCount;
    long reserved;
    long nodeOffset;

    public static BPTree loadBPTree(String path, long fileOffset) throws IOException {
        BPTree tree = new BPTree(path, fileOffset);
        tree.init();
        return tree;
    }

    private BPTree(String path, long fileOffset) throws IOException {
        this.path = path;
        this.fileOffset = fileOffset;
        this.nodeCache = new HashMap<Long, Node>();
    }

    UnsignedByteBuffer loadBinaryBuffer(long start, int size) throws IOException {
        return UnsignedByteBufferImpl.loadBinaryBuffer(this.path, this.byteOrder, start, size);
    }

    private void init() throws IOException {
        long filePosition = this.fileOffset;
        UnsignedByteBuffer buffer = this.loadBinaryBuffer(filePosition, 64);
        int magicNumber = buffer.getInt();
        if (SIGNATURE != magicNumber) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            buffer = this.loadBinaryBuffer(0L, 64);
            magicNumber = buffer.getInt();
            if (SIGNATURE != magicNumber) {
                throw new RuntimeException("Unexpected magic number");
            }
        }
        this.blockSize = buffer.getInt();
        this.keySize = buffer.getInt();
        this.valSize = buffer.getInt();
        this.itemCount = buffer.getLong();
        this.reserved = buffer.getLong();
        this.nodeOffset = this.fileOffset + 32L;
    }

    @Override
    public long[] search(String term) throws IOException {
        int keySize = this.keySize;
        int valSize = this.valSize;
        if (valSize != 16 && valSize != 8) {
            throw new RuntimeException("Unexpected valSiz: " + this.valSize);
        }
        return this.walkTreeNode(this.nodeOffset, term);
    }

    Node readTreeNode(long offset) throws IOException {
        if (this.nodeCache.containsKey(offset)) {
            return this.nodeCache.get(offset);
        }
        UnsignedByteBuffer buffer = this.loadBinaryBuffer(offset, 4);
        byte type = buffer.get();
        byte reserved = buffer.get();
        int count = buffer.getUShort();
        ArrayList<Item> items = new ArrayList<Item>();
        if (type == 1) {
            size = count * (this.keySize + this.valSize);
            buffer = this.loadBinaryBuffer(offset + 4L, size);
            for (int i = 0; i < count; ++i) {
                long[] value;
                String key = buffer.getFixedLengthString(this.keySize);
                long itemOffset = buffer.getLong();
                if (this.valSize == 16) {
                    long length = buffer.getLong();
                    value = new long[]{itemOffset, length};
                } else {
                    value = new long[]{itemOffset};
                }
                items.add(new Item(key, value));
            }
        } else {
            size = count * (this.keySize + 8);
            buffer = this.loadBinaryBuffer(offset + 4L, size);
            for (int i = 0; i < count; ++i) {
                String key = buffer.getFixedLengthString(this.keySize);
                long itemOffset = buffer.getLong();
                long[] value = new long[]{itemOffset};
                items.add(new Item(key, value));
            }
        }
        Node node = new Node(type, count, items);
        this.nodeCache.put(offset, node);
        return node;
    }

    long[] walkTreeNode(long offset, String term) throws IOException {
        String key;
        Node node = this.readTreeNode(offset);
        if (node.type == 1) {
            for (Item item : node.items) {
                if (!term.equals(item.key)) continue;
                return item.value;
            }
            return null;
        }
        long childOffset = node.items.get((int)0).value[0];
        for (int i = 1; i < node.items.size() && term.compareTo(key = node.items.get((int)i).key) >= 0; ++i) {
            childOffset = node.items.get((int)i).value[0];
        }
        return this.walkTreeNode(childOffset, term);
    }

    class Node {
        int type;
        int count;
        List<Item> items;

        public Node(int type, int count, List<Item> items) {
            this.type = type;
            this.count = count;
            this.items = items;
        }
    }

    class Item {
        String key;
        long[] value;

        public Item(String key, long[] value) {
            this.key = key;
            this.value = value;
        }
    }
}

