/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.InsertionManager;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;

public class RulerPanel
extends JPanel {
    public static final Color INSERTION_MARKER_ZOOMEDOUT = new Color(64, 64, 64, 50);
    private static Logger log = LogManager.getLogger(RulerPanel.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();
    private static final int INSERTION_ROW_HEIGHT = 9;
    boolean drawSpan = true;
    private Font tickFont = FontManager.getFont(10);
    private Font spanFont = FontManager.getFont(1, 12);
    private List<ClickLink> clickLinks = new ArrayList<ClickLink>();
    private static Color dragColor = new Color(0.5f, 0.5f, 1.0f, 0.3f);
    private static Color zoomBoundColor = new Color(0.5f, 0.5f, 0.5f);
    boolean dragging = false;
    int dragStart;
    int dragEnd;
    public static final String WHOLE_GENOME_TOOLTIP = "<html>Click on a chromosome number to jump to that chromosome,<br>or click and drag to zoom in.";
    public static final String CHROM_TOOLTIP = "Click and drag to zoom in.";
    ReferenceFrame frame;

    public RulerPanel(ReferenceFrame frame) {
        this.frame = frame;
        this.init();
    }

    private boolean isWholeGenomeView() {
        return this.frame.getChrName().equals("All");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (PreferencesManager.getPreferences().getAntiAliasing()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.render(g);
        if (this.dragging) {
            g.setColor(dragColor);
            int start = Math.min(this.dragStart, this.dragEnd);
            int w = Math.abs(this.dragEnd - this.dragStart);
            int height = this.getHeight();
            g.fillRect(start, 0, w, height);
            g.setColor(zoomBoundColor);
            g.drawLine(this.dragStart, 0, this.dragStart, height);
            g.drawLine(this.dragEnd, 0, this.dragEnd, height);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    }

    private void render(Graphics g) {
        this.clickLinks.clear();
        g.setColor(Color.black);
        if (this.isWholeGenomeView()) {
            this.drawChromosomeTicks(g);
        } else {
            List<AlignmentTrack> tracks;
            int maxVizWindow;
            this.drawTicks(g);
            if (this.drawSpan) {
                this.drawSpan(g);
            }
            int n = maxVizWindow = (tracks = IGV.getInstance().getAlignmentTracks()).size() == 0 ? 0 : tracks.stream().mapToInt(t -> t.getVisibilityWindow()).max().getAsInt();
            if (!this.frame.getChrName().equals("All") && this.frame.getEnd() - this.frame.getOrigin() <= (double)maxVizWindow) {
                this.drawInsertionMarkers(g);
            }
        }
    }

    private void drawSpan(Graphics g) {
        int w = this.getWidth();
        g.setFont(this.spanFont);
        int range = (int)(this.frame.getScale() * (double)w) + 1;
        boolean scaleInKB = this.frame.getChrName().equals("All");
        TickSpacing ts = RulerPanel.findSpacing(range, scaleInKB);
        String rangeString = RulerPanel.formatNumber((double)range / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
        int strWidth = g.getFontMetrics().stringWidth(rangeString);
        int strHeight = g.getFontMetrics().getAscent();
        int strPosition = (w - strWidth) / 2;
        int lineY = this.getHeight() - 35 - strHeight / 2;
        g.drawLine(0, lineY, (w - strWidth) / 2 - 10, lineY);
        int[] arrowX = new int[]{0, 10, 10};
        int[] arrowY = new int[]{lineY, lineY + 3, lineY - 3};
        g.fillPolygon(arrowX, arrowY, arrowX.length);
        g.drawLine((w + strWidth) / 2 + 10, lineY, w, lineY);
        arrowX = new int[]{w, w - 10, w - 10};
        g.fillPolygon(arrowX, arrowY, arrowX.length);
        g.drawString(rangeString, strPosition, this.getHeight() - 35);
    }

    private void drawTicks(Graphics g) {
        int w = this.getWidth();
        if (w < 200) {
            return;
        }
        g.setFont(this.tickFont);
        boolean scaleInKB = this.frame.getChrName().equals("All");
        int range = (int)((double)w * this.frame.getScale());
        TickSpacing ts = RulerPanel.findSpacing(range, scaleInKB);
        double spacing = ts.getMajorTick();
        int nTick = (int)(this.frame.getExpansionAdjustedOrigin() / spacing) - 1;
        int l = (int)((double)nTick * spacing);
        int x = this.frame.getScreenPosition((double)(l - 1) + 0.5);
        while (x < this.getWidth()) {
            l = (int)((double)nTick * spacing);
            x = this.frame.getScreenPosition((double)(l - 1) + 0.5);
            String chrPosition = RulerPanel.formatNumber((double)l / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
            int strWidth = g.getFontMetrics().stringWidth(chrPosition);
            int strPosition = x - strWidth / 2;
            int height = this.getHeight();
            if (nTick % 2 == 0 && strPosition > 0) {
                g.drawString(chrPosition, strPosition, height - 15);
            }
            if (x > 0) {
                g.drawLine(x, height - 10, x, height - 2);
            }
            ++nTick;
        }
    }

    private void drawChromosomeTicks(Graphics g) {
        Font chrFont = FontManager.getFont(10);
        this.setLayout(null);
        int locationUnit = 1000;
        g.setFont(chrFont);
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (genome == null) {
            log.warn("No genome found");
            PreferencesManager.getPreferences().remove("DEFAULT_GENOME_KEY");
            return;
        }
        boolean even = true;
        List<String> chrNames = genome.getLongChromosomeNames();
        if (chrNames == null) {
            log.info("No chromosomes found for genome: " + PreferencesManager.getPreferences().getDefaultGenome());
            PreferencesManager.getPreferences().remove("DEFAULT_GENOME_KEY");
        }
        if (chrNames.size() > 500) {
            return;
        }
        FontMetrics fontMetrics = g.getFontMetrics();
        for (String chrName : chrNames) {
            Chromosome c = genome.getChromosome(chrName);
            if (c == null) {
                log.info("Chromosome '" + chrName + "' not found");
                continue;
            }
            int chrLength = c.getLength();
            double scale = this.frame.getScale();
            int gStart = genome.getGenomeCoordinate(chrName, 0);
            int x = (int)((double)gStart / scale);
            int dw = (int)((double)chrLength / ((double)locationUnit * scale));
            if (x > 0) {
                g.drawLine(x, this.getHeight() - 10, x, this.getHeight() - 2);
            }
            if (dw <= 5) continue;
            int center = x + dw / 2;
            String displayName = genome.getChromosomeDisplayName(chrName);
            if (chrName.startsWith("gi|")) {
                displayName = Genome.getNCBIName(chrName);
            } else if (chrName.length() < 6) {
                displayName = chrName.replace("chr", "");
            }
            int strWidth = fontMetrics.stringWidth(displayName);
            int strPosition = center - strWidth / 2;
            int y = even ? this.getHeight() - 35 : this.getHeight() - 25;
            g.drawString(displayName, strPosition, y);
            if (!this.dragging) {
                int sw = (int)fontMetrics.getStringBounds(displayName, g).getWidth();
                Rectangle clickRect = new Rectangle(strPosition, y - 15, sw, 15);
                String tooltipText = "Jump to chromosome: " + chrName;
                this.clickLinks.add(new ClickLink(clickRect, chrName, tooltipText, ch -> this.frame.changeChromosome((String)ch, true)));
            }
            even = !even;
        }
    }

    private void drawInsertionMarkers(Graphics g) {
        List<InsertionMarker> insertionMarkers = InsertionManager.getInstance().getInsertions(this.frame.getChrName(), this.frame.getOrigin(), this.frame.getEnd() + 1.0);
        if (insertionMarkers == null) {
            return;
        }
        InsertionMarker expanded = this.frame.getExpandedInsertion();
        int w = 6;
        int y = this.getHeight() - 9 - 1;
        for (InsertionMarker insertionMarker : insertionMarkers) {
            Color c;
            Polygon p;
            int x1;
            int x0;
            if (expanded != null && insertionMarker.position == expanded.position) {
                x0 = this.frame.getScreenPosition(insertionMarker.position);
                x1 = (int)(((double)(insertionMarker.position + insertionMarker.size) - this.frame.origin) / this.frame.getScale());
                p = new Polygon(new int[]{x0 - w, x1 + w, x1, x0}, new int[]{y, y, y + 9, y + 9}, 4);
                c = Color.BLUE;
                String tooltipText = "Click to collapse insertion";
                this.clickLinks.add(new ClickLink(p, null, tooltipText, obj -> {
                    this.frame.setExpandedInsertion((InsertionMarker)obj);
                    IGV.getInstance().repaint();
                }));
            } else {
                x1 = x0 = this.frame.getScreenPosition(insertionMarker.position);
                p = new Polygon(new int[]{x0 - w, x1 + w, x0}, new int[]{y, y, y + 9}, 3);
                double expandedInsertionWidth = (double)insertionMarker.size / this.frame.getScale();
                if (expandedInsertionWidth > 5.0) {
                    c = Color.BLACK;
                    String tooltipText = "Click to expand insertion (" + insertionMarker.size + "bases)";
                    Rectangle clickArea = p.getBounds();
                    clickArea.y -= 2;
                    clickArea.height += 2;
                    this.clickLinks.add(new ClickLink(clickArea, insertionMarker, tooltipText, obj -> {
                        this.frame.setExpandedInsertion((InsertionMarker)obj);
                        IGV.getInstance().repaint();
                    }));
                } else {
                    c = INSERTION_MARKER_ZOOMEDOUT;
                }
            }
            if (x1 + w < 0 || x0 - w > this.getWidth()) continue;
            g.setColor(c);
            g.fillPolygon(p);
        }
    }

    public static String formatNumber(double position) {
        return DECIMAL_FORMAT.format((int)position);
    }

    public static TickSpacing findSpacing(long maxValue, boolean scaleInKB) {
        if (maxValue < 10L) {
            return new TickSpacing(1.0, "bp", 1);
        }
        int nZeroes = (int)Math.log10(maxValue);
        String majorUnit = scaleInKB ? "kb" : "bp";
        int unitMultiplier = 1;
        if (nZeroes > 9) {
            majorUnit = scaleInKB ? "tb" : "gb";
            unitMultiplier = 1000000000;
        }
        if (nZeroes > 6) {
            majorUnit = scaleInKB ? "gb" : "mb";
            unitMultiplier = 1000000;
        } else if (nZeroes > 3) {
            majorUnit = scaleInKB ? "mb" : "kb";
            unitMultiplier = 1000;
        }
        double nMajorTicks = (double)maxValue / Math.pow(10.0, nZeroes - 1);
        if (nMajorTicks < 25.0) {
            return new TickSpacing(Math.pow(10.0, nZeroes - 1), majorUnit, unitMultiplier);
        }
        return new TickSpacing(Math.pow(10.0, nZeroes) / 2.0, majorUnit, unitMultiplier);
    }

    private void init() {
        this.setCursor(Cursor.getDefaultCursor());
        if (this.isWholeGenomeView()) {
            this.setToolTipText(WHOLE_GENOME_TOOLTIP);
        } else {
            this.setToolTipText("Click and drag to zoom");
        }
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            private MouseEvent mouseDown;

            @Override
            public void mouseMoved(MouseEvent e) {
                for (ClickLink link : RulerPanel.this.clickLinks) {
                    if (!link.region.contains(e.getPoint())) continue;
                    RulerPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                    RulerPanel.this.setToolTipText(link.tooltipText);
                    return;
                }
                RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                RulerPanel.this.setToolTipText(RulerPanel.this.isWholeGenomeView() ? RulerPanel.WHOLE_GENOME_TOOLTIP : RulerPanel.CHROM_TOOLTIP);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                if (RulerPanel.this.isWholeGenomeView()) {
                    RulerPanel.this.setToolTipText(RulerPanel.WHOLE_GENOME_TOOLTIP);
                } else {
                    RulerPanel.this.setToolTipText(RulerPanel.CHROM_TOOLTIP);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Math.abs(e.getPoint().getX() - (double)RulerPanel.this.dragStart) > 1.0) {
                    RulerPanel.this.dragEnd = e.getX();
                    RulerPanel.this.dragging = true;
                    RulerPanel.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    RulerPanel.this.dragStart = e.getX();
                    this.mouseDown = e;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (RulerPanel.this.dragging) {
                        RulerPanel.this.dragEnd = e.getX();
                        RulerPanel.this.dragging = false;
                        RulerPanel.this.zoom();
                    } else if (this.mouseDown != null && this.distance(this.mouseDown, e) < 5.0) {
                        this.doMouseClick(e);
                    }
                }
            }

            private double distance(MouseEvent e1, MouseEvent e2) {
                double dx = e1.getX() - e2.getX();
                double dy = e1.getY() - e2.getY();
                return Math.sqrt(dx * dx + dy * dy);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doMouseClick(MouseEvent evt) {
                MouseEvent e = evt;
                RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    boolean clickHandled = false;
                    for (ClickLink link : RulerPanel.this.clickLinks) {
                        if (!link.region.contains(e.getPoint())) continue;
                        link.action.accept(link.value);
                        clickHandled = true;
                    }
                    if (!clickHandled && !RulerPanel.this.isWholeGenomeView()) {
                        double newLocation = RulerPanel.this.frame.getChromosomePosition(e);
                        RulerPanel.this.frame.centerOnLocation(newLocation);
                    }
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private void zoom() {
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public void run() {
                double s = RulerPanel.this.frame.getChromosomePosition(RulerPanel.this.dragStart);
                double e = RulerPanel.this.frame.getChromosomePosition(RulerPanel.this.dragEnd);
                if (e < s) {
                    double tmp = s;
                    s = e;
                    e = tmp;
                }
                if (e - s < 40.0) {
                    double c = (s + e) / 2.0;
                    s = c - 20.0;
                    e = c + 20.0;
                }
                s = Math.max(0.0, s);
                String chr = null;
                Genome genome = GenomeManager.getInstance().getCurrentGenome();
                if (RulerPanel.this.isWholeGenomeView()) {
                    ChromosomeCoordinate start = genome.getChromosomeCoordinate((int)s);
                    ChromosomeCoordinate end = genome.getChromosomeCoordinate((int)e);
                    chr = start.getChr();
                    s = start.getCoordinate();
                    e = end.getCoordinate();
                    if (end.getChr() != start.getChr()) {
                        e = genome.getChromosome(start.getChr()).getLength();
                    }
                } else {
                    chr = RulerPanel.this.frame.getChrName();
                    s = Math.max(0.0, s);
                    e = Math.min((double)genome.getChromosome(chr).getLength(), e);
                }
                RulerPanel.this.frame.jumpTo(chr, (int)Math.min(s, e), (int)Math.max(s, e));
                RulerPanel.this.frame.recordHistory();
            }

            @Override
            public String getName() {
                return "Rule panel zoom";
            }
        };
        LongRunningTask.submit(runnable);
    }

    public static class TickSpacing {
        private double majorTick;
        private double minorTick;
        private String majorUnit = "";
        private int unitMultiplier = 1;

        TickSpacing(double majorTick, String majorUnit, int unitMultiplier) {
            this.majorTick = majorTick;
            this.minorTick = majorTick / 10.0;
            this.majorUnit = majorUnit;
            this.unitMultiplier = unitMultiplier;
        }

        public double getMajorTick() {
            return this.majorTick;
        }

        public double getMinorTick() {
            return this.minorTick;
        }

        public String getMajorUnit() {
            return this.majorUnit;
        }

        public void setMajorUnit(String majorUnit) {
            this.majorUnit = majorUnit;
        }

        public int getUnitMultiplier() {
            return this.unitMultiplier;
        }

        public void setUnitMultiplier(int unitMultiplier) {
            this.unitMultiplier = unitMultiplier;
        }
    }

    class ClickLink {
        Shape region;
        Object value;
        String tooltipText;
        Consumer action;

        ClickLink(Shape region, Object value, String tooltipText, Consumer action) {
            this.region = region;
            this.value = value;
            this.tooltipText = tooltipText;
            this.action = action;
        }
    }
}

