/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicBorders;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.aws.S3LoadDialog;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.charts.ScatterPlotUtils;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.GenomeUtils;
import org.broad.igv.lists.GeneListManagerUI;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.oauth.OAuthProvider;
import org.broad.igv.oauth.OAuthUtils;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.tools.IgvToolsGui;
import org.broad.igv.tools.motiffinder.MotifFinderPlugin;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.CombinedDataSourceDialog;
import org.broad.igv.track.Track;
import org.broad.igv.ui.AboutDialog;
import org.broad.igv.ui.DesktopIntegration;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.BrowseEncodeAction;
import org.broad.igv.ui.action.ExportRegionsMenuAction;
import org.broad.igv.ui.action.ExportTrackNamesMenuAction;
import org.broad.igv.ui.action.FilterTracksMenuAction;
import org.broad.igv.ui.action.FitDataToWindowMenuAction;
import org.broad.igv.ui.action.GroupTracksMenuAction;
import org.broad.igv.ui.action.ImportRegionsMenuAction;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.LoadFromDatabaseAction;
import org.broad.igv.ui.action.LoadFromServerAction;
import org.broad.igv.ui.action.LoadFromURLMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.action.NavigateRegionsMenuAction;
import org.broad.igv.ui.action.NewSessionMenuAction;
import org.broad.igv.ui.action.OpenSessionMenuAction;
import org.broad.igv.ui.action.OverlayTracksMenuAction;
import org.broad.igv.ui.action.ReloadSessionMenuAction;
import org.broad.igv.ui.action.ReloadTracksMenuAction;
import org.broad.igv.ui.action.RenameTracksMenuAction;
import org.broad.igv.ui.action.ResetPreferencesAction;
import org.broad.igv.ui.action.RunScriptMenuAction;
import org.broad.igv.ui.action.SaveSessionMenuAction;
import org.broad.igv.ui.action.SelectGenomeAnnotationTracksAction;
import org.broad.igv.ui.action.SetTrackHeightMenuAction;
import org.broad.igv.ui.action.SortTracksMenuAction;
import org.broad.igv.ui.action.UCSCGenArkAction;
import org.broad.igv.ui.commandbar.GenomeComboBox;
import org.broad.igv.ui.commandbar.RemoveGenomesDialog;
import org.broad.igv.ui.legend.LegendDialog;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.ReorderPanelsDialog;
import org.broad.igv.ui.util.AutosaveMenu;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.HistoryMenu;
import org.broad.igv.ui.util.MenuAndToolbarUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.GoogleUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.encode.EncodeFileBrowser;

public class IGVMenuBar
extends JMenuBar
implements IGVEventObserver {
    private static Logger log = LogManager.getLogger(IGVMenuBar.class);
    private static final String LOAD_GENOME_SERVER_TOOLTIP = "Select genomes available on the server to appear in menu.";
    private static final String CANNOT_LOAD_GENOME_SERVER_TOOLTIP = "Could not reach genome server";
    private static IGVMenuBar instance;
    private JMenu extrasMenu;
    private JMenu toolsMenu;
    private JMenu googleMenu;
    private JMenu AWSMenu;
    private AutosaveMenu autosaveMenu;
    private FilterTracksMenuAction filterTracksAction;
    private JMenu viewMenu;
    private IGV igv;
    private JMenuItem loadGenomeFromServerMenuItem;
    private JMenuItem loadTracksFromServerMenuItem;
    private JMenuItem selectGenomeAnnotationsItem;
    private JMenuItem encodeMenuItem;
    private JMenuItem reloadSessionItem;

    static IGVMenuBar createInstance(IGV igv) {
        if (instance != null) {
            if (igv == IGVMenuBar.instance.igv) {
                return instance;
            }
            throw new IllegalStateException("Cannot create another IGVMenuBar, use getInstance");
        }
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            instance = new IGVMenuBar(igv);
        });
        return instance;
    }

    public static IGVMenuBar getInstance() {
        return instance;
    }

    private IGVMenuBar(IGV igv) {
        this.igv = igv;
        this.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        this.setBorderPainted(true);
        for (AbstractButton menu : this.createMenus()) {
            this.add(menu);
        }
        IGVEventBus.getInstance().subscribe(GenomeChangeEvent.class, this);
        if (Globals.IS_MAC) {
            DesktopIntegration.setAboutHandler(this);
            DesktopIntegration.setQuitHandler();
        }
    }

    public void notifyGenomeServerReachable(boolean reachable) {
        if (this.loadGenomeFromServerMenuItem != null) {
            UIUtilities.invokeOnEventThread(() -> {
                this.loadGenomeFromServerMenuItem.setEnabled(reachable);
                String tooltip = reachable ? LOAD_GENOME_SERVER_TOOLTIP : CANNOT_LOAD_GENOME_SERVER_TOOLTIP;
                this.loadGenomeFromServerMenuItem.setToolTipText(tooltip);
            });
        }
    }

    public void showAboutDialog() {
        new AboutDialog(this.igv.getMainFrame(), true).setVisible(true);
    }

    private List<AbstractButton> createMenus() {
        ArrayList<AbstractButton> menus = new ArrayList<AbstractButton>();
        menus.add(this.createFileMenu());
        menus.add(this.createGenomesMenu());
        menus.add(this.createViewMenu());
        menus.add(this.createTracksMenu());
        menus.add(this.createRegionsMenu());
        this.refreshToolsMenu();
        menus.add(this.toolsMenu);
        this.extrasMenu = this.createExtrasMenu();
        menus.add(this.extrasMenu);
        try {
            this.googleMenu = this.createGoogleMenu();
            boolean enabled = PreferencesManager.getPreferences().getAsBoolean("ENABLE_GOOGLE_MENU");
            this.enableGoogleMenu(enabled);
            menus.add(this.googleMenu);
        }
        catch (IOException e) {
            log.error("Error creating google menu: " + e.getMessage());
        }
        this.AWSMenu = this.createAWSMenu();
        this.AWSMenu.setVisible(false);
        menus.add(this.AWSMenu);
        LongRunningTask.submit(this::updateAWSMenu);
        menus.add(this.createHelpMenu());
        return menus;
    }

    public void updateAWSMenu() {
        SwingUtilities.invokeLater(() -> this.AWSMenu.setVisible(AmazonUtils.isAwsProviderPresent()));
    }

    void refreshToolsMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>(10);
        MenuAction menuAction = new RunScriptMenuAction("Run Batch Script...", 88, this.igv);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SortTracksMenuAction("Run igvtools...", 84, this.igv){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgvToolsGui.launch(false, GenomeManager.getInstance().getGenomeId());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(MotifFinderPlugin.getMenuItem());
        menuItems.add(IGVMenuBar.createBlatMenuItem());
        JMenuItem combineDataItem = new JMenuItem("Combine Data Tracks");
        combineDataItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CombinedDataSourceDialog dialog = new CombinedDataSourceDialog(IGVMenuBar.this.igv.getMainFrame());
                dialog.setVisible(true);
            }
        });
        menuItems.add(combineDataItem);
        MenuAction toolsMenuAction = new MenuAction("Tools", null);
        if (this.toolsMenu == null) {
            this.toolsMenu = MenuAndToolbarUtils.createMenu(menuItems, toolsMenuAction);
            this.toolsMenu.setName("Tools");
        } else {
            this.toolsMenu.removeAll();
            for (JComponent item : menuItems) {
                this.toolsMenu.add(item);
            }
        }
    }

    public void enableExtrasMenu() {
        this.extrasMenu.setVisible(true);
    }

    JMenu createFileMenu() {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        String genomeId = genome == null ? null : genome.getId();
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuItems.add(new JSeparator());
        menuAction = new LoadFilesMenuAction("Load from File...", 76, this.igv);
        menuAction.setToolTipText("Load tracks or sample information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load from URL...", 85, this.igv);
        menuAction.setToolTipText("Load tracks or sample information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromServerAction("Load From Server...", 83, this.igv);
        menuAction.setToolTipText("Load tracks or sample information from a server");
        this.loadTracksFromServerMenuItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        this.loadTracksFromServerMenuItem.setVisible(genomeId != null && LoadFromServerAction.getNodeURLs(genomeId) != null);
        menuItems.add(this.loadTracksFromServerMenuItem);
        if (PreferencesManager.getPreferences().getAsBoolean("DB_ENABLED")) {
            menuAction = new LoadFromDatabaseAction("Load from Database...", 0, this.igv);
            menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        }
        this.encodeMenuItem = MenuAndToolbarUtils.createMenuItem(new BrowseEncodeAction("Load from ENCODE (2012)...", 69, this.igv));
        this.encodeMenuItem.setVisible(EncodeFileBrowser.genomeSupported(genomeId));
        menuItems.add(this.encodeMenuItem);
        menuItems.add(new JSeparator());
        menuAction = new ReloadTracksMenuAction("Reload Tracks", -1, this.igv);
        menuAction.setToolTipText("Reload the current session");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new NewSessionMenuAction("New Session...", 78, this.igv);
        menuAction.setToolTipText("Create a new session");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new OpenSessionMenuAction("Open Session...", 79, this.igv);
        menuAction.setToolTipText("Load a session");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SaveSessionMenuAction("Save Session...", 86, this.igv);
        menuAction.setToolTipText("Save the current session");
        JMenuItem saveSessionItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        menuItems.add(saveSessionItem);
        menuAction = new ReloadSessionMenuAction("Reload Session", -1, this.igv);
        menuAction.setToolTipText("Reload the current session");
        this.reloadSessionItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        this.reloadSessionItem.setEnabled(false);
        menuItems.add(this.reloadSessionItem);
        this.autosaveMenu = new AutosaveMenu();
        menuItems.add(this.autosaveMenu);
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Save PNG Image ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getMainPanel(), "png");
            }
        };
        menuAction.setToolTipText("Capture and save a PNG image");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save SVG Image ...", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getMainPanel(), "svg");
            }
        };
        menuAction.setToolTipText("Capture and save an SVG image");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Exit", null, 88){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.doExitApplication();
            }
        };
        menuAction.setToolTipText("Exit the application");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        this.igv.getRecentSessionList().clear();
        String recentSessions = PreferencesManager.getPreferences().getRecentSessions();
        if (recentSessions != null) {
            String[] sessions = recentSessions.split(";");
            for (String sessionPath : sessions) {
                if (sessionPath.equals("null") || this.igv.getRecentSessionList().contains(sessionPath) || !new File(sessionPath).exists()) continue;
                this.igv.getRecentSessionList().add(sessionPath);
            }
        }
        if (!this.igv.getRecentSessionList().isEmpty()) {
            menuItems.add(new JSeparator());
            for (String session : this.igv.getRecentSessionList()) {
                OpenSessionMenuAction osMenuAction = new OpenSessionMenuAction(session, IGV.getInstance());
                menuItems.add(MenuAndToolbarUtils.createMenuItem(osMenuAction));
            }
        }
        MenuAction fileMenuAction = new MenuAction("File", null, 70);
        JMenu fileMenu = MenuAndToolbarUtils.createMenu(menuItems, fileMenuAction);
        return fileMenu;
    }

    private JMenu createGenomesMenu() {
        JMenu menu = new JMenu("Genomes");
        this.loadGenomeFromServerMenuItem = new JMenuItem("Select Hosted Genome...");
        this.loadGenomeFromServerMenuItem.addActionListener(e -> GenomeComboBox.loadGenomeFromServer());
        this.loadGenomeFromServerMenuItem.setToolTipText(LOAD_GENOME_SERVER_TOOLTIP);
        menu.add(this.loadGenomeFromServerMenuItem);
        JMenuItem fileItem = new JMenuItem("Load Genome from File...", 73);
        fileItem.addActionListener(e -> {
            try {
                File file;
                File importDirectory = PreferencesManager.getPreferences().getLastGenomeImportDirectory();
                if (importDirectory == null) {
                    PreferencesManager.getPreferences().setLastGenomeImportDirectory(DirectoryManager.getUserDirectory());
                }
                if ((file = FileDialogUtils.chooseFile("Load Genome", importDirectory, 0)) != null) {
                    GenomeManager.getInstance().loadGenome(file.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage(ex.getMessage(), ex);
            }
        });
        fileItem.setToolTipText("Load a FASTA, .json, or .genome file...");
        menu.add(fileItem);
        LoadFromURLMenuAction urlMenuAction = new LoadFromURLMenuAction("Load Genome from URL...", 0, this.igv);
        urlMenuAction.setToolTipText("Load a FASTA, .json, or .genome file...");
        menu.add(MenuAndToolbarUtils.createMenuItem(urlMenuAction));
        menu.add(new JSeparator());
        UCSCGenArkAction genArkAction = new UCSCGenArkAction("Load Genome from UCSC GenArk...", 0, this.igv);
        menu.add(MenuAndToolbarUtils.createMenuItem(genArkAction));
        MenuAction menuAction = new SelectGenomeAnnotationTracksAction("Select GenArk Tracks...", this.igv);
        this.selectGenomeAnnotationsItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.selectGenomeAnnotationsItem.setEnabled(genome != null && genome.getHub() != null);
        menu.add(this.selectGenomeAnnotationsItem);
        menu.add(new JSeparator());
        menuAction = new MenuAction("Remove Genomes...", null){

            @Override
            public void actionPerformed(ActionEvent event) {
                RemoveGenomesDialog dialog2 = new RemoveGenomesDialog(IGVMenuBar.this.igv.getMainFrame());
                dialog2.setVisible(true);
            }
        };
        menuAction.setToolTipText("Remove genomes which appear in the dropdown list");
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Genome genome = GenomeManager.getInstance().getCurrentGenome();
                IGVMenuBar.this.selectGenomeAnnotationsItem.setEnabled(genome != null && genome.getHub() != null);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return menu;
    }

    private JMenu createTracksMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new SortTracksMenuAction("Sort Tracks...", 83, IGV.getInstance());
        menuAction.setToolTipText("Sort tracks by attribute value");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new GroupTracksMenuAction("Group Tracks... ", 71, IGV.getInstance());
        menuAction.setToolTipText("Group tracks by attribute value");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        this.filterTracksAction = new FilterTracksMenuAction("Filter Tracks...", 70, IGV.getInstance());
        this.filterTracksAction.setToolTipText("Filter tracks by attribute value");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(this.filterTracksAction));
        menuAction = new RenameTracksMenuAction("Rename Tracks... ", 82, IGV.getInstance());
        menuAction.setToolTipText("Rename tracks by attribute value");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new OverlayTracksMenuAction("Overlay Data Tracks... ", 79, IGV.getInstance());
        menuAction.setToolTipText("Overlay data (wig) tracks by attribute value");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        JMenuItem exportNames = new JMenuItem("Export Track Names and Attributes...");
        exportNames.addActionListener(e12 -> {
            List<Track> exportTracks = IGV.getInstance().getSelectedTracks();
            if (exportTracks.size() <= 1) {
                exportTracks = IGV.getInstance().getAllTracks();
            }
            this.exportTrackNames(exportTracks);
        });
        menuItems.add(exportNames);
        menuItems.add(new JSeparator());
        menuAction = new FitDataToWindowMenuAction("Fit Data to Window", 87, IGV.getInstance());
        menuAction.setToolTipText("Resize track heights to make best use of vertical space without scrolling");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SetTrackHeightMenuAction("Set Track Height...", 72, IGV.getInstance());
        menuAction.setToolTipText("Set the height for all tracks");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction dataMenuAction = new MenuAction("Tracks", null, 75);
        return MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
    }

    private JMenu createViewMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("Preferences...", null, 80){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        IGVMenuBar.this.igv.doViewPreferences();
                    }
                });
            }
        };
        menuAction.setToolTipText("Set user specific preferences");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Color Legends ...", null, 72){

            @Override
            public void actionPerformed(ActionEvent e) {
                new LegendDialog(IGVMenuBar.this.igv.getMainFrame()).setVisible(true);
            }
        };
        menuAction.setToolTipText("Edit color legends and scales");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Show Name Panel", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                if (menuItem.isSelected()) {
                    IGVMenuBar.this.igv.getMainPanel().expandNamePanel();
                } else {
                    IGVMenuBar.this.igv.getMainPanel().collapseNamePanel();
                }
            }
        };
        boolean isShowing = this.igv.getMainPanel().isExpanded();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.setSelected(isShowing);
        menuItem.setAction(menuAction);
        menuItems.add(menuItem);
        JMenuItem panelWidthmenuItem = new JMenuItem();
        menuAction = new MenuAction("Set Name Panel Width...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel mainPanel = IGVMenuBar.this.igv.getMainPanel();
                String currentValue = String.valueOf(mainPanel.getNamePanelWidth());
                String newValue = MessageUtils.showInputDialog("Enter track name panel width: ", currentValue);
                if (newValue != null) {
                    try {
                        Integer w = Integer.parseInt(newValue);
                        if (w <= 0) {
                            throw new NumberFormatException();
                        }
                        PreferencesManager.getPreferences().put("NAME_PANEL_WIDTH", newValue);
                        mainPanel.setNamePanelWidth(w);
                    }
                    catch (NumberFormatException ex) {
                        MessageUtils.showErrorMessage("Error: value must be a positive integer.", ex);
                    }
                }
            }
        };
        panelWidthmenuItem.setAction(menuAction);
        menuItems.add(panelWidthmenuItem);
        menuAction = new MenuAction("Show Attribute Display", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                PreferencesManager.getPreferences().setShowAttributeView(menuItem.getState());
                IGVMenuBar.this.igv.revalidateTrackPanels();
            }
        };
        boolean isShow = PreferencesManager.getPreferences().getAsBoolean("IGV.track.show.attribute.views");
        menuItem = MenuAndToolbarUtils.createMenuItem(menuAction, isShow);
        menuItems.add(menuItem);
        menuAction = new MenuAction("Select Attributes to Show...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.doSelectDisplayableAttribute();
            }
        };
        menuAction.setToolTipText("Customize attribute display to show only checked attributes");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Show Header Panel", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                if (menuItem.isSelected()) {
                    IGVMenuBar.this.igv.getMainPanel().restoreHeader();
                } else {
                    IGVMenuBar.this.igv.getMainPanel().removeHeader();
                }
                IGVMenuBar.this.igv.getMainPanel().revalidate();
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction, true));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Reorder Panels...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderPanelsDialog dlg = new ReorderPanelsDialog(IGVMenuBar.this.igv.getMainFrame());
                dlg.setVisible(true);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Add New Panel", null, 83){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newPanelName = "Panel" + System.currentTimeMillis();
                IGVMenuBar.this.igv.addDataPanel(newPanelName);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuItems.add(new HistoryMenu("Go to"));
        MenuAction dataMenuAction = new MenuAction("View", null, 86);
        this.viewMenu = MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
        return this.viewMenu;
    }

    private JMenu createRegionsMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new NavigateRegionsMenuAction("Region Navigator ...", IGV.getInstance());
        menuAction.setToolTipText("Navigate regions");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Gene Lists...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.getInstance(IGVMenuBar.this.igv.getMainFrame()).setVisible(true);
            }
        };
        menuAction.setToolTipText("Open gene list manager");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new ExportRegionsMenuAction("Export Regions ...", 69, IGV.getInstance());
        menuAction.setToolTipText("Save all defined regions to a file");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ImportRegionsMenuAction("Import Regions ...", 73, IGV.getInstance());
        menuAction.setToolTipText("Load regions from a file");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction dataMenuAction = new MenuAction("Regions", null, 86);
        this.viewMenu = MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
        return this.viewMenu;
    }

    private JMenu createHelpMenu() {
        Desktop desktop;
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("User Guide ... "){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL("http://www.broadinstitute.org/igv/UserGuide");
                }
                catch (IOException ex) {
                    log.error("Error opening browser", ex);
                }
            }
        };
        menuAction.setToolTipText("Open web help page");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
            menuAction = new MenuAction("Help Forum..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        URI uri = new URI("http://groups.google.com/forum/#!forum/igv-help");
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception ex) {
                        log.error("Error opening igv-help uri", ex);
                    }
                }
            };
            menuAction.setToolTipText("Email support");
            menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        }
        menuAction = new MenuAction("About IGV "){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog(IGVMenuBar.this.igv.getMainFrame(), true).setVisible(true);
            }
        };
        menuAction.setToolTipText("Display application information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction helpMenuAction = new MenuAction("Help");
        return MenuAndToolbarUtils.createMenu(menuItems, helpMenuAction);
    }

    private JMenu createExtrasMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        JMenuItem memTest = new JMenuItem("Memory test");
        memTest.addActionListener(e -> {
            CommandExecutor exe = new CommandExecutor(this.igv);
            int count = 1;
            int start = 0;
            exe.execute("snapshotDirectory /Users/jrobinso/Downloads/tmp");
            while (count++ < 10000) {
                exe.execute("goto chr1:" + start + "-" + (start + 1000));
                exe.execute("snapshot");
                start += 1000;
            }
        });
        menuItems.add(memTest);
        MenuAction menuAction = null;
        menuAction = new ResetPreferencesAction("Reset Preferences", IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Set window dimensions", null, 67){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] vals;
                String value = JOptionPane.showInputDialog("Enter dimensions, e.g. 800x400");
                if (value != null && (vals = value.split("x")).length == 2) {
                    int w = Integer.parseInt(vals[0]);
                    int h = Integer.parseInt(vals[1]);
                    IGVMenuBar.this.igv.getMainFrame().setSize(w, h);
                }
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save PNG Screenshot ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getContentPane(), "png");
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save SVG Screenshot ...", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getContentPane(), "svg");
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ExportTrackNamesMenuAction("Export track names...", IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Scatter Plot ..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceFrame defaultFrame = FrameManager.getDefaultFrame();
                String chr = defaultFrame.getChrName();
                int start = (int)defaultFrame.getOrigin();
                int end = (int)defaultFrame.getEnd();
                int zoom = defaultFrame.getZoom();
                ScatterPlotUtils.openPlot(chr, start, end, zoom);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction extrasMenuAction = new MenuAction("Extras");
        JMenu menu = MenuAndToolbarUtils.createMenu(menuItems, extrasMenuAction);
        JMenu lfMenu = new JMenu("L&F");
        LookAndFeel lf = UIManager.getLookAndFeel();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            final String lfName = info.getName();
            JMenuItem cb = new JMenuItem(lfName);
            cb.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!lfName.equals(info.getName())) continue;
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            });
            lfMenu.add(cb);
        }
        menu.add(lfMenu);
        JMenuItem updateCS = new JMenuItem("Update chrom sizes");
        updateCS.addActionListener(e -> {
            try {
                GenomeUtils.main(new String[0]);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        });
        menu.add(updateCS);
        menu.setVisible(false);
        return menu;
    }

    private JMenu createAWSMenu() {
        boolean usingCognito = AmazonUtils.GetCognitoConfig() != null;
        JMenu menu = new JMenu("Amazon");
        final JMenuItem login = new JMenuItem("Login");
        login.addActionListener(e -> {
            try {
                OAuthProvider oauth = OAuthUtils.getInstance().getAWSProvider();
                oauth.openAuthorizationPage();
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                log.error("Error fetching oAuth tokens", ex);
            }
        });
        login.setEnabled(usingCognito);
        login.setVisible(usingCognito);
        menu.add(login);
        final JMenuItem logout = new JMenuItem("Logout");
        logout.addActionListener(e -> {
            OAuthProvider oauth = OAuthUtils.getInstance().getAWSProvider();
            oauth.logout();
        });
        logout.setEnabled(false);
        logout.setVisible(usingCognito);
        menu.add(logout);
        final JMenuItem loadS3 = new JMenuItem("Load from S3 bucket");
        loadS3.addActionListener(e -> {
            List<String> buckets = AmazonUtils.ListBucketsForUser();
            log.debug(buckets);
            UIUtilities.invokeOnEventThread(() -> {
                S3LoadDialog dlg = new S3LoadDialog(this.igv.getMainFrame());
                dlg.setModal(true);
                dlg.setVisible(true);
                dlg.dispose();
            });
        });
        loadS3.setEnabled(!usingCognito);
        menu.add(loadS3);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (AmazonUtils.GetCognitoConfig() != null) {
                    Runnable runnable = () -> {
                        OAuthProvider oauth = OAuthUtils.getInstance().getAWSProvider();
                        boolean loggedIn = oauth.isLoggedIn();
                        log.debug("MenuBar is user loggedIn?: " + loggedIn);
                        if (loggedIn) {
                            login.setText(oauth.getCurrentUserName());
                        } else {
                            login.setText("Login ...");
                        }
                        login.setVisible(true);
                        logout.setVisible(true);
                        login.setEnabled(!loggedIn);
                        logout.setEnabled(loggedIn);
                        loadS3.setEnabled(loggedIn);
                    };
                    LongRunningTask.submit(runnable);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return menu;
    }

    private JMenu createGoogleMenu() {
        this.googleMenu = new JMenu("Google");
        final JMenuItem login = new JMenuItem("Login ... ");
        login.addActionListener(e -> {
            try {
                OAuthUtils.getInstance().getGoogleProvider().openAuthorizationPage();
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                log.error("Error fetching oAuth tokens", ex);
            }
        });
        this.googleMenu.add(login);
        final JMenuItem logout = new JMenuItem("Logout ");
        logout.addActionListener(e -> {
            OAuthUtils.getInstance().getGoogleProvider().logout();
            GoogleUtils.setProjectID(null);
        });
        this.googleMenu.add(logout);
        JMenuItem projectID = new JMenuItem("Enter Project ID ...");
        projectID.addActionListener(e -> GoogleUtils.enterGoogleProjectID());
        this.googleMenu.add(projectID);
        this.googleMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                OAuthProvider oauth = OAuthUtils.getInstance().getGoogleProvider();
                boolean loggedIn = oauth.isLoggedIn();
                if (loggedIn && oauth.getCurrentUserName() != null) {
                    login.setText(oauth.getCurrentUserName());
                } else {
                    login.setText("Login ...");
                }
                login.setEnabled(!loggedIn);
                logout.setEnabled(loggedIn);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return this.googleMenu;
    }

    public void enableGoogleMenu(boolean enable) throws IOException {
        this.googleMenu.setVisible(enable);
    }

    public void resetSessionActions() {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.resetTrackFilter();
        }
    }

    public void setFilterMatchAll(boolean value) {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.setFilterMatchAll(value);
        }
    }

    public boolean isFilterMatchAll() {
        if (this.filterTracksAction != null) {
            return this.filterTracksAction.isFilterMatchAll();
        }
        return false;
    }

    public void setFilterShowAllTracks(boolean value) {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.setFilterShowAllTracks(value);
        }
    }

    public boolean isFilterShowAllTracks() {
        if (this.filterTracksAction != null) {
            return this.filterTracksAction.getShowAllTracksFilterCheckBox().isSelected();
        }
        return false;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    public final void doExitApplication() {
        try {
            this.igv.saveStateForExit();
            Frame mainFrame = this.igv.getMainFrame();
            PreferencesManager.getPreferences().setApplicationFrameBounds(mainFrame.getBounds());
            mainFrame.setVisible(false);
            mainFrame.dispose();
        }
        finally {
            System.exit(0);
        }
    }

    static void destroyInstance() {
        instance = null;
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof GenomeChangeEvent) {
            UIUtilities.invokeOnEventThread(() -> {
                Genome genome = ((GenomeChangeEvent)event).genome();
                this.encodeMenuItem.setVisible(EncodeFileBrowser.genomeSupported(genome.getId()));
                this.loadTracksFromServerMenuItem.setVisible(LoadFromServerAction.getNodeURLs(genome.getId()) != null);
            });
        }
    }

    public void enableReloadSession() {
        this.reloadSessionItem.setEnabled(true);
    }

    public void disableReloadSession() {
        this.reloadSessionItem.setEnabled(false);
    }

    public static JMenuItem createBlatMenuItem() {
        JMenuItem menuItem = new JMenuItem("BLAT ...");
        menuItem.addActionListener(e -> {
            String blatSequence = MessageUtils.showInputDialog("Enter sequence to blat:");
            if (blatSequence != null) {
                if (blatSequence.length() < 20 || blatSequence.length() > 8000) {
                    MessageUtils.showMessage("BLAT sequences must be between 20 and 8000 bases in length.");
                } else {
                    BlatClient.doBlatQuery(blatSequence, "BLAT");
                }
            }
        });
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTrackNames(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        File file = FileDialogUtils.chooseFile("Export track names", PreferencesManager.getPreferences().getLastTrackDirectory(), new File("trackNames.txt"), FileDialogUtils.SAVE);
        if (file == null) {
            return;
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            List<String> attributes = AttributeManager.getInstance().getVisibleAttributes();
            pw.print("Name");
            for (String att : attributes) {
                pw.print("\t" + att);
            }
            pw.println();
            for (Track track : selectedTracks) {
                pw.print(track.getName());
                for (String att : attributes) {
                    String val = track.getAttributeValue(att);
                    pw.print("\t" + (val == null ? "" : val));
                }
                pw.println();
            }
        }
    }
}

