/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.sprite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.sprite.Cluster;
import org.broad.igv.feature.sprite.ClusterParser;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClusterTrack
extends AbstractTrack {
    int binSize;
    ClusterParser.ClusterSet clusterSet;
    List<Cluster> binnedClusters;
    List<Cluster> wgClusters;
    int rowHeight = 2;
    Genome genome;

    public ClusterTrack() {
    }

    public ClusterTrack(ResourceLocator locator, ClusterParser.ClusterSet clusterSet, Genome genome) {
        super(locator);
        this.clusterSet = clusterSet;
        this.binSize = clusterSet.binSize;
        this.genome = genome;
        this.binnedClusters = this.computeBinnedClusters(clusterSet.binSize, clusterSet.clusters, genome);
        this.computeWGScores(this.binnedClusters, genome);
    }

    private List<Cluster> computeBinnedClusters(int binSize, List<Cluster> clusters, Genome genome) {
        ArrayList<Cluster> binnedClusters = new ArrayList<Cluster>();
        for (Cluster c : clusters) {
            String name = c.name;
            HashMap<String, List<Integer>> posMap = new HashMap<String, List<Integer>>();
            for (Map.Entry<String, List<Integer>> entry : c.posMap.entrySet()) {
                String chr = genome.getCanonicalChrName(entry.getKey());
                HashSet<Integer> bins = new HashSet<Integer>();
                for (Integer pos : entry.getValue()) {
                    bins.add(pos / binSize * binSize);
                }
                ArrayList binList = new ArrayList(bins);
                Collections.sort(binList);
                posMap.put(chr, binList);
            }
            binnedClusters.add(new Cluster(name, posMap));
        }
        return binnedClusters;
    }

    public void setBinSize(int binSize) {
        this.binSize = binSize;
        this.binnedClusters = this.computeBinnedClusters(this.binSize, this.clusterSet.clusters, this.genome);
        this.computeWGScores(this.binnedClusters, this.genome);
    }

    @Override
    public int getHeight() {
        return this.binnedClusters.size() * this.rowHeight;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return true;
    }

    @Override
    public void load(ReferenceFrame frame) {
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        String chr = context.getReferenceFrame().getChrName();
        double origin = context.getOrigin();
        double locScale = context.getScale();
        double binSize = chr.equals("All") ? (double)(this.binSize / 1000) : (double)this.binSize;
        int y = 0;
        for (Cluster c : this.binnedClusters) {
            List<Integer> loci = c.posMap.get(chr);
            if (loci != null) {
                for (Integer position : loci) {
                    double pixelStart = ((double)position.intValue() - origin) / locScale;
                    double pixelEnd = ((double)position.intValue() + binSize - origin) / locScale;
                    if (!(pixelEnd >= rect.getX()) || !(pixelStart <= rect.getMaxX())) continue;
                    Color color = this.getColor();
                    Graphics2D g = context.getGraphic2DForColor(color);
                    int w = (int)(pixelEnd - pixelStart);
                    if (w < 3) {
                        w = 3;
                        pixelStart -= 1.0;
                    }
                    g.fillRect((int)pixelStart, y, w, this.rowHeight);
                }
            }
            y += this.rowHeight;
        }
    }

    private void computeWGScores(List<Cluster> clusters, Genome genome) {
        int nBins = 1000;
        double binSize = (double)genome.getWGLength() / 1000.0 / (double)nBins;
        HashSet<String> wgChrNames = new HashSet<String>(genome.getLongChromosomeNames());
        for (Cluster cluster : clusters) {
            int[] bins = new int[nBins];
            ArrayList<Integer> occupiedBins = new ArrayList<Integer>();
            for (Map.Entry<String, List<Integer>> entry : cluster.posMap.entrySet()) {
                String chr = entry.getKey();
                if (!wgChrNames.contains(chr)) continue;
                List<Integer> posList = entry.getValue();
                for (Integer pos : posList) {
                    int b;
                    int genomeCoordinate = genome.getGenomeCoordinate(chr, pos);
                    int n = b = (int)((double)genomeCoordinate / binSize);
                    bins[n] = bins[n] + 1;
                }
            }
            for (int i = 0; i < bins.length; ++i) {
                if (bins[i] <= 0) continue;
                occupiedBins.add((int)((double)i * binSize));
            }
            cluster.posMap.put("All", occupiedBins);
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        menu.add(TrackMenuUtils.getTrackRenameItem(Collections.singleton(this)));
        JMenuItem binSizeItem = new JMenuItem("Set Bin Size...");
        binSizeItem.addActionListener(e -> {
            String t = MessageUtils.showInputDialog("Bin Size", String.valueOf(this.binSize));
            if (t != null) {
                try {
                    int bs = Integer.parseInt(t);
                    this.setBinSize(bs);
                    this.repaint();
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showErrorMessage("Bin size must be an integer", e1);
                }
            }
        });
        menu.add(binSizeItem);
        JMenuItem rowHeightItem = new JMenuItem("Set Row Height...");
        rowHeightItem.addActionListener(e -> {
            String t = MessageUtils.showInputDialog("Row height", String.valueOf(this.rowHeight));
            if (t != null) {
                try {
                    int h;
                    this.rowHeight = h = Integer.parseInt(t);
                    this.repaint();
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showErrorMessage("Row height must be a number", e1);
                }
            }
        });
        menu.add(rowHeightItem);
        JMenuItem item = new JMenuItem("Set Track Color...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackColor(Collections.singleton(this)));
        menu.add(item);
        return menu;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        int row = mouseY / this.rowHeight;
        if (row < this.binnedClusters.size()) {
            return this.binnedClusters.get((int)row).name;
        }
        return "";
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        element.setAttribute("binSize", String.valueOf(this.binSize));
        element.setAttribute("sequence", String.valueOf(this.rowHeight));
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        this.binSize = Integer.parseInt(element.getAttribute("binSize"));
        this.rowHeight = Integer.parseInt(element.getAttribute("rowHeight"));
    }
}

