/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.load.HubGenomeLoader;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.session.SessionReader;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.LoadFromURLDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;

public class LoadFromURLMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(LoadFilesMenuAction.class);
    public static final String LOAD_FROM_URL = "Load from URL...";
    public static final String LOAD_GENOME_FROM_URL = "Load Genome from URL...";
    public static final String LOAD_FROM_HTSGET = "Load from htsget Server...";
    public static final String LOAD_TRACKHUB = "Load Track Hub...";
    private IGV igv;

    public LoadFromURLMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel ta = new JPanel();
        ta.setPreferredSize(new Dimension(600, 20));
        boolean isHtsGet = e.getActionCommand().equalsIgnoreCase(LOAD_FROM_HTSGET);
        if (e.getActionCommand().equalsIgnoreCase(LOAD_FROM_URL) || isHtsGet) {
            String inputURLs;
            LoadFromURLDialog dlg = new LoadFromURLDialog(IGV.getInstance().getMainFrame(), isHtsGet);
            dlg.setVisible(true);
            if (!dlg.isCanceled() && (inputURLs = dlg.getFileURL()) != null && inputURLs.trim().length() > 0) {
                String[] inputs = Globals.whitespacePattern.split(inputURLs.trim());
                this.checkURLs(inputs);
                if (inputs.length == 1 && HubGenomeLoader.isHubURL(inputs[0])) {
                    LongRunningTask.submit(() -> {
                        try {
                            GenomeManager.getInstance().loadGenome(inputs[0]);
                        }
                        catch (IOException ex) {
                            log.error("Error loading tack hub", ex);
                            MessageUtils.showMessage("Error loading track hub: " + ex.getMessage());
                        }
                    });
                } else if (inputs.length == 1 && SessionReader.isSessionFile(inputs[0])) {
                    String url = inputs[0];
                    if (url.startsWith("s3://")) {
                        this.checkAWSAccessbility(url);
                    }
                    try {
                        LongRunningTask.submit(() -> this.igv.loadSession(url, null));
                    }
                    catch (Exception ex) {
                        MessageUtils.showMessage("Error loading url: " + url + " (" + ex.toString() + ")");
                    }
                } else {
                    String[] indexes = null;
                    String indexURLs = dlg.getIndexURL();
                    if (indexURLs != null && indexURLs.trim().length() > 0) {
                        indexes = Globals.whitespacePattern.split(indexURLs.trim());
                        if (indexes.length != inputs.length) {
                            throw new RuntimeException("The number of Index URLs must equal the number of File URLs");
                        }
                        this.checkURLs(indexes);
                    }
                    ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
                    for (int i = 0; i < inputs.length; ++i) {
                        String url = inputs[i];
                        ResourceLocator rl = new ResourceLocator(url.trim());
                        if (indexes != null) {
                            String indexUrl = indexes[i];
                            rl.setIndexPath(indexUrl);
                        }
                        if (isHtsGet) {
                            rl.setHtsget(true);
                        }
                        locators.add(rl);
                    }
                    this.igv.loadTracks(locators);
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase(LOAD_GENOME_FROM_URL)) {
            String url = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter URL to .genome or FASTA file", 3);
            if (url != null && url.trim().length() > 0) {
                url = url.trim();
                try {
                    this.checkURLs(new String[]{url});
                    GenomeManager.getInstance().loadGenome(url);
                }
                catch (Exception e1) {
                    MessageUtils.showMessage("Error loading genome: " + e1.getMessage());
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase(LOAD_TRACKHUB)) {
            String url;
            String urlOrAccension = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter GCA or GCF accension, or URL to hub.txt file", 3);
            if (urlOrAccension == null) {
                return;
            }
            if ((urlOrAccension = urlOrAccension.trim()).startsWith("GC")) {
                url = HubGenomeLoader.convertToHubURL(urlOrAccension);
                if (url == null || !FileUtils.resourceExists(url)) {
                    MessageUtils.showMessage("Unrecognized hub identifier: " + urlOrAccension);
                }
            } else {
                url = urlOrAccension;
            }
            if (url != null && url.trim().length() > 0) {
                url = url.trim();
                try {
                    this.checkURLs(new String[]{url});
                    GenomeManager.getInstance().loadGenome(url);
                }
                catch (Exception e1) {
                    MessageUtils.showMessage("Error loading genome: " + e1.getMessage());
                }
            }
        }
    }

    private boolean isHubURL(String input) {
        return input.endsWith("/hub.txt");
    }

    private void checkURLs(String[] urls) {
        for (String url : urls) {
            if (url.startsWith("s3://")) {
                this.checkAWSAccessbility(url);
                continue;
            }
            if (!url.startsWith("ftp://")) continue;
            MessageUtils.showMessage("FTP protocol is not supported");
        }
    }

    private void checkAWSAccessbility(String url) {
        try {
            String key;
            String bucket;
            AmazonUtils.s3ObjectAccessResult res;
            if (AmazonUtils.isAwsS3Path(url).booleanValue() && !(res = AmazonUtils.isObjectAccessible(bucket = AmazonUtils.getBucketFromS3URL(url), key = AmazonUtils.getKeyFromS3URL(url))).isObjectAvailable()) {
                MessageUtils.showErrorMessage(res.getErrorReason(), null);
            }
        }
        catch (NullPointerException npe) {
            AmazonUtils.checkLogin();
        }
    }
}

