/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import java.io.File;
import java.io.IOException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.fasta.FastaUtils;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.Utilities;

public class FastaGenomeLoader
extends GenomeLoader {
    private String genomePath;

    public FastaGenomeLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    @Override
    public Genome loadGenome() throws IOException {
        String name;
        String fastaPath = null;
        Object fastaIndexPath = null;
        if (this.genomePath.endsWith(".fai")) {
            fastaPath = this.genomePath.substring(0, this.genomePath.length() - 4);
            fastaIndexPath = this.genomePath;
        } else {
            fastaPath = this.genomePath;
            fastaIndexPath = this.genomePath + ".fai";
        }
        if (!FileUtils.resourceExists((String)fastaIndexPath) && !FileUtils.isRemote(fastaPath)) {
            fastaIndexPath = fastaPath + ".fai";
            FastaUtils.createIndexFile(fastaPath, (String)fastaIndexPath);
        }
        String id = fastaPath;
        if (HttpUtils.isRemoteURL(fastaPath)) {
            name = Utilities.getFileNameFromURL(fastaPath);
        } else {
            File file = new File(fastaPath);
            if (!file.exists()) {
                throw new IOException(fastaPath + " does not exist, could not load genome");
            }
            name = file.getName();
        }
        GenomeConfig config = new GenomeConfig();
        config.id = id;
        config.name = name;
        config.fastaURL = fastaPath;
        config.indexURL = fastaIndexPath;
        return new Genome(config);
    }
}

