/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JMenuItem;
import org.broad.igv.Globals;
import org.broad.igv.event.AlignmentTrackEvent;
import org.broad.igv.event.DataLoadedEvent;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.jbrowse.CircularViewUtilities;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.AlignmentTrackMenu;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.BaseRenderer;
import org.broad.igv.sam.ByteSubarray;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.Row;
import org.broad.igv.sam.SortOption;
import org.broad.igv.sam.SpliceJunctionTrack;
import org.broad.igv.sam.mods.BaseModficationFilter;
import org.broad.igv.session.Persistable;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.collections.CollUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AlignmentTrack
extends AbstractTrack
implements IGVEventObserver {
    private static final Logger log = LogManager.getLogger(AlignmentTrack.class);
    static final Color DEFAULT_ALIGNMENT_COLOR = new Color(185, 185, 185);
    private static final int GROUP_LABEL_HEIGHT = 10;
    private static final int GROUP_MARGIN = 5;
    private static final int TOP_MARGIN = 20;
    private static final int DS_MARGIN_0 = 2;
    private static final int DOWNSAMPLED_ROW_HEIGHT = 3;
    private static final int INSERTION_ROW_HEIGHT = 9;
    private final AlignmentDataManager dataManager;
    private final SequenceTrack sequenceTrack;
    private final CoverageTrack coverageTrack;
    private final SpliceJunctionTrack spliceJunctionTrack;
    private final Genome genome;
    private ExperimentType experimentType;
    private final AlignmentRenderer renderer;
    RenderOptions renderOptions;
    private boolean removed = false;
    private boolean showGroupLine;
    private int expandedHeight = 14;
    private int collapsedHeight = 9;
    private final int maxSquishedHeight = 5;
    private int squishedHeight = 5;
    private final int minHeight = 50;
    private Rectangle alignmentsRect;
    private Rectangle downsampleRect;
    private Rectangle insertionRect;
    private ColorTable readNamePalette;
    private final HashMap<String, Color> selectedReadNames = new HashMap();
    private final HashMap<ReferenceFrame, Consumer<ReferenceFrame>> actionToPerformOnFrameLoad = new HashMap();

    public static void sortSelectedReadsToTheTop(Set<String> selectedReadNames) {
        HashSet<String> selectedReadNameCopy = new HashSet<String>(selectedReadNames);
        UIUtilities.invokeOnEventThread(() -> IGV.getInstance().sortAlignmentTracks(SortOption.NONE, null, null, false, selectedReadNameCopy));
    }

    public static boolean isBisulfiteColorType(ColorOption o) {
        return o.equals((Object)ColorOption.BISULFITE) || o.equals((Object)ColorOption.NOMESEQ);
    }

    public AlignmentTrack(ResourceLocator locator, AlignmentDataManager dataManager, Genome genome) {
        super(locator);
        String baseName = locator.getTrackName();
        this.setName(baseName);
        this.dataManager = dataManager;
        this.genome = genome;
        this.renderer = new AlignmentRenderer(this);
        this.renderOptions = new RenderOptions(this);
        this.setColor(DEFAULT_ALIGNMENT_COLOR);
        dataManager.setAlignmentTrack(this);
        dataManager.subscribe(this);
        IGVPreferences prefs = this.getPreferences();
        this.minimumHeight = 50;
        this.showGroupLine = prefs.getAsBoolean("SAM.SHOW_GROUP_SEPARATOR");
        try {
            this.setDisplayMode(Track.DisplayMode.valueOf(prefs.get("SAM.DISPLAY_MODE").toUpperCase()));
        }
        catch (Exception e) {
            this.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
        if (prefs.getAsBoolean("SAM.SHOW_REF_SEQ")) {
            this.sequenceTrack = new SequenceTrack("Reference sequence");
            this.sequenceTrack.setHeight(14);
        } else {
            this.sequenceTrack = null;
        }
        this.coverageTrack = new CoverageTrack(locator, baseName + " Coverage", this, genome);
        this.coverageTrack.setDataManager(dataManager);
        dataManager.setCoverageTrack(this.coverageTrack);
        SpliceJunctionTrack spliceJunctionTrack = new SpliceJunctionTrack(locator, baseName + " Junctions", dataManager, this, SpliceJunctionTrack.StrandOption.BOTH);
        spliceJunctionTrack.setHeight(60);
        this.spliceJunctionTrack = spliceJunctionTrack;
        if (this.renderOptions.getColorOption() == ColorOption.BISULFITE) {
            this.setExperimentType(ExperimentType.BISULFITE);
        }
        this.readNamePalette = new PaletteColorTable(ColorUtilities.getDefaultPalette());
        dataManager.setViewAsPairs(prefs.getAsBoolean("SAM.DISPLAY_PAIRED"), this.renderOptions);
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
        IGVEventBus.getInstance().subscribe(AlignmentTrackEvent.class, this);
        IGVEventBus.getInstance().subscribe(DataLoadedEvent.class, this);
    }

    public void init() {
        if (this.experimentType == null || this.experimentType == ExperimentType.UNKOWN) {
            ExperimentType type = this.dataManager.inferType();
            this.setExperimentType(type);
        }
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (!(event instanceof FrameManager.ChangeEvent)) {
            DataLoadedEvent dataLoaded;
            if (event instanceof AlignmentTrackEvent) {
                AlignmentTrackEvent e = (AlignmentTrackEvent)event;
                switch (e.type()) {
                    case ALLELE_THRESHOLD: {
                        this.dataManager.alleleThresholdChanged();
                        break;
                    }
                    case RELOAD: {
                        this.clearCaches();
                        this.repaint();
                        break;
                    }
                    case REFRESH: {
                        this.repaint();
                    }
                }
            } else if (event instanceof DataLoadedEvent && this.dataManager.isLoaded((dataLoaded = (DataLoadedEvent)event).referenceFrame())) {
                this.actionToPerformOnFrameLoad.computeIfPresent(dataLoaded.referenceFrame(), (k, v) -> {
                    v.accept(k);
                    return null;
                });
            }
        }
    }

    void setExperimentType(ExperimentType type) {
        if (type != this.experimentType) {
            boolean showAlignments;
            boolean showCoverage;
            this.experimentType = type;
            boolean showJunction = AlignmentTrack.getPreferences(type).getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
            if (showJunction != this.spliceJunctionTrack.isVisible()) {
                this.spliceJunctionTrack.setVisible(showJunction);
                if (IGV.hasInstance()) {
                    IGV.getInstance().revalidateTrackPanels();
                }
            }
            if ((showCoverage = AlignmentTrack.getPreferences(type).getAsBoolean("SAM.SHOW_COV_TRACK")) != this.coverageTrack.isVisible()) {
                this.coverageTrack.setVisible(showCoverage);
                if (IGV.hasInstance()) {
                    IGV.getInstance().revalidateTrackPanels();
                }
            }
            if ((showAlignments = AlignmentTrack.getPreferences(type).getAsBoolean("SAM.SHOW_ALIGNMENT_TRACK")) != this.isVisible()) {
                this.setVisible(showAlignments);
                if (IGV.hasInstance()) {
                    IGV.getInstance().revalidateTrackPanels();
                }
            }
        }
    }

    public ExperimentType getExperimentType() {
        return this.experimentType;
    }

    public AlignmentDataManager getDataManager() {
        return this.dataManager;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public SpliceJunctionTrack getSpliceJunctionTrack() {
        return this.spliceJunctionTrack;
    }

    public RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public HashMap<String, Color> getSelectedReadNames() {
        return this.selectedReadNames;
    }

    public ColorTable getReadNamePalette() {
        return this.readNamePalette;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return new AlignmentTrackMenu(this, te);
    }

    @Override
    public void setHeight(int preferredHeight) {
        super.setHeight(preferredHeight);
        this.minimumHeight = preferredHeight;
    }

    @Override
    public int getHeight() {
        int nGroups = this.dataManager.getMaxGroupCount();
        int h = Math.max(50, this.getNLevels() * this.getRowHeight() + nGroups * 5 + 20 + 2 + 3);
        return Math.max(this.minimumHeight, h);
    }

    private int getRowHeight() {
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            return this.expandedHeight;
        }
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return this.collapsedHeight;
        }
        return this.squishedHeight;
    }

    private int getNLevels() {
        return this.dataManager.getNLevels();
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        double extent = frame.getEnd() - frame.getOrigin();
        if (frame.getChrName().equals("All") || extent > (double)this.getVisibilityWindow()) {
            return true;
        }
        return this.dataManager.isLoaded(frame);
    }

    @Override
    public void load(ReferenceFrame referenceFrame) {
        if (log.isDebugEnabled()) {
            log.debug("Reading - thread: " + Thread.currentThread().getName());
        }
        this.dataManager.load(referenceFrame, this.renderOptions, true);
    }

    @Override
    public int getVisibilityWindow() {
        return (int)this.dataManager.getVisibilityWindow();
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int seqHeight;
        int viewWindowSize = context.getReferenceFrame().getCurrentRange().getLength();
        if (viewWindowSize > this.getVisibilityWindow()) {
            Rectangle visibleRect = context.getVisibleRect().intersection(rect);
            Graphics2D g2 = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", visibleRect, g2);
            return;
        }
        context.getGraphics2D("LABEL").setFont(FontManager.getFont(10));
        int n = seqHeight = this.sequenceTrack == null ? 0 : this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.render(context, seqRect);
        }
        rect.y += 2;
        this.downsampleRect = new Rectangle(rect);
        this.downsampleRect.height = 3;
        this.renderDownsampledIntervals(context, this.downsampleRect);
        this.alignmentsRect = new Rectangle(rect);
        this.alignmentsRect.y += 2;
        this.alignmentsRect.height -= this.alignmentsRect.y - rect.y;
        this.renderAlignments(context, this.alignmentsRect);
    }

    private void renderDownsampledIntervals(RenderContext context, Rectangle downsampleRect) {
        if (!context.getVisibleRect().intersects(downsampleRect)) {
            return;
        }
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame());
        if (loadedInterval == null) {
            return;
        }
        Graphics2D g = context.getGraphic2DForColor(Color.black);
        List<DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
        for (DownsampledInterval interval : intervals) {
            double scale = context.getScale();
            double origin = context.getOrigin();
            int x0 = (int)(((double)interval.getStart() - origin) / scale);
            int x1 = (int)(((double)interval.getEnd() - origin) / scale);
            int w = Math.max(1, x1 - x0);
            if (w > 5) {
                --w;
            }
            g.fillRect(x0, downsampleRect.y, w, downsampleRect.height);
        }
    }

    private void renderAlignments(RenderContext context, Rectangle inputRect) {
        double h;
        Map<String, PEStats> peStats;
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame(), true);
        if (loadedInterval == null) {
            return;
        }
        AlignmentCounts alignmentCounts = loadedInterval.getCounts();
        PackedAlignments groups = this.dataManager.getGroups(loadedInterval, this.renderOptions);
        if (groups == null) {
            return;
        }
        if (this.renderOptions.getColorOption() == null && this.dataManager.hasYCTags()) {
            this.renderOptions.setColorOption(ColorOption.YC_TAG);
        }
        if ((peStats = this.dataManager.getPEStats()) != null) {
            this.renderOptions.peStats = peStats;
        }
        Rectangle visibleRect = context.getVisibleRect();
        double y = inputRect.getY();
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            h = this.expandedHeight;
        } else if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            h = this.collapsedHeight;
        } else {
            int visHeight = visibleRect.height;
            int depth = this.dataManager.getNLevels();
            this.squishedHeight = depth == 0 ? Math.min(5, Math.max(1, this.expandedHeight)) : Math.min(5, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
            h = this.squishedHeight;
        }
        Graphics2D groupBorderGraphics = context.getGraphic2DForColor(AlignmentRenderer.GROUP_DIVIDER_COLOR);
        int nGroups = groups.size();
        int groupNumber = 0;
        GroupOption groupOption = this.renderOptions.getGroupByOption();
        for (Map.Entry entry : groups.entrySet()) {
            ++groupNumber;
            double yGroup = y;
            List rows = (List)entry.getValue();
            for (Row row : rows) {
                if (visibleRect != null && y > visibleRect.getMaxY()) break;
                assert (visibleRect != null);
                if (y + h > visibleRect.getY()) {
                    Rectangle rowRectangle = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h);
                    this.renderer.renderAlignments(row.alignments, alignmentCounts, context, rowRectangle, this.renderOptions);
                    row.y = y;
                    row.h = h;
                }
                y += h;
            }
            if (groupOption != GroupOption.NONE) {
                double groupHeight;
                if (this.showGroupLine && groupNumber < nGroups) {
                    int borderY = (int)y + 2;
                    GraphicUtils.drawDottedDashLine(groupBorderGraphics, inputRect.x, borderY, inputRect.width, borderY);
                }
                if ((groupHeight = (double)rows.size() * h) > 12.0 && !context.multiframe) {
                    String groupName = (String)entry.getKey();
                    Graphics2D g = context.getGraphics2D("LABEL");
                    FontMetrics fm = g.getFontMetrics();
                    Rectangle2D stringBouds = fm.getStringBounds(groupName, g);
                    Rectangle rect = new Rectangle(inputRect.x, (int)yGroup, (int)stringBouds.getWidth() + 10, (int)stringBouds.getHeight());
                    GraphicUtils.drawVerticallyCenteredText(groupName, 5, rect, g, false, true);
                }
            }
            y += 5.0;
        }
        int bottom = inputRect.y + inputRect.height;
        groupBorderGraphics.drawLine(inputRect.x, bottom, inputRect.width, bottom);
    }

    public void renderExpandedInsertion(InsertionMarker insertionMarker, RenderContext context, Rectangle inputRect) {
        double h;
        boolean leaveMargin = this.getDisplayMode() != Track.DisplayMode.SQUISHED;
        inputRect.y += 7;
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame(), true);
        PackedAlignments groups = this.dataManager.getGroups(loadedInterval, this.renderOptions);
        if (groups == null) {
            return;
        }
        Rectangle visibleRect = context.getVisibleRect();
        double y = inputRect.getY() - 3.0;
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            h = this.expandedHeight;
        } else if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            h = this.collapsedHeight;
        } else {
            int visHeight = visibleRect.height;
            int depth = this.dataManager.getNLevels();
            this.squishedHeight = depth == 0 ? Math.min(5, Math.max(1, this.expandedHeight)) : Math.min(5, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
            h = this.squishedHeight;
        }
        for (Map.Entry entry : groups.entrySet()) {
            List rows = (List)entry.getValue();
            for (Row row : rows) {
                if (visibleRect != null && y > visibleRect.getMaxY()) {
                    return;
                }
                assert (visibleRect != null);
                if (y + h > visibleRect.getY()) {
                    Rectangle rowRectangle = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h);
                    if (row.alignments != null) {
                        BaseRenderer.drawExpandedInsertions(insertionMarker, row.alignments, context, rowRectangle, leaveMargin, this.renderOptions);
                    }
                    row.y = y;
                    row.h = h;
                }
                y += h;
            }
            y += 5.0;
        }
    }

    public void sortRows(SortOption option, Double location, String tag, boolean invertSort, Set<String> priorityRecords) {
        List<ReferenceFrame> frames = FrameManager.getFrames();
        for (ReferenceFrame frame : frames) {
            Consumer<ReferenceFrame> sort = f -> {
                AlignmentInterval interval = this.getDataManager().getLoadedInterval((ReferenceFrame)f);
                double actloc = location != null ? location.doubleValue() : f.getCenter();
                interval.sortRows(option, actloc, tag, invertSort, priorityRecords);
            };
            if (this.getDataManager().isLoaded(frame)) {
                sort.accept(frame);
                continue;
            }
            log.debug("Attempt to sort alignments prior to loading");
            this.actionToPerformOnFrameLoad.put(frame, sort);
        }
    }

    void sortAlignmentTracks(SortOption option, String tag, boolean invertSort) {
        IGV.getInstance().sortAlignmentTracks(option, tag, invertSort);
        Collection<IGVPreferences> allPrefs = PreferencesManager.getAllPreferences();
        for (IGVPreferences prefs : allPrefs) {
            prefs.put("SAM.SORT_OPTION", option.toString());
            prefs.put("SAM.SORT_BY_TAG", tag);
            prefs.put("SAM.INVERT_SORT", invertSort);
        }
    }

    public void groupAlignments(GroupOption option, String tag, Range pos) {
        if (option == GroupOption.TAG && tag != null) {
            this.renderOptions.setGroupByTag(tag);
        }
        if ((option == GroupOption.BASE_AT_POS || option == GroupOption.INSERTION_AT_POS) && pos != null) {
            this.renderOptions.setGroupByPos(pos);
        }
        this.renderOptions.setGroupByOption(option);
        this.dataManager.packAlignments(this.renderOptions);
        this.repaint();
    }

    public void setBisulfiteContext(BisulfiteContext option) {
        this.renderOptions.bisulfiteContext = option;
        this.getPreferences().put("SAM.BISULFITE_CONTEXT", option.toString());
    }

    public void setColorOption(ColorOption option) {
        this.renderOptions.setColorOption(option);
    }

    public void setColorByTag(String tag) {
        this.renderOptions.setColorByTag(tag);
        AlignmentTrack.getPreferences(this.experimentType).put("SAM.COLOR_BY_TAG", tag);
    }

    public void setShadeAlignmentsOptions(ShadeAlignmentsOption option) {
        this.renderOptions.setShadeAlignmentsOption(option);
    }

    public void packAlignments() {
        this.dataManager.packAlignments(this.renderOptions);
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        if (this.downsampleRect != null && mouseY > this.downsampleRect.y && mouseY <= this.downsampleRect.y + this.downsampleRect.height) {
            AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(frame);
            if (loadedInterval == null) {
                return null;
            }
            List<DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
            DownsampledInterval interval = FeatureUtils.getFeatureAt(position, 0, intervals);
            if (interval != null) {
                return interval.getValueString();
            }
            return null;
        }
        Alignment feature = this.getAlignmentAt(position, mouseY, frame);
        if (feature != null) {
            return feature.getAlignmentValueString(position, mouseX, this.renderOptions);
        }
        return null;
    }

    Alignment getAlignmentAt(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        return frame == null ? null : this.getAlignmentAt(frame.getChromosomePosition(e), e.getY(), frame);
    }

    Alignment getAlignmentAt(double position, int y, ReferenceFrame frame) {
        if (this.alignmentsRect == null || this.dataManager == null) {
            return null;
        }
        PackedAlignments groups = this.dataManager.getGroupedAlignmentsContaining(position, frame);
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        for (List rows : groups.values()) {
            for (Row row : rows) {
                if (!((double)y >= row.y) || !((double)y <= row.y + row.h)) continue;
                List<Alignment> features = row.alignments;
                int buffer = 0;
                return FeatureUtils.getFeatureAt(position, buffer, features);
            }
        }
        return null;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        if (Globals.IS_MAC && e.isMetaDown() || !Globals.IS_MAC && e.isControlDown()) {
            Alignment alignment = this.getAlignmentAt(te);
            if (alignment != null) {
                if (this.selectedReadNames.containsKey(alignment.getReadName())) {
                    this.selectedReadNames.remove(alignment.getReadName());
                } else {
                    this.setSelectedAlignment(alignment);
                }
                IGV.getInstance().repaint(this);
            }
            return true;
        }
        if (IGV.getInstance().isShowDetailsOnClick()) {
            this.openTooltipWindow(te);
            return true;
        }
        return false;
    }

    public void setSelectedAlignment(Alignment alignment) {
        Color c = this.readNamePalette.get(alignment.getReadName());
        this.selectedReadNames.put(alignment.getReadName(), c);
    }

    private void clearCaches() {
        if (this.dataManager != null) {
            this.dataManager.clear();
        }
        if (this.spliceJunctionTrack != null) {
            this.spliceJunctionTrack.clear();
        }
    }

    public void setViewAsPairs(boolean vAP) {
        if (vAP && this.renderOptions.getGroupByOption() == GroupOption.STRAND) {
            boolean ungroup = MessageUtils.confirm("\"View as pairs\" is incompatible with \"Group by strand\". Ungroup?");
            if (ungroup) {
                this.renderOptions.setGroupByOption(null);
            } else {
                return;
            }
        }
        this.dataManager.setViewAsPairs(vAP, this.renderOptions);
        this.repaint();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.removed;
    }

    IGVPreferences getPreferences() {
        return AlignmentTrack.getPreferences(this.experimentType);
    }

    public static IGVPreferences getPreferences(ExperimentType type) {
        try {
            if (Globals.VERSION.contains("2.4")) {
                return PreferencesManager.getPreferences("NULL");
            }
            String prefKey = "NULL";
            if (type == ExperimentType.THIRD_GEN) {
                prefKey = "THIRD_GEN";
            } else if (type == ExperimentType.RNA) {
                prefKey = "RNA";
            }
            return PreferencesManager.getPreferences(prefKey);
        }
        catch (NullPointerException e) {
            String prefKey = "NULL";
            if (type == ExperimentType.THIRD_GEN) {
                prefKey = "THIRD_GEN";
            } else if (type == ExperimentType.RNA) {
                prefKey = "RNA";
            }
            return PreferencesManager.getPreferences(prefKey);
        }
    }

    @Override
    public void unload() {
        super.unload();
        if (this.dataManager != null) {
            this.dataManager.unsubscribe(this);
        }
        this.removed = true;
        this.setVisible(false);
    }

    boolean isLinkedReads() {
        return this.renderOptions != null && this.renderOptions.isLinkedReads();
    }

    void setLinkedReadView(boolean linkedReads, String tag) {
        if (!linkedReads || this.isLinkedReadView()) {
            this.undoLinkedReadView();
        }
        this.renderOptions.setLinkedReads(linkedReads);
        if (linkedReads) {
            this.renderOptions.setLinkByTag(tag);
            this.renderOptions.setColorOption(ColorOption.TAG);
            this.renderOptions.setColorByTag(tag);
            if (this.dataManager.isPhased()) {
                this.renderOptions.setGroupByOption(GroupOption.TAG);
                this.renderOptions.setGroupByTag("HP");
            }
            this.showGroupLine = false;
            this.setDisplayMode(Track.DisplayMode.SQUISHED);
        }
        this.dataManager.packAlignments(this.renderOptions);
        this.repaint();
    }

    boolean isLinkedReadView() {
        return this.renderOptions != null && this.renderOptions.isLinkedReads() && this.renderOptions.getLinkByTag() != null && this.renderOptions.getColorOption() == ColorOption.TAG && this.renderOptions.getColorByTag() != null;
    }

    void undoLinkedReadView() {
        this.renderOptions.setLinkByTag(null);
        this.renderOptions.setColorOption(ColorOption.NONE);
        this.renderOptions.setColorByTag(null);
        this.renderOptions.setGroupByOption(GroupOption.NONE);
        this.renderOptions.setGroupByTag(null);
        this.showGroupLine = true;
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
    }

    void sendPairsToCircularView(TrackClickEvent e) {
        List<ReferenceFrame> frames = e.getFrame() != null ? Arrays.asList(e.getFrame()) : FrameManager.getFrames();
        ArrayList<Alignment> inView = new ArrayList<Alignment>();
        for (ReferenceFrame frame : frames) {
            AlignmentInterval interval = this.getDataManager().getLoadedInterval(frame);
            if (interval != null) {
                Iterator<Alignment> iter = interval.getAlignmentIterator();
                Range r = frame.getCurrentRange();
                while (iter.hasNext()) {
                    boolean isDiscordantPair;
                    Alignment a = iter.next();
                    if (a.getEnd() <= r.getStart() || a.getStart() >= r.getEnd() || !(isDiscordantPair = a.isPaired() && a.getMate().isMapped() && (!a.getMate().getChr().equals(a.getChr()) || Math.abs(a.getInferredInsertSize()) > 10000))) continue;
                    inView.add(a);
                }
            }
            Color chordColor = this.getColor().equals(DEFAULT_ALIGNMENT_COLOR) ? Color.BLUE : this.getColor();
            CircularViewUtilities.sendAlignmentsToJBrowse(inView, this.getName(), chordColor);
        }
    }

    void sendSplitToCircularView(TrackClickEvent e) {
        List<ReferenceFrame> frames = e.getFrame() != null ? Arrays.asList(e.getFrame()) : FrameManager.getFrames();
        ArrayList<Alignment> inView = new ArrayList<Alignment>();
        for (ReferenceFrame frame : frames) {
            AlignmentInterval interval = this.getDataManager().getLoadedInterval(frame);
            if (interval != null) {
                Iterator<Alignment> iter = interval.getAlignmentIterator();
                Range r = frame.getCurrentRange();
                while (iter.hasNext()) {
                    Alignment a = iter.next();
                    if (a.getEnd() <= r.getStart() || a.getStart() >= r.getEnd() || a.getAttribute("SA") == null) continue;
                    inView.add(a);
                }
            }
            Color chordColor = this.getColor().equals(DEFAULT_ALIGNMENT_COLOR) ? Color.BLUE : this.getColor();
            CircularViewUtilities.sendAlignmentsToJBrowse(inView, this.getName(), chordColor);
        }
    }

    AlignmentBlock getInsertion(Alignment alignment, int pixelX) {
        if (alignment != null && alignment.getInsertions() != null) {
            for (AlignmentBlock block : alignment.getInsertions()) {
                if (!block.containsPixel(pixelX)) continue;
                return block;
            }
        }
        return null;
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        NodeList tmp;
        super.unmarshalXML(element, version);
        if (element.hasAttribute("experimentType")) {
            this.experimentType = ExperimentType.valueOf(element.getAttribute("experimentType"));
        }
        if ((tmp = element.getElementsByTagName("RenderOptions")).getLength() > 0) {
            Element renderElement = (Element)tmp.item(0);
            this.renderOptions = new RenderOptions(this);
            this.renderOptions.unmarshalXML(renderElement, version);
        }
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        if (this.experimentType != null) {
            element.setAttribute("experimentType", this.experimentType.toString());
        }
        Element sourceElement = document.createElement("RenderOptions");
        this.renderOptions.marshalXML(document, sourceElement);
        element.appendChild(sourceElement);
    }

    public static enum ColorOption {
        INSERT_SIZE,
        READ_STRAND,
        FIRST_OF_PAIR_STRAND,
        PAIR_ORIENTATION,
        READ_ORDER,
        SAMPLE,
        READ_GROUP,
        LIBRARY,
        MOVIE,
        ZMW,
        BISULFITE,
        NOMESEQ,
        TAG,
        NONE,
        UNEXPECTED_PAIR,
        MAPPED_SIZE,
        LINK_STRAND,
        YC_TAG,
        BASE_MODIFICATION,
        BASE_MODIFICATION_2COLOR,
        SMRT_SUBREAD_IPD,
        SMRT_SUBREAD_PW,
        SMRT_CCS_FWD_IPD,
        SMRT_CCS_FWD_PW,
        SMRT_CCS_REV_IPD,
        SMRT_CCS_REV_PW;


        public boolean isBaseMod() {
            return this == BASE_MODIFICATION || this == BASE_MODIFICATION_2COLOR;
        }

        public boolean isSMRTKinetics() {
            switch (this) {
                case SMRT_SUBREAD_IPD: 
                case SMRT_SUBREAD_PW: 
                case SMRT_CCS_FWD_IPD: 
                case SMRT_CCS_REV_IPD: 
                case SMRT_CCS_FWD_PW: 
                case SMRT_CCS_REV_PW: {
                    return true;
                }
            }
            return false;
        }
    }

    public static class RenderOptions
    implements Cloneable,
    Persistable {
        public static final String NAME = "RenderOptions";
        private static final Logger log = LogManager.getLogger(RenderOptions.class);
        private AlignmentTrack track;
        private Boolean shadeBasesOption;
        private Boolean shadeCenters;
        private Boolean flagUnmappedPairs;
        private Boolean showAllBases;
        private Integer minInsertSize;
        private Integer maxInsertSize;
        private ColorOption colorOption;
        private SortOption sortOption;
        private GroupOption groupByOption;
        private ShadeAlignmentsOption shadeAlignmentsOption;
        private Integer mappingQualityLow;
        private Integer mappingQualityHigh;
        private boolean viewPairs = false;
        private String colorByTag;
        private String groupByTag;
        private String sortByTag;
        private String linkByTag;
        private Boolean linkedReads;
        private Boolean quickConsensusMode;
        private Boolean showMismatches;
        private Boolean insertQualColoring;
        Boolean computeIsizes;
        private Double minInsertSizePercentile;
        private Double maxInsertSizePercentile;
        private Boolean pairedArcView;
        private Boolean flagZeroQualityAlignments;
        private Range groupByPos;
        private Boolean invertSorting;
        private boolean invertGroupSorting;
        private Boolean hideSmallIndels;
        private Integer smallIndelThreshold;
        private BaseModficationFilter basemodFilter;
        private Float basemodThreshold;
        private int baseQualityMin;
        private int baseQualityMax;
        private Integer minJunctionCoverage;
        BisulfiteContext bisulfiteContext = BisulfiteContext.CG;
        Map<String, PEStats> peStats;

        RenderOptions(AlignmentTrack track) {
            this.track = track;
            this.peStats = new HashMap<String, PEStats>();
            this.baseQualityMin = track == null ? 5 : track.getPreferences().getAsInt("SAM.BASE_QUALITY_MIN");
            this.baseQualityMax = track == null ? 20 : track.getPreferences().getAsInt("SAM.BASE_QUALITY_MAX");
        }

        IGVPreferences getPreferences() {
            return this.track != null ? this.track.getPreferences() : AlignmentTrack.getPreferences(ExperimentType.OTHER);
        }

        public int getMinJunctionCoverage() {
            return this.minJunctionCoverage != null ? this.minJunctionCoverage.intValue() : PreferencesManager.getPreferences("RNA").getAsInt("SAM.JUNCTION_MIN_COVERAGE");
        }

        public void setMinJunctionCoverage(int minJunctionCoverage) {
            this.minJunctionCoverage = minJunctionCoverage;
        }

        public int getBaseQualityMin() {
            return this.baseQualityMin;
        }

        public int getBaseQualityMax() {
            return this.baseQualityMax;
        }

        void setShowAllBases(boolean showAllBases) {
            this.showAllBases = showAllBases;
        }

        void setShowMismatches(boolean showMismatches) {
            this.showMismatches = showMismatches;
        }

        void setMinInsertSize(int minInsertSize) {
            this.minInsertSize = minInsertSize;
        }

        public void setViewPairs(boolean viewPairs) {
            this.viewPairs = viewPairs;
        }

        void setInsertQualColoring(boolean insertQualColoring) {
            this.insertQualColoring = insertQualColoring;
        }

        void setComputeIsizes(boolean computeIsizes) {
            this.computeIsizes = computeIsizes;
        }

        void setMaxInsertSizePercentile(double maxInsertSizePercentile) {
            this.maxInsertSizePercentile = maxInsertSizePercentile;
        }

        void setMaxInsertSize(int maxInsertSize) {
            this.maxInsertSize = maxInsertSize;
        }

        void setMinInsertSizePercentile(double minInsertSizePercentile) {
            this.minInsertSizePercentile = minInsertSizePercentile;
        }

        void setColorByTag(String colorByTag) {
            this.colorByTag = colorByTag;
        }

        void setColorOption(ColorOption colorOption) {
            this.colorOption = colorOption;
        }

        void setSortOption(SortOption sortOption) {
            this.sortOption = sortOption;
        }

        void setSortByTag(String sortByTag) {
            this.sortByTag = sortByTag;
        }

        void setGroupByTag(String groupByTag) {
            this.groupByTag = groupByTag;
        }

        void setGroupByPos(Range groupByPos) {
            this.groupByPos = groupByPos;
        }

        void setInvertSorting(boolean invertSorting) {
            this.invertSorting = invertSorting;
        }

        void setInvertGroupSorting(boolean invertGroupSorting) {
            this.invertGroupSorting = invertGroupSorting;
        }

        void setLinkByTag(String linkByTag) {
            this.linkByTag = linkByTag;
        }

        void setQuickConsensusMode(boolean quickConsensusMode) {
            this.quickConsensusMode = quickConsensusMode;
        }

        public void setGroupByOption(GroupOption groupByOption) {
            this.groupByOption = groupByOption == null ? GroupOption.NONE : groupByOption;
        }

        void setShadeAlignmentsOption(ShadeAlignmentsOption shadeAlignmentsOption) {
            this.shadeAlignmentsOption = shadeAlignmentsOption;
        }

        void setShadeBasesOption(boolean shadeBasesOption) {
            this.shadeBasesOption = shadeBasesOption;
        }

        void setLinkedReads(boolean linkedReads) {
            this.linkedReads = linkedReads;
        }

        public void setHideSmallIndels(boolean hideSmallIndels) {
            this.hideSmallIndels = hideSmallIndels;
        }

        public void setSmallIndelThreshold(int smallIndelThreshold) {
            this.smallIndelThreshold = smallIndelThreshold;
        }

        public int getMinInsertSize() {
            return this.minInsertSize == null ? this.getPreferences().getAsInt("SAM.MIN_INSERT_SIZE_THRESHOLD") : this.minInsertSize.intValue();
        }

        public int getMaxInsertSize() {
            return this.maxInsertSize == null ? this.getPreferences().getAsInt("SAM.INSERT_SIZE_THRESHOLD") : this.maxInsertSize.intValue();
        }

        public boolean isFlagUnmappedPairs() {
            return this.flagUnmappedPairs == null ? this.getPreferences().getAsBoolean("SAM.FLAG_UNMAPPED_PAIR") : this.flagUnmappedPairs.booleanValue();
        }

        public boolean getShadeBasesOption() {
            return this.shadeBasesOption == null ? this.getPreferences().getAsBoolean("SAM.SHADE_BASE_QUALITY") : this.shadeBasesOption.booleanValue();
        }

        public boolean isShowMismatches() {
            return this.showMismatches == null ? this.getPreferences().getAsBoolean("SAM.SHOW_MISMATCHES") : this.showMismatches.booleanValue();
        }

        public boolean isShowAllBases() {
            return this.showAllBases == null ? this.getPreferences().getAsBoolean("SAM.SHOW_ALL_BASES") : this.showAllBases.booleanValue();
        }

        public boolean isShadeCenters() {
            return this.shadeCenters == null ? this.getPreferences().getAsBoolean("SAM.SHADE_CENTER") : this.shadeCenters.booleanValue();
        }

        public boolean isFlagZeroQualityAlignments() {
            return this.flagZeroQualityAlignments == null ? this.getPreferences().getAsBoolean("SAM.FLAG_ZERO_QUALITY") : this.flagZeroQualityAlignments.booleanValue();
        }

        public boolean isViewPairs() {
            return this.viewPairs;
        }

        public boolean isInsertQualColoring() {
            return this.insertQualColoring == null ? this.getPreferences().getAsBoolean("SAM.INSERT_QUAL_COLORING") : this.insertQualColoring.booleanValue();
        }

        public boolean isComputeIsizes() {
            return this.computeIsizes == null ? this.getPreferences().getAsBoolean("SAM.COMPUTE_ISIZES") : this.computeIsizes.booleanValue();
        }

        public double getMinInsertSizePercentile() {
            return this.minInsertSizePercentile == null ? (double)this.getPreferences().getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE") : this.minInsertSizePercentile;
        }

        public double getMaxInsertSizePercentile() {
            return this.maxInsertSizePercentile == null ? (double)this.getPreferences().getAsFloat("SAM.ISIZE_MAX_PERCENTILE") : this.maxInsertSizePercentile;
        }

        public ColorOption getColorOption() {
            return this.colorOption == null ? CollUtils.valueOf(ColorOption.class, this.getPreferences().get("SAM.COLOR_BY"), ColorOption.NONE) : this.colorOption;
        }

        public String getColorByTag() {
            return this.colorByTag == null ? this.getPreferences().get("SAM.COLOR_BY_TAG") : this.colorByTag;
        }

        public ShadeAlignmentsOption getShadeAlignmentsOption() {
            if (this.shadeAlignmentsOption != null) {
                return this.shadeAlignmentsOption;
            }
            try {
                return ShadeAlignmentsOption.valueOf(this.getPreferences().get("SAM.SHADE_ALIGNMENT_BY"));
            }
            catch (IllegalArgumentException e) {
                log.error("Error parsing alignment shade option: " + ShadeAlignmentsOption.valueOf(this.getPreferences().get("SAM.SHADE_ALIGNMENT_BY")));
                return ShadeAlignmentsOption.NONE;
            }
        }

        public int getMappingQualityLow() {
            return this.mappingQualityLow == null ? this.getPreferences().getAsInt("SAM.SHADE_QUALITY_LOW") : this.mappingQualityLow.intValue();
        }

        public int getMappingQualityHigh() {
            return this.mappingQualityHigh == null ? this.getPreferences().getAsInt("SAM.SHADE_QUALITY_HIGH") : this.mappingQualityHigh.intValue();
        }

        SortOption getSortOption() {
            return this.sortOption == null ? (SortOption)CollUtils.valueOf(SortOption.class, this.getPreferences().get("SAM.SORT_OPTION"), null) : this.sortOption;
        }

        String getSortByTag() {
            return this.sortByTag == null ? this.getPreferences().get("SAM.SORT_BY_TAG") : this.sortByTag;
        }

        public String getGroupByTag() {
            return this.groupByTag == null ? this.getPreferences().get("SAM.GROUP_BY_TAG") : this.groupByTag;
        }

        public Range getGroupByPos() {
            String pos;
            if (this.groupByPos == null && (pos = this.getPreferences().get("SAM.GROUP_BY_POS")) != null) {
                String[] posParts = pos.split(" ");
                if (posParts.length != 2) {
                    this.groupByPos = null;
                } else {
                    int posChromStart = Integer.parseInt(posParts[1]);
                    this.groupByPos = new Range(posParts[0], posChromStart, posChromStart + 1);
                }
            }
            return this.groupByPos;
        }

        public boolean isInvertSorting() {
            return this.invertSorting == null ? this.getPreferences().getAsBoolean("SAM.INVERT_SORT") : this.invertSorting.booleanValue();
        }

        public boolean isInvertGroupSorting() {
            return this.invertGroupSorting;
        }

        public String getLinkByTag() {
            return this.linkByTag;
        }

        public GroupOption getGroupByOption() {
            GroupOption gbo = this.groupByOption;
            gbo = gbo == null ? CollUtils.valueOf(GroupOption.class, this.getPreferences().get("SAM.GROUP_OPTION"), GroupOption.NONE) : gbo;
            gbo = gbo == null ? GroupOption.NONE : gbo;
            return gbo;
        }

        public boolean isLinkedReads() {
            return this.linkedReads != null && this.linkedReads != false;
        }

        public boolean isQuickConsensusMode() {
            return this.quickConsensusMode == null ? this.getPreferences().getAsBoolean("SAM.QUICK_CONSENSUS_MODE") : this.quickConsensusMode.booleanValue();
        }

        public boolean isHideSmallIndels() {
            return this.hideSmallIndels == null ? this.getPreferences().getAsBoolean("SAM.HIDE_SMALL_INDEL") : this.hideSmallIndels.booleanValue();
        }

        public int getSmallIndelThreshold() {
            return this.smallIndelThreshold == null ? this.getPreferences().getAsInt("SAM.SMALL_INDEL_BP_THRESHOLD") : this.smallIndelThreshold.intValue();
        }

        public BaseModficationFilter getBasemodFilter() {
            return this.basemodFilter;
        }

        public float getBasemodThreshold() {
            return this.basemodThreshold == null ? this.getPreferences().getAsFloat("BASEMOD.THRESHOLD") : this.basemodThreshold.floatValue();
        }

        public void setBasemodThreshold(float basemodThreshold) {
            this.basemodThreshold = Float.valueOf(basemodThreshold);
        }

        public void setBasemodFilter(BaseModficationFilter basemodFilter) {
            this.basemodFilter = basemodFilter;
        }

        @Override
        public void marshalXML(Document document, Element element) {
            if (this.shadeBasesOption != null) {
                element.setAttribute("shadeBasesOption", this.shadeBasesOption.toString());
            }
            if (this.shadeCenters != null) {
                element.setAttribute("shadeCenters", this.shadeCenters.toString());
            }
            if (this.flagUnmappedPairs != null) {
                element.setAttribute("flagUnmappedPairs", this.flagUnmappedPairs.toString());
            }
            if (this.showAllBases != null) {
                element.setAttribute("showAllBases", this.showAllBases.toString());
            }
            if (this.minInsertSize != null) {
                element.setAttribute("minInsertSize", this.minInsertSize.toString());
            }
            if (this.maxInsertSize != null) {
                element.setAttribute("maxInsertSize", this.maxInsertSize.toString());
            }
            if (this.colorOption != null) {
                element.setAttribute("colorOption", this.colorOption.toString());
            }
            if (this.groupByOption != null) {
                element.setAttribute("groupByOption", this.groupByOption.toString());
            }
            if (this.shadeAlignmentsOption != null) {
                element.setAttribute("shadeAlignmentsByOption", this.shadeAlignmentsOption.toString());
            }
            if (this.mappingQualityLow != null) {
                element.setAttribute("mappingQualityLow", this.mappingQualityLow.toString());
            }
            if (this.mappingQualityHigh != null) {
                element.setAttribute("mappingQualityHigh", this.mappingQualityHigh.toString());
            }
            if (this.viewPairs) {
                element.setAttribute("viewPairs", Boolean.toString(this.viewPairs));
            }
            if (this.colorByTag != null) {
                element.setAttribute("colorByTag", this.colorByTag);
            }
            if (this.groupByTag != null) {
                element.setAttribute("groupByTag", this.groupByTag);
            }
            if (this.sortByTag != null) {
                element.setAttribute("sortByTag", this.sortByTag);
            }
            if (this.linkByTag != null) {
                element.setAttribute("linkByTag", this.linkByTag);
            }
            if (this.linkedReads != null) {
                element.setAttribute("linkedReads", this.linkedReads.toString());
            }
            if (this.quickConsensusMode != null) {
                element.setAttribute("quickConsensusMode", this.quickConsensusMode.toString());
            }
            if (this.showMismatches != null) {
                element.setAttribute("showMismatches", this.showMismatches.toString());
            }
            if (this.computeIsizes != null) {
                element.setAttribute("computeIsizes", this.computeIsizes.toString());
            }
            if (this.minInsertSizePercentile != null) {
                element.setAttribute("minInsertSizePercentile", this.minInsertSizePercentile.toString());
            }
            if (this.maxInsertSizePercentile != null) {
                element.setAttribute("maxInsertSizePercentile", this.maxInsertSizePercentile.toString());
            }
            if (this.pairedArcView != null) {
                element.setAttribute("pairedArcView", this.pairedArcView.toString());
            }
            if (this.flagZeroQualityAlignments != null) {
                element.setAttribute("flagZeroQualityAlignments", this.flagZeroQualityAlignments.toString());
            }
            if (this.groupByPos != null) {
                element.setAttribute("groupByPos", this.groupByPos.toString());
            }
            if (this.invertSorting != null) {
                element.setAttribute("invertSorting", Boolean.toString(this.invertSorting));
            }
            if (this.sortOption != null) {
                element.setAttribute("sortOption", this.sortOption.toString());
            }
            if (this.invertGroupSorting) {
                element.setAttribute("invertGroupSorting", Boolean.toString(this.invertGroupSorting));
            }
            if (this.hideSmallIndels != null) {
                element.setAttribute("hideSmallIndels", this.hideSmallIndels.toString());
            }
            if (this.smallIndelThreshold != null) {
                element.setAttribute("smallIndelThreshold", this.smallIndelThreshold.toString());
            }
            if (this.basemodFilter != null) {
                element.setAttribute("basemodFilter", this.basemodFilter.toString());
            }
            if (this.basemodThreshold != null) {
                element.setAttribute("basemodThredhold", String.valueOf(this.basemodThreshold));
            }
            if (this.minJunctionCoverage != null) {
                element.setAttribute("minJunctionCoverage", String.valueOf(this.minJunctionCoverage));
            }
        }

        @Override
        public void unmarshalXML(Element element, Integer version) {
            String v;
            if (element.hasAttribute("shadeBasesOption") && (v = element.getAttribute("shadeBasesOption")) != null) {
                this.shadeBasesOption = v.equalsIgnoreCase("quality") || v.equalsIgnoreCase("true");
            }
            if (element.hasAttribute("shadeCenters")) {
                this.shadeCenters = Boolean.parseBoolean(element.getAttribute("shadeCenters"));
            }
            if (element.hasAttribute("showAllBases")) {
                this.showAllBases = Boolean.parseBoolean(element.getAttribute("showAllBases"));
            }
            if (element.hasAttribute("flagUnmappedPairs")) {
                this.flagUnmappedPairs = Boolean.parseBoolean(element.getAttribute("flagUnmappedPairs"));
            }
            if (element.hasAttribute("minInsertSize")) {
                this.minInsertSize = Integer.parseInt(element.getAttribute("minInsertSize"));
            }
            if (element.hasAttribute("maxInsertSize")) {
                this.maxInsertSize = Integer.parseInt(element.getAttribute("maxInsertSize"));
            }
            if (element.hasAttribute("colorOption")) {
                String attributeValue = element.getAttribute("colorOption");
                if ("BASE_MODIFICATION_6MA".equals(attributeValue)) {
                    this.colorOption = ColorOption.BASE_MODIFICATION;
                    this.basemodFilter = new BaseModficationFilter("a");
                } else {
                    this.colorOption = "BASE_MODIFICATION_5MC".equals(attributeValue) ? ColorOption.BASE_MODIFICATION_2COLOR : ("BASE_MODIFICATION_C".equals(attributeValue) ? ColorOption.BASE_MODIFICATION : ColorOption.valueOf(attributeValue));
                }
            }
            if (element.hasAttribute("sortOption")) {
                this.sortOption = SortOption.valueOf(element.getAttribute("sortOption"));
            }
            if (element.hasAttribute("groupByOption")) {
                this.groupByOption = GroupOption.valueOf(element.getAttribute("groupByOption"));
            }
            if (element.hasAttribute("shadeAlignmentsByOption")) {
                this.shadeAlignmentsOption = ShadeAlignmentsOption.valueOf(element.getAttribute("shadeAlignmentsByOption"));
            }
            if (element.hasAttribute("mappingQualityLow")) {
                this.mappingQualityLow = Integer.parseInt(element.getAttribute("mappingQualityLow"));
            }
            if (element.hasAttribute("mappingQualityHigh")) {
                this.mappingQualityHigh = Integer.parseInt(element.getAttribute("mappingQualityHigh"));
            }
            if (element.hasAttribute("viewPairs")) {
                this.viewPairs = Boolean.parseBoolean(element.getAttribute("viewPairs"));
            }
            if (element.hasAttribute("colorByTag")) {
                this.colorByTag = element.getAttribute("colorByTag");
            }
            if (element.hasAttribute("groupByTag")) {
                this.groupByTag = element.getAttribute("groupByTag");
            }
            if (element.hasAttribute("sortByTag")) {
                this.sortByTag = element.getAttribute("sortByTag");
            }
            if (element.hasAttribute("linkByTag")) {
                this.linkByTag = element.getAttribute("linkByTag");
            }
            if (element.hasAttribute("linkedReads")) {
                this.linkedReads = Boolean.parseBoolean(element.getAttribute("linkedReads"));
            }
            if (element.hasAttribute("quickConsensusMode")) {
                this.quickConsensusMode = Boolean.parseBoolean(element.getAttribute("quickConsensusMode"));
            }
            if (element.hasAttribute("showMismatches")) {
                this.showMismatches = Boolean.parseBoolean(element.getAttribute("showMismatches"));
            }
            if (element.hasAttribute("computeIsizes")) {
                this.computeIsizes = Boolean.parseBoolean(element.getAttribute("computeIsizes"));
            }
            if (element.hasAttribute("minInsertSizePercentile")) {
                this.minInsertSizePercentile = Double.parseDouble(element.getAttribute("minInsertSizePercentile"));
            }
            if (element.hasAttribute("maxInsertSizePercentile")) {
                this.maxInsertSizePercentile = Double.parseDouble(element.getAttribute("maxInsertSizePercentile"));
            }
            if (element.hasAttribute("pairedArcView")) {
                this.pairedArcView = Boolean.parseBoolean(element.getAttribute("pairedArcView"));
            }
            if (element.hasAttribute("flagZeroQualityAlignments")) {
                this.flagZeroQualityAlignments = Boolean.parseBoolean(element.getAttribute("flagZeroQualityAlignments"));
            }
            if (element.hasAttribute("groupByPos")) {
                this.groupByPos = Range.fromString(element.getAttribute("groupByPos"));
            }
            if (element.hasAttribute("invertSorting")) {
                this.invertSorting = Boolean.parseBoolean(element.getAttribute("invertSorting"));
            }
            if (element.hasAttribute("invertGroupSorting")) {
                this.invertGroupSorting = Boolean.parseBoolean(element.getAttribute("invertGroupSorting"));
            }
            if (element.hasAttribute("hideSmallIndels")) {
                this.hideSmallIndels = Boolean.parseBoolean(element.getAttribute("hideSmallIndels"));
            }
            if (element.hasAttribute("smallIndelThreshold")) {
                this.smallIndelThreshold = Integer.parseInt(element.getAttribute("smallIndelThreshold"));
            }
            if (element.hasAttribute("showInsertionMarkers")) {
                // empty if block
            }
            if (element.hasAttribute("basemodFilter")) {
                this.basemodFilter = BaseModficationFilter.fromString(element.getAttribute("basemodFilter"));
            }
            if (element.hasAttribute("basemodThreshold")) {
                this.basemodFilter = BaseModficationFilter.fromString(element.getAttribute("basemodThreshold"));
            }
            if (element.hasAttribute("minJunctionCoverage")) {
                this.minJunctionCoverage = Integer.parseInt(element.getAttribute("minJunctionCoverage"));
            }
        }
    }

    public static enum ExperimentType {
        OTHER,
        RNA,
        BISULFITE,
        THIRD_GEN,
        UNKOWN;

    }

    public static enum GroupOption {
        STRAND("read strand"),
        SAMPLE("sample"),
        READ_GROUP("read group"),
        LIBRARY("library"),
        FIRST_OF_PAIR_STRAND("first-in-pair strand"),
        TAG("tag"),
        PAIR_ORIENTATION("pair orientation"),
        MATE_CHROMOSOME("chromosome of mate"),
        NONE("none"),
        CHIMERIC("chimeric"),
        SUPPLEMENTARY("supplementary flag"),
        BASE_AT_POS("base at position"),
        INSERTION_AT_POS("insertion at position", true),
        MOVIE("movie"),
        ZMW("ZMW"),
        HAPLOTYPE("haplotype"),
        READ_ORDER("read order"),
        LINKED("linked"),
        PHASE("phase"),
        REFERENCE_CONCORDANCE("reference concordance"),
        MAPPING_QUALITY("mapping quality");

        public final String label;
        public final boolean reverse;

        private GroupOption(String label) {
            this.label = label;
            this.reverse = false;
        }

        private GroupOption(String label, boolean reverse) {
            this.label = label;
            this.reverse = reverse;
        }
    }

    public static enum BisulfiteContext {
        CG("CG", new byte[0], new byte[]{71}),
        CHH("CHH", new byte[0], new byte[]{72, 72}),
        CHG("CHG", new byte[0], new byte[]{72, 71}),
        HCG("HCG", new byte[]{72}, new byte[]{71}),
        GCH("GCH", new byte[]{71}, new byte[]{72}),
        WCG("WCG", new byte[]{87}, new byte[]{71}),
        NONE("None", null, null);

        private final String label;
        private final byte[] preContext;
        private final byte[] postContext;

        private static boolean positionMatchesContext(byte contextb, byte referenceBase, byte readBase) {
            boolean matchesContext = AlignmentUtils.compareBases(contextb, referenceBase);
            if (!matchesContext) {
                return false;
            }
            boolean matchesReadContext = AlignmentUtils.compareBases(contextb, readBase);
            if (AlignmentUtils.compareBases((byte)84, readBase)) {
                matchesReadContext |= AlignmentUtils.compareBases(contextb, (byte)67);
            }
            return matchesReadContext;
        }

        public BisulfiteContext getMatchingBisulfiteContext(byte[] reference, ByteSubarray read, int idx) {
            int offsetidx;
            byte contextb;
            boolean matchesContext = true;
            int minLen = Math.min(reference.length, read.length);
            if (idx + this.postContext.length >= minLen) {
                matchesContext = false;
            } else {
                for (int posti = 0; matchesContext && posti < this.postContext.length; matchesContext &= BisulfiteContext.positionMatchesContext(contextb, reference[offsetidx], read.getByte(offsetidx)), ++posti) {
                    contextb = this.postContext[posti];
                    offsetidx = idx + 1 + posti;
                }
            }
            if (idx - this.preContext.length < 0) {
                matchesContext = false;
            } else {
                for (int prei = 0; matchesContext && prei < this.preContext.length; matchesContext &= BisulfiteContext.positionMatchesContext(contextb, reference[offsetidx], read.getByte(offsetidx)), ++prei) {
                    contextb = this.preContext[prei];
                    offsetidx = idx - (this.preContext.length - prei);
                }
            }
            return matchesContext ? this : null;
        }

        public String getLabel() {
            return this.label;
        }

        private BisulfiteContext(String label, byte[] preContext, byte[] postContext) {
            this.label = label;
            this.preContext = preContext;
            this.postContext = postContext;
        }
    }

    public static enum ShadeAlignmentsOption {
        NONE("none"),
        MAPPING_QUALITY_HIGH("mapping quality high"),
        MAPPING_QUALITY_LOW("mapping quality low");

        public final String label;

        private ShadeAlignmentsOption(String label) {
            this.label = label;
        }
    }

    static class InsertionMenu
    extends IGVPopupMenu {
        final AlignmentBlock insertion;

        InsertionMenu(AlignmentBlock insertion) {
            this.insertion = insertion;
            this.addCopySequenceItem();
            if (insertion.getBases() != null && insertion.getBases().length > 10) {
                this.addBlatItem();
            }
        }

        void addCopySequenceItem() {
            JMenuItem item = new JMenuItem("Copy insert sequence");
            this.add(item);
            item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(this.insertion.getBases().getString()));
        }

        void addBlatItem() {
            JMenuItem item = new JMenuItem("BLAT insert sequence");
            this.add(item);
            item.addActionListener(aEvt -> {
                String blatSeq = this.insertion.getBases().getString();
                BlatClient.doBlatQuery(blatSeq, "BLAT insert sequence");
            });
            item.setEnabled(this.insertion.getBases() != null && this.insertion.getBases().length >= 10);
        }

        @Override
        public boolean includeStandardItems() {
            return false;
        }
    }

    static enum OrientationType {
        RR,
        LL,
        RL,
        LR,
        UNKNOWN;

    }
}

