/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ClippingCounts {
    private static final ClippingCounts NO_CLIPPING = new ClippingCounts(0, 0, 0, 0);
    public static final Pattern LCLIP_PATTERN = Pattern.compile("^(([0-9]+)H)?(([0-9]+)S)?");
    public static final Pattern RCLIP_PATTERN = Pattern.compile("(([0-9]+)S)?(([0-9]+)H)?$");
    private final int leftHard;
    private final int leftSoft;
    private final int rightHard;
    private final int rightSoft;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClippingCounts)) {
            return false;
        }
        ClippingCounts that = (ClippingCounts)o;
        if (this.leftHard != that.leftHard) {
            return false;
        }
        if (this.leftSoft != that.leftSoft) {
            return false;
        }
        if (this.rightHard != that.rightHard) {
            return false;
        }
        return this.rightSoft == that.rightSoft;
    }

    public int hashCode() {
        int result = this.leftHard;
        result = 31 * result + this.leftSoft;
        result = 31 * result + this.rightHard;
        result = 31 * result + this.rightSoft;
        return result;
    }

    public ClippingCounts(int leftHard, int leftSoft, int rightSoft, int rightHard) {
        this.leftHard = leftHard;
        this.leftSoft = leftSoft;
        this.rightHard = rightHard;
        this.rightSoft = rightSoft;
    }

    public static ClippingCounts fromCigar(Cigar cigar) {
        int i;
        if (cigar == null || cigar.isEmpty() || !cigar.isClipped()) {
            return NO_CLIPPING;
        }
        int numberOfElements = cigar.numCigarElements();
        int leftHard = 0;
        int leftSoft = 0;
        int rightSoft = 0;
        int rightHard = 0;
        for (i = 0; i < 2 && i <= numberOfElements; ++i) {
            CigarElement element = cigar.getCigarElement(i);
            CigarOperator operator = element.getOperator();
            if (operator != CigarOperator.H) {
                if (operator != CigarOperator.S) break;
                leftSoft = element.getLength();
                break;
            }
            leftHard = element.getLength();
        }
        for (int j = numberOfElements - 1; j > numberOfElements - 3 && j > i && j > 0; --j) {
            CigarElement element = cigar.getCigarElement(j);
            CigarOperator operator = element.getOperator();
            if (operator != CigarOperator.H) {
                if (operator != CigarOperator.S) break;
                rightSoft = element.getLength();
                break;
            }
            rightHard = element.getLength();
        }
        return new ClippingCounts(leftHard, leftSoft, rightSoft, rightHard);
    }

    public static ClippingCounts fromCigarString(String cigarString) {
        Matcher lclipMatcher = LCLIP_PATTERN.matcher(cigarString);
        Matcher rclipMatcher = RCLIP_PATTERN.matcher(cigarString);
        int lclipHard = 0;
        int lclipSoft = 0;
        int rclipHard = 0;
        int rclipSoft = 0;
        if (lclipMatcher.find()) {
            lclipHard = lclipMatcher.group(2) == null ? 0 : Integer.parseInt(lclipMatcher.group(2), 10);
            int n = lclipSoft = lclipMatcher.group(4) == null ? 0 : Integer.parseInt(lclipMatcher.group(4), 10);
        }
        if (rclipMatcher.find()) {
            rclipHard = rclipMatcher.group(4) == null ? 0 : Integer.parseInt(rclipMatcher.group(4), 10);
            rclipSoft = rclipMatcher.group(2) == null ? 0 : Integer.parseInt(rclipMatcher.group(2), 10);
        }
        return new ClippingCounts(lclipHard, lclipSoft, rclipSoft, rclipHard);
    }

    public boolean isClipped() {
        return this.leftHard + this.leftSoft + this.rightHard + this.rightSoft > 0;
    }

    public int getLeftHard() {
        return this.leftHard;
    }

    public int getLeftSoft() {
        return this.leftSoft;
    }

    public int getRightHard() {
        return this.rightHard;
    }

    public int getRightSoft() {
        return this.rightSoft;
    }

    public boolean isLeftClipped() {
        return this.getLeft() > 0;
    }

    public int getLeft() {
        return this.leftSoft + this.leftHard;
    }

    public boolean isRightClipped() {
        return this.getRight() > 0;
    }

    public int getRight() {
        return this.rightSoft + this.rightHard;
    }

    public String toString() {
        return "<" + this.leftHard + "H" + this.leftSoft + "S|" + this.rightSoft + "S" + this.rightHard + "H>";
    }
}

