/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.lists;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class GeneList {
    private String group;
    private boolean editable = true;
    private String name;
    private String description;
    private List<String> loci;

    public GeneList(String name, String description, String group, List<String> loci) {
        this.group = group;
        this.description = description;
        this.name = name;
        this.loci = loci;
    }

    public GeneList(String name, List<String> loci) {
        this(name, null, "My lists", loci);
    }

    public GeneList() {
        this.group = "My lists";
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLoci() {
        return this.loci;
    }

    public int size() {
        return this.loci == null ? 0 : this.loci.size();
    }

    public void add(String gene) {
        if (this.loci == null) {
            this.loci = new ArrayList<String>(1);
        }
        try {
            this.loci.add(gene);
        }
        catch (Exception e) {
            this.loci = new ArrayList<String>(this.loci);
            this.loci.add(gene);
        }
    }

    public GeneList copy() {
        return new GeneList(this.name + " copy", this.loci);
    }

    public void setLoci(List<String> strings) {
        this.loci = strings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getGroup() {
        return this.group;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void sort(Comparator<String> comparator) {
        this.loci.sort(comparator);
    }
}

