/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.broad.igv.Globals;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.InMemorySequence;
import org.broad.igv.feature.genome.load.GenbankParser;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.IGV;

public class GenbankLoader
extends GenomeLoader {
    private String genomePath;

    public GenbankLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    @Override
    public Genome loadGenome() throws IOException {
        GenbankParser genbankParser = new GenbankParser(this.genomePath);
        genbankParser.readFeatures(true);
        Object name = genbankParser.getLocusName();
        String chr = genbankParser.getChr();
        if (!((String)name).equals(chr)) {
            name = (String)name + " (" + chr + ")";
        }
        byte[] seq = genbankParser.getSequence();
        InMemorySequence sequence = new InMemorySequence(chr, seq);
        GenomeConfig config = new GenomeConfig();
        config.id = chr;
        config.name = name;
        config.sequence = sequence;
        String[] aliases = genbankParser.getAliases();
        if (aliases != null) {
            ArrayList<String> aliasList = new ArrayList<String>();
            aliasList.add(chr);
            for (String a : aliases) {
                aliasList.add(a);
            }
            config.chromAliases = Arrays.asList(aliasList);
        }
        Genome genome = new Genome(config);
        if (IGV.hasInstance() && !Globals.isHeadless()) {
            FeatureDB.addFeatures(genbankParser.getFeatures(), genome);
            FeatureTrack geneFeatureTrack = GenbankLoader.createGeneTrack(genome, genbankParser.getFeatures());
            genome.setGeneTrack(geneFeatureTrack);
        }
        return genome;
    }
}

