/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SBIIndexWriter;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeEOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class BAMSBIIndexer {
    public static void createIndex(Path bamFile, long granularity) throws IOException {
        Path splittingBaiFile = IOUtil.addExtension(bamFile, ".sbi");
        try (SeekablePathStream in = new SeekablePathStream(bamFile);
             OutputStream out = Files.newOutputStream(splittingBaiFile, new OpenOption[0]);){
            BAMSBIIndexer.createIndex(in, out, granularity);
        }
    }

    public static void createIndex(SeekableStream in, OutputStream out, long granularity) throws IOException {
        long recordStart = SAMUtils.findVirtualOffsetOfFirstRecordInBam(in);
        BlockCompressedInputStream blockIn = new BlockCompressedInputStream(in);
        try {
            blockIn.seek(recordStart);
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            SBIIndexWriter indexWriter = new SBIIndexWriter(out, granularity);
            try {
                while (true) {
                    recordStart = blockIn.getFilePointer();
                    InputStreamUtils.readFully(blockIn, byteBuffer.array(), 0, 4);
                    int blockSize = byteBuffer.getInt(0);
                    indexWriter.processRecord(recordStart);
                    InputStreamUtils.skipFully(blockIn, blockSize);
                }
            }
            catch (RuntimeEOFException e) {
                indexWriter.finish(recordStart, in.length());
                blockIn.close();
            }
        }
        catch (Throwable throwable) {
            try {
                blockIn.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

