/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.BAIEntry;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class BAMIndexMetaData {
    private long noCoordinateRecords = 0L;
    private long firstOffset = -1L;
    private long lastOffset = 0L;
    private int alignedRecords = 0;
    private int unAlignedRecords = 0;

    BAMIndexMetaData() {
        this.noCoordinateRecords = 0L;
        this.newReference();
    }

    BAMIndexMetaData(List<Chunk> chunkList) {
        this.noCoordinateRecords = 0L;
        if (chunkList != null && !chunkList.isEmpty() && chunkList.size() != 2) {
            throw new SAMException("Unexpected number of metadata chunks " + chunkList.size());
        }
        boolean firstChunk = true;
        if (chunkList != null) {
            for (Chunk c : chunkList) {
                long start = c.getChunkStart();
                long end = c.getChunkEnd();
                if (firstChunk) {
                    this.firstOffset = start;
                    this.lastOffset = end;
                    firstChunk = false;
                    continue;
                }
                firstChunk = true;
                this.alignedRecords = (int)start;
                this.unAlignedRecords = (int)end;
            }
        }
    }

    private BAMIndexMetaData(long firstOffset, long lastOffset, int alignedRecords, int unAlignedRecords) {
        this.firstOffset = firstOffset;
        this.lastOffset = lastOffset;
        this.alignedRecords = alignedRecords;
        this.unAlignedRecords = unAlignedRecords;
    }

    public int getAlignedRecordCount() {
        return this.alignedRecords;
    }

    public int getUnalignedRecordCount() {
        return this.unAlignedRecords;
    }

    void newReference() {
        this.firstOffset = -1L;
        this.lastOffset = 0L;
        this.alignedRecords = 0;
        this.unAlignedRecords = 0;
    }

    void recordMetaData(SAMRecord rec) {
        int alignmentStart = rec.getAlignmentStart();
        if (alignmentStart == 0) {
            this.incrementNoCoordinateRecordCount();
            return;
        }
        if (rec.getFileSource() == null) {
            throw new SAMException("BAM cannot be indexed without setting a fileSource for record " + rec);
        }
        Chunk newChunk = ((BAMFileSpan)rec.getFileSource().getFilePointer()).getSingleChunk();
        long start = newChunk.getChunkStart();
        long end = newChunk.getChunkEnd();
        if (rec.getReadUnmappedFlag()) {
            ++this.unAlignedRecords;
        } else {
            ++this.alignedRecords;
        }
        if (BlockCompressedFilePointerUtil.compare(start, this.firstOffset) < 1 || this.firstOffset == -1L) {
            this.firstOffset = start;
        }
        if (BlockCompressedFilePointerUtil.compare(this.lastOffset, end) < 1) {
            this.lastOffset = end;
        }
    }

    void recordMetaData(BAIEntry baiEntry) {
        this.alignedRecords += baiEntry.getMappedReadsCount();
        this.noCoordinateRecords += (long)baiEntry.getUnmappedUnplacedReadsCount();
        this.unAlignedRecords += baiEntry.getUnmappedReadsCount();
        long start = baiEntry.getSliceByteOffsetFromCompressionHeaderStart();
        if (BlockCompressedFilePointerUtil.compare(start, this.firstOffset) < 1 || this.firstOffset == -1L) {
            this.firstOffset = start;
            this.lastOffset = start;
        }
    }

    void incrementNoCoordinateRecordCount() {
        ++this.noCoordinateRecords;
    }

    private void setNoCoordinateRecordCount(long count) {
        this.noCoordinateRecords = count;
    }

    long getNoCoordinateRecordCount() {
        return this.noCoordinateRecords;
    }

    long getFirstOffset() {
        return this.firstOffset;
    }

    long getLastOffset() {
        return this.lastOffset;
    }

    BAMIndexMetaData shift(long offset) {
        long newFirstOffset = this.firstOffset == -1L ? this.firstOffset : BlockCompressedFilePointerUtil.shift(this.firstOffset, offset);
        long newLastOffset = this.lastOffset == 0L ? this.lastOffset : BlockCompressedFilePointerUtil.shift(this.lastOffset, offset);
        return new BAMIndexMetaData(newFirstOffset, newLastOffset, this.alignedRecords, this.unAlignedRecords);
    }

    public static void printIndexStats(File inputBamFile) {
        try {
            BAMFileReader bam = new BAMFileReader(inputBamFile, null, false, false, ValidationStringency.SILENT, (SAMRecordFactory)new DefaultSAMRecordFactory());
            if (!bam.hasIndex() || bam.getIndexType() == null) {
                throw new SAMException("No index for bam file " + inputBamFile);
            }
            BAMIndexMetaData[] data = BAMIndexMetaData.getIndexStats(bam);
            if (data == null) {
                throw new SAMException("Exception in getting index statistics");
            }
            int nRefs = bam.getFileHeader().getSequenceDictionary().size();
            for (int i = 0; i < nRefs; ++i) {
                SAMSequenceRecord seq = bam.getFileHeader().getSequence(i);
                if (seq == null) continue;
                String sequenceName = seq.getSequenceName();
                int sequenceLength = seq.getSequenceLength();
                System.out.print(sequenceName + " length=\t" + sequenceLength);
                if (data[i] == null) {
                    System.out.println();
                    continue;
                }
                System.out.println("\tAligned= " + data[i].getAlignedRecordCount() + "\tUnaligned= " + data[i].getUnalignedRecordCount());
            }
            System.out.println("NoCoordinateCount= " + data[0].getNoCoordinateRecordCount());
        }
        catch (IOException e) {
            throw new SAMException("Exception in getting index statistics", e);
        }
    }

    public static BAMIndexMetaData[] getIndexStats(BAMFileReader bam) {
        Long noCoordCount;
        AbstractBAMFileIndex index = (AbstractBAMFileIndex)bam.getIndex();
        int nRefs = index.getNumberOfReferences();
        BAMIndexMetaData[] result = new BAMIndexMetaData[nRefs == 0 ? 1 : nRefs];
        for (int i = 0; i < nRefs; ++i) {
            result[i] = index.getMetaData(i);
        }
        if (result[0] == null) {
            result[0] = new BAMIndexMetaData();
        }
        if ((noCoordCount = index.getNoCoordinateCount()) != null) {
            result[0].setNoCoordinateRecordCount(noCoordCount);
        }
        return result;
    }
}

