/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.Track;
import org.broad.igv.ucsc.Hub;
import org.broad.igv.ucsc.HubTrackSelectionDialog;
import org.broad.igv.ucsc.TrackConfigGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class SelectGenomeAnnotationTracksAction
extends MenuAction {
    static Logger log = LogManager.getLogger(SelectGenomeAnnotationTracksAction.class);
    IGV mainFrame;
    static HashSet<String> failedURLs = new HashSet();

    public SelectGenomeAnnotationTracksAction(String label, IGV mainFrame) {
        super(label, null);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        Hub hub = genome.getHub();
        if (hub == null) {
            MessageUtils.showMessage("No annotation tracks available for current genome.");
        }
        List<Track> loadedTracks = IGV.getInstance().getAllTracks().stream().filter(t -> t.getResourceLocator() != null).toList();
        HashSet<String> loadedTrackPaths = new HashSet<String>(loadedTracks.stream().map(t -> t.getResourceLocator().getPath()).toList());
        List<TrackConfigGroup> groups = hub.getGroupedTrackConfigurations();
        for (TrackConfigGroup g : groups) {
            for (TrackConfig config : g.tracks) {
                config.visible = loadedTrackPaths.contains(config.url);
            }
        }
        HubTrackSelectionDialog dlg = new HubTrackSelectionDialog(groups, IGV.getInstance().getMainFrame());
        dlg.setVisible(true);
        HashSet<String> trackPathsToRemove = new HashSet<String>();
        ArrayList<TrackConfig> tracksToLoad = new ArrayList<TrackConfig>();
        ArrayList<TrackConfig> selected = new ArrayList<TrackConfig>();
        for (TrackConfigGroup g : groups) {
            for (TrackConfig config : g.tracks) {
                if (config.visible.booleanValue()) {
                    selected.add(config);
                    if (loadedTrackPaths.contains(config.url)) continue;
                    tracksToLoad.add(config);
                    continue;
                }
                trackPathsToRemove.add(config.url);
            }
        }
        List<Track> tracksToRemove = loadedTracks.stream().filter(t -> trackPathsToRemove.contains(t.getResourceLocator().getPath())).toList();
        IGV.getInstance().deleteTracks(tracksToRemove);
        List<ResourceLocator> locators = tracksToLoad.stream().map(t -> ResourceLocator.fromTrackConfig(t)).toList();
        IGV.getInstance().loadTracks(locators);
        genome.setAnnotationResources(selected.stream().map(c -> ResourceLocator.fromTrackConfig(c)).toList());
        String key = "hub:" + hub.getUrl();
        PreferencesManager.getPreferences().put(key, String.join((CharSequence)",", selected.stream().map(c -> c.name).toList()));
    }
}

