/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.IOPathResource;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.Log;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.json.JSONException;
import org.json.JSONObject;

public class BundleJSON {
    public static final String BUNDLE_EXTENSION = ".json";
    private static final Log LOG = Log.getInstance(BundleJSON.class);
    public static final String JSON_PROPERTY_SCHEMA_NAME = "schemaName";
    public static final String JSON_PROPERTY_SCHEMA_VERSION = "schemaVersion";
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    public static final String JSON_PROPERTY_PATH = "path";
    public static final String JSON_PROPERTY_FORMAT = "format";
    public static final String JSON_SCHEMA_NAME = "htsbundle";
    public static final String JSON_SCHEMA_VERSION = "0.1.0";
    private static final Set<String> TOP_LEVEL_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(BundleJSON.JSON_PROPERTY_SCHEMA_NAME);
            this.add(BundleJSON.JSON_PROPERTY_SCHEMA_VERSION);
            this.add(BundleJSON.JSON_PROPERTY_PRIMARY);
        }
    });

    public static String toJSON(Bundle bundle) {
        JSONObject outerJSON = new JSONObject().put(JSON_PROPERTY_SCHEMA_NAME, (Object)JSON_SCHEMA_NAME).put(JSON_PROPERTY_SCHEMA_VERSION, (Object)JSON_SCHEMA_VERSION).put(JSON_PROPERTY_PRIMARY, (Object)bundle.getPrimaryContentType());
        bundle.forEach(bundleResource -> {
            Optional<IOPath> resourcePath = bundleResource.getIOPath();
            if (!resourcePath.isPresent()) {
                throw new IllegalArgumentException("Bundle resource requires a valid path to be serialized");
            }
            JSONObject resourceJSON = new JSONObject().put(JSON_PROPERTY_PATH, (Object)resourcePath.get().getURIString());
            if (bundleResource.getFileFormat().isPresent()) {
                resourceJSON.put(JSON_PROPERTY_FORMAT, (Object)bundleResource.getFileFormat().get());
            }
            outerJSON.put(bundleResource.getContentType(), (Object)resourceJSON);
        });
        return outerJSON.toString(1);
    }

    public static Bundle toBundle(String jsonString) {
        return BundleJSON.toBundle(ValidationUtils.nonEmpty(jsonString, "resource list"), HtsPath::new);
    }

    public static <T extends IOPath> Bundle toBundle(String jsonString, Function<String, T> ioPathConstructor) {
        String primaryContentType;
        ValidationUtils.nonEmpty(jsonString, "JSON string");
        ValidationUtils.nonNull(ioPathConstructor, "IOPath-derived class constructor");
        ArrayList<BundleResource> resources = new ArrayList<BundleResource>();
        try {
            JSONObject jsonDocument = new JSONObject(jsonString);
            if (jsonString.length() < 1) {
                throw new IllegalArgumentException(String.format("JSON file parsing failed %s", jsonString));
            }
            String schemaName = BundleJSON.getRequiredPropertyAsString(jsonDocument, JSON_PROPERTY_SCHEMA_NAME);
            if (!schemaName.equals(JSON_SCHEMA_NAME)) {
                throw new IllegalArgumentException(String.format("Expected bundle schema name %s but found %s", JSON_SCHEMA_NAME, schemaName));
            }
            String schemaVersion = BundleJSON.getRequiredPropertyAsString(jsonDocument, JSON_PROPERTY_SCHEMA_VERSION);
            if (!schemaVersion.equals(JSON_SCHEMA_VERSION)) {
                throw new IllegalArgumentException(String.format("Expected bundle schema version %s but found %s", JSON_SCHEMA_VERSION, schemaVersion));
            }
            primaryContentType = BundleJSON.getRequiredPropertyAsString(jsonDocument, JSON_PROPERTY_PRIMARY);
            jsonDocument.keySet().forEach(contentType -> {
                Object patt5733$temp = jsonDocument.get(contentType);
                if (!(patt5733$temp instanceof JSONObject)) {
                    return;
                }
                JSONObject jsonDoc = (JSONObject)patt5733$temp;
                if (!TOP_LEVEL_PROPERTIES.contains(contentType)) {
                    String format = jsonDoc.optString(JSON_PROPERTY_FORMAT, null);
                    IOPathResource ioPathResource = new IOPathResource((IOPath)ioPathConstructor.apply(BundleJSON.getRequiredPropertyAsString(jsonDoc, JSON_PROPERTY_PATH)), (String)contentType, format == null ? null : jsonDoc.optString(JSON_PROPERTY_FORMAT, null));
                    resources.add(ioPathResource);
                }
            });
            if (resources.isEmpty()) {
                LOG.warn("Empty resource bundle found: ", jsonString);
            }
        }
        catch (UnsupportedOperationException | JSONException e) {
            throw new IllegalArgumentException(e);
        }
        return new Bundle(primaryContentType, resources);
    }

    private static String getRequiredPropertyAsString(JSONObject jsonDocument, String propertyName) {
        String propertyValue = jsonDocument.optString(propertyName, null);
        if (propertyValue == null) {
            throw new IllegalArgumentException(String.format("JSON bundle is missing the required property %s (%s)", propertyName, jsonDocument));
        }
        return propertyValue;
    }
}

