/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ultima.annotate;

import htsjdk.samtools.SAMRecord;
import org.apache.commons.lang3.StringUtils;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.ByteSubarray;
import org.broad.igv.sam.SAMAlignment;

public class FlowBlockAnnotator {
    private static final String KEY_ATTR = "ti,tp";

    public boolean handlesBlocks(AlignmentBlock block) {
        return block.getBases() != null && block.getQualities() != null;
    }

    public void appendBlockQualityAnnotation(SAMAlignment samAlignment, AlignmentBlock block, StringBuffer buf) {
        if (this.isFlow(samAlignment.getRecord())) {
            buf.append(" @ QV " + FlowBlockAnnotator.qualsAsString(block.getQualities()) + this.attrAsString(samAlignment, block, KEY_ATTR, -1));
        }
    }

    public void appendBlockAttrAnnotation(SAMAlignment samAlignment, AlignmentBlock block, int offset, StringBuffer buf) {
        if (this.isFlow(samAlignment.getRecord())) {
            buf.append(this.attrAsString(samAlignment, block, KEY_ATTR, offset));
        }
    }

    private boolean isFlow(SAMRecord record) {
        for (String name : KEY_ATTR.split(",")) {
            if (!record.hasAttribute(name)) continue;
            return true;
        }
        return false;
    }

    private int[] attrAsIntegers(SAMAlignment samAlignment, AlignmentBlock block, String name, int offset, StringBuilder sbName) {
        Object value = null;
        for (String name1 : name.split(",")) {
            value = samAlignment.getRecord().getAttribute(name1);
            if (value == null) continue;
            name = name1;
            if (sbName == null) break;
            sbName.append(name);
            break;
        }
        if (value == null) {
            return new int[0];
        }
        byte[] arr = (byte[])value;
        if (offset >= 0) {
            int[] integers = new int[1];
            int start = block.getIndexOnRead();
            integers[0] = arr[start + offset];
            return integers;
        }
        int start = block.getIndexOnRead();
        int length = block.getLength();
        int[] integers = new int[length];
        for (int ofs = start; ofs < start + length; ++ofs) {
            integers[ofs - start] = arr[ofs];
        }
        return integers;
    }

    private String attrAsString(SAMAlignment samAlignment, AlignmentBlock block, String name, int offset) {
        StringBuilder sb = new StringBuilder(" ");
        int[] integers = this.attrAsIntegers(samAlignment, block, name, offset, sb);
        if (integers == null) {
            return "";
        }
        sb.append(" ");
        sb.append(StringUtils.join((int[])integers, (char)','));
        Object r = sb.toString();
        if (((String)r).length() > 40) {
            r = ((String)r).substring(0, 40) + "...";
        }
        return r;
    }

    public static String qualsAsString(ByteSubarray quals) {
        StringBuilder sb = new StringBuilder();
        int digestLength = 25;
        boolean isDigest = quals.length >= 50;
        for (int i = 0; i < quals.length; ++i) {
            byte q = quals.getByte(i);
            if (!isDigest || i < 25 || i > quals.length - 25) {
                if (i > 0) {
                    sb.append(",");
                }
                if (q == 255) {
                    sb.append('?');
                } else {
                    sb.append(Integer.toString(q));
                }
            }
            if (isDigest && i == 25) {
                sb.append("...");
            }
            ++i;
        }
        return sb.toString();
    }
}

