/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.BaseAlignmentCounts;
import org.broad.igv.ui.util.MessageUtils;

public class HaplotypeUtils {
    private static Logger log = LogManager.getLogger(HaplotypeUtils.class);
    private final AlignmentInterval alignmentInterval;

    public HaplotypeUtils(AlignmentInterval alignmentInterval) {
        this.alignmentInterval = alignmentInterval;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean clusterAlignments(String chr, int start, int end, int nClasses) {
        try {
            counts = this.alignmentInterval.getCounts();
            reference = GenomeManager.getInstance().getCurrentGenome().getSequence(chr, start, end);
            snpPos = this.findVariantPositions(start, end, counts, reference);
            if (snpPos.size() == 0) {
                MessageUtils.showMessage("No variants in selected range.");
                return false;
            }
            if (snpPos.size() < nClasses - 1) {
                nClasses = snpPos.size() + 1;
                MessageUtils.showMessage("Not enough variants, reducing # of clusters: " + nClasses);
            }
            start = snpPos.get(0) - 1;
            end = snpPos.get(snpPos.size() - 1) + 1;
            for (Alignment a : this.alignmentInterval.getAlignments()) {
                a.setHaplotypeName("NONE");
            }
            labelAlignmentMap = this.labelAlignments(start, end, snpPos, reference, this.alignmentInterval.getAlignmentIterator());
            labels = new ArrayList<String>(labelAlignmentMap.keySet());
            if (labels.size() < nClasses) {
                MessageUtils.showMessage("Not enough features to create " + nClasses + " classes. Max # of classes = " + labels.size());
                return false;
            }
            labels.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$clusterAlignments$0(java.util.Map java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)I)(labelAlignmentMap));
            clusters = new ArrayList<V>();
            for (i = 0; i < nClasses; ++i) {
                label = (String)labels.get(i);
                v = new V(i + 1, label);
                clusters.add(v);
            }
            n = 0;
            max = 50;
            while (true) {
                for (Iterator<E> label : labels) {
                    min = 1.7976931348623157E308;
                    centroid = null;
                    for (V c : clusters) {
                        dist = c.distance((String)label);
                        if (!(dist < min)) continue;
                        centroid = c;
                        min = dist;
                    }
                    if (centroid == null) continue;
                    centroid.add((String)label);
                }
                movement = false;
                for (V c : clusters) {
                    if (!c.movement()) continue;
                    movement = true;
                    break;
                }
                if (!movement || n++ >= max) break;
                label = clusters.iterator();
                while (true) {
                    if (!label.hasNext()) ** continue;
                    c = (V)label.next();
                    c.reset();
                }
                break;
            }
            for (i = 0; i < clusters.size(); ++i) {
                c = (V)clusters.get(i);
                label = "" + c.id;
                for (String l : c.allLabels) {
                    alignments = labelAlignmentMap.get(l);
                    for (Alignment a : alignments) {
                        a.setHaplotypeName(label);
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            HaplotypeUtils.log.error("Error clustering alignments", e);
            MessageUtils.showMessage("Error clustering alignments: " + e.getMessage());
            return false;
        }
    }

    private List<Integer> findVariantPositions(int start, int end, AlignmentCounts counts, byte[] reference) {
        ArrayList<Integer> snpPos = new ArrayList<Integer>();
        for (int i = start; i < end; ++i) {
            byte ref = reference[i - start];
            float mismatchCount = this.getMismatchCount(counts, i, ref);
            if (!(mismatchCount > 0.2f)) continue;
            snpPos.add(i);
        }
        return snpPos;
    }

    public Map<String, List<Alignment>> labelAlignments(int start, int end, List<Integer> positions, byte[] reference, Iterator<Alignment> iter) {
        HashMap<String, List<Alignment>> alignmentMap = new HashMap<String, List<Alignment>>();
        while (iter.hasNext()) {
            Alignment alignment = iter.next();
            if (start < alignment.getStart() || end > alignment.getEnd()) continue;
            Object hapName = "";
            for (Integer pos : positions) {
                boolean found = false;
                for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                    if (block.isSoftClip() || !block.contains(pos)) continue;
                    int blockOffset = pos - block.getStart();
                    hapName = (String)hapName + (char)block.getBase(blockOffset);
                    found = true;
                    break;
                }
                if (found) continue;
                hapName = (String)hapName + "_";
            }
            ArrayList<Alignment> alignments = (ArrayList<Alignment>)alignmentMap.get(hapName = ((String)hapName).toLowerCase());
            if (alignments == null) {
                alignments = new ArrayList<Alignment>();
                alignmentMap.put((String)hapName, alignments);
            }
            alignments.add(alignment);
        }
        return alignmentMap;
    }

    public float getMismatchCount(AlignmentCounts counts, int pos, byte ref) {
        float mismatchQualitySum = 0.0f;
        if (ref < 96) {
            ref = (byte)(ref + 32);
        }
        for (char c : BaseAlignmentCounts.nucleotides) {
            if (c == ref || c == 'n') continue;
            mismatchQualitySum += (float)counts.getCount(pos, (byte)c);
        }
        return mismatchQualitySum / (float)counts.getTotalCount(pos);
    }

    private static /* synthetic */ int lambda$clusterAlignments$0(Map labelAlignmentMap, String o1, String o2) {
        return ((List)labelAlignmentMap.get(o2)).size() - ((List)labelAlignmentMap.get(o1)).size();
    }

    static class V {
        static byte[] foo = new byte[]{97, 99, 116, 103, 95};
        int id;
        int n;
        int total;
        Map<Byte, int[]> counts;
        byte[] label;
        Set<String> allLabels;
        Set<String> previousLabels;

        public V(int id, String s) {
            this.id = id;
            this.label = s.toLowerCase().getBytes();
            this.n = this.label.length;
            this.counts = new HashMap<Byte, int[]>();
            for (byte b : foo) {
                this.counts.put(b, new int[this.n]);
            }
            this.allLabels = new HashSet<String>();
            this.previousLabels = new HashSet<String>();
            this.add(s);
        }

        public void add(String s) {
            byte[] m = s.getBytes();
            if (m.length != this.n) {
                System.err.println("Wrong length");
                return;
            }
            ++this.total;
            for (int i = 0; i < this.n; ++i) {
                int[] cts;
                byte b = m[i];
                if (b < 95) {
                    b = (byte)(b + 32);
                }
                if ((cts = this.counts.get(b)) != null) {
                    int n = i;
                    cts[n] = cts[n] + 1;
                    continue;
                }
                System.err.println("Unknown nuc: " + (char)m[i]);
            }
            this.updateLabel();
            this.allLabels.add(s);
        }

        void updateLabel() {
            for (int i = 0; i < this.n; ++i) {
                byte bMax = 0;
                int cMax = 0;
                for (byte b : foo) {
                    int[] cts;
                    if (b < 95) {
                        b = (byte)(b + 32);
                    }
                    if ((cts = this.counts.get(b)) == null) {
                        System.out.println("Null: " + (char)b);
                    }
                    if (cts[i] <= cMax) continue;
                    cMax = this.counts.get(b)[i];
                    bMax = b;
                }
                this.label[i] = bMax;
            }
        }

        double distance(String s) {
            if (s.length() != this.n) {
                System.out.println("Unequal lengths");
                return -2.147483647E9;
            }
            byte[] b = s.toLowerCase().getBytes();
            double d = 0.0;
            for (int i = 0; i < b.length; ++i) {
                int[] cts = this.counts.get(b[i]);
                double pct = (double)cts[i] / (double)this.total;
                d += 1.0 - pct;
            }
            return d;
        }

        double distance(V v) {
            byte[] s = v.label;
            if (s.length != this.n) {
                System.out.println("Unequal lengths");
                return -2.147483647E9;
            }
            double d = 0.0;
            for (int i = 0; i < s.length; ++i) {
                byte c = this.label[i];
                byte c1 = s[i];
                if (c == c1) continue;
                d += 1.0;
            }
            return d;
        }

        public void reset() {
            this.counts = new HashMap<Byte, int[]>();
            for (byte b : foo) {
                this.counts.put(b, new int[this.n]);
            }
            this.previousLabels = new HashSet<String>(this.allLabels);
            this.allLabels = new HashSet<String>();
            for (int i = 0; i < this.label.length; ++i) {
                this.counts.get((Object)Byte.valueOf((byte)this.label[i]))[i] = 1;
            }
            this.total = 1;
        }

        public boolean movement() {
            if (this.allLabels.size() != this.previousLabels.size()) {
                return true;
            }
            for (String l : this.previousLabels) {
                if (this.allLabels.contains(l)) continue;
                return true;
            }
            return false;
        }
    }
}

