/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import org.broad.igv.batch.BatchRunner;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;

public class RunScriptMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(LoadFilesMenuAction.class);
    IGV igv;

    public RunScriptMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File[] script;
        if (e.getActionCommand().equalsIgnoreCase("run batch script...") && (script = this.chooseScriptFile()) != null && script.length > 0) {
            for (File f : script) {
                BatchRunner bRun = new BatchRunner(f.getPath(), this.igv);
                bRun.run();
            }
        }
    }

    private File[] chooseScriptFile() {
        File lastDirectoryFile = PreferencesManager.getPreferences().getLastTrackDirectory();
        File[] scriptFile = FileDialogUtils.chooseMultiple("Select Script", lastDirectoryFile, null);
        if (scriptFile != null && scriptFile.length > 0) {
            PreferencesManager.getPreferences().setLastTrackDirectory(scriptFile[0].getParentFile());
        }
        this.igv.resetStatusMessage();
        return scriptFile;
    }
}

