/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonNames;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public abstract class StandardDialog
extends JDialog
implements ButtonNames {
    private static final long serialVersionUID = 9114102922553383723L;
    private boolean _lazyConstructorCalled = false;
    protected StandardDialogPane _standardDialogPane;
    public static final int RESULT_CANCELED = -1;
    @Deprecated
    public static final int RESULT_CANCELLED = -1;
    public static final int RESULT_AFFIRMED = 0;
    private int _dialogResult = -1;
    public StandardDialogPropertyChangeListener _propertyChangeListener;

    public StandardDialog() {
        this((Frame)null);
    }

    public StandardDialog(Frame owner) {
        this(owner, true);
    }

    public StandardDialog(Frame owner, boolean modal) {
        this(owner, null, modal);
    }

    public StandardDialog(Frame owner, String title) {
        this(owner, title, true);
    }

    public StandardDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initDialog();
    }

    public StandardDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.initDialog();
    }

    public StandardDialog(Dialog owner) {
        this(owner, true);
    }

    public StandardDialog(Dialog owner, boolean modal) {
        this(owner, null, modal);
    }

    public StandardDialog(Dialog owner, String title) {
        this(owner, title, true);
    }

    public StandardDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initDialog();
    }

    public StandardDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.initDialog();
    }

    public StandardDialog(Window owner) {
        this(owner, (String)null);
    }

    public StandardDialog(Window owner, String title) {
        this(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
    }

    public StandardDialog(Window owner, Dialog.ModalityType modalityType) {
        this(owner, "", modalityType);
    }

    public StandardDialog(Window owner, String title, Dialog.ModalityType modalityType) {
        super(owner, title, modalityType);
        this.initDialog();
    }

    public StandardDialog(Window owner, String title, Dialog.ModalityType modalityType, GraphicsConfiguration gc) {
        super(owner, title, modalityType, gc);
        this.initDialog();
    }

    private void initDialog() {
        this._standardDialogPane = this.createStandardDialogPane();
        this._propertyChangeListener = new StandardDialogPropertyChangeListener();
        this._standardDialogPane.addPropertyChangeListener(this._propertyChangeListener);
        this.setDefaultCloseOperation(2);
    }

    public int getDialogResult() {
        return this._dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this._dialogResult = dialogResult;
    }

    public Action getDefaultCancelAction() {
        return this._standardDialogPane.getDefaultCancelAction();
    }

    public void setDefaultCancelAction(Action defaultCancelAction) {
        this._standardDialogPane.setDefaultCancelAction(defaultCancelAction);
    }

    public Action getDefaultAction() {
        return this._standardDialogPane.getDefaultAction();
    }

    public void setDefaultAction(Action defaultAction) {
        this._standardDialogPane.setDefaultAction(defaultAction);
    }

    @Override
    public void pack() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            JideSwingUtilities.throwException(e);
        }
        super.pack();
    }

    @Override
    @Deprecated
    public void show() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            JideSwingUtilities.throwException(e);
        }
        super.show();
    }

    public final synchronized void initialize() {
        if (!this._lazyConstructorCalled && this.getParent() != null) {
            this.initComponents();
            this._lazyConstructorCalled = true;
            this.validate();
        }
    }

    protected void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this._standardDialogPane.initComponents();
        this.getContentPane().add(this._standardDialogPane);
        if (this.getInitFocusedComponent() != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    StandardDialog.this.getInitFocusedComponent().requestFocus();
                }
            });
        }
    }

    public Component getInitFocusedComponent() {
        return this._standardDialogPane.getInitFocusedComponent();
    }

    public void setInitFocusedComponent(Component initFocusedComponent) {
        this._standardDialogPane.setInitFocusedComponent(initFocusedComponent);
    }

    public JComponent getBannerPanel() {
        return this._standardDialogPane.getBannerPanel();
    }

    public JComponent getContentPanel() {
        return this._standardDialogPane.getContentPanel();
    }

    public ButtonPanel getButtonPanel() {
        return this._standardDialogPane.getButtonPanel();
    }

    public StandardDialogPane getStandardDialogPane() {
        return this._standardDialogPane;
    }

    public abstract JComponent createBannerPanel();

    public abstract JComponent createContentPanel();

    public abstract ButtonPanel createButtonPanel();

    public ButtonPanel createOKCancelButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 6, 10));
        AbstractAction okAction = new AbstractAction(JideSwingUtilities.getOKString(this.getLocale())){
            private static final long serialVersionUID = -326622280892936635L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardDialog.this.setDialogResult(0);
                StandardDialog.this.setVisible(false);
            }
        };
        AbstractAction cancelAction = new AbstractAction(JideSwingUtilities.getCancelString(this.getLocale())){
            private static final long serialVersionUID = 7131352846873132805L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardDialog.this.setDialogResult(-1);
                StandardDialog.this.setVisible(false);
            }
        };
        JButton okButton = new JButton(okAction);
        okButton.setName("OK");
        buttonPanel.addButton((AbstractButton)okButton, "AFFIRMATIVE");
        JButton cancelButton = new JButton(cancelAction);
        cancelButton.setName("CANCEL");
        buttonPanel.addButton((AbstractButton)cancelButton, "CANCEL");
        this.setDefaultCancelAction(cancelAction);
        this.setDefaultAction(okAction);
        this.getRootPane().setDefaultButton(okButton);
        return buttonPanel;
    }

    protected StandardDialogPane createStandardDialogPane() {
        return new DefaultStandardDialogPane();
    }

    protected class DefaultStandardDialogPane
    extends StandardDialogPane {
        private static final long serialVersionUID = -6976658176495038104L;

        protected DefaultStandardDialogPane() {
        }

        @Override
        public JComponent createBannerPanel() {
            return StandardDialog.this.createBannerPanel();
        }

        @Override
        public JComponent createContentPanel() {
            return StandardDialog.this.createContentPanel();
        }

        @Override
        public ButtonPanel createButtonPanel() {
            return StandardDialog.this.createButtonPanel();
        }
    }

    class StandardDialogPropertyChangeListener
    implements PropertyChangeListener {
        StandardDialogPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCancelAction".equals(evt.getPropertyName())) {
                DelegateAction delegateAction = new DelegateAction(StandardDialog.this.getDefaultCancelAction()){
                    private static final long serialVersionUID = -2136676357204671812L;

                    @Override
                    public boolean delegateActionPerformed(ActionEvent e) {
                        if (this.hasSelectionPath()) {
                            MenuSelectionManager.defaultManager().clearSelectedPath();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean isDelegateEnabled() {
                        return this.hasSelectionPath();
                    }

                    private boolean hasSelectionPath() {
                        MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
                        return selectedPath != null && selectedPath.length > 0;
                    }
                };
                StandardDialog.this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
                StandardDialog.this.getRootPane().registerKeyboardAction(delegateAction, KeyStroke.getKeyStroke(27, 0), 2);
            } else if ("defaultAction".equals(evt.getPropertyName())) {
                StandardDialog.this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
                StandardDialog.this.getRootPane().registerKeyboardAction(StandardDialog.this.getDefaultAction(), KeyStroke.getKeyStroke(10, 0), 1);
            }
        }
    }
}

