/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import com.jidesoft.hints.ListDataIntelliHints;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.IGVNamedFeature;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.util.LongRunningTask;

public class SearchTextField
extends JTextField {
    static Logger log = LogManager.getLogger(SearchTextField.class);

    public SearchTextField() {
        this.setToolTipText("Enter a gene or locus, e.f. EGFR,   chr1,   or chr1:100,000-200,000");
        this.addActionListener(actionevent -> this.searchByLocus(this.getText()));
        new SearchHints(this);
    }

    public void searchByLocus(String searchText) {
        LongRunningTask.submit(new SearchCommand(FrameManager.getDefaultFrame(), searchText));
    }

    private class SearchHints
    extends ListDataIntelliHints<String> {
        public SearchHints(JTextComponent jTextComponent) {
            super(jTextComponent, (Object[])new String[0]);
        }

        public void acceptHint(Object context) {
            String text = (String)context;
            super.acceptHint(context);
            SearchTextField.this.searchByLocus(text);
        }

        public boolean updateHints(Object context) {
            String text = (String)context;
            if (text.length() <= 1) {
                return false;
            }
            List<IGVNamedFeature> features = FeatureDB.getFeaturesList(text, SearchCommand.SEARCH_LIMIT);
            List<SearchCommand.SearchResult> results = SearchCommand.getResults(features);
            Object[] list = SearchCommand.getSelectionList(results, false);
            if (list.length >= 1) {
                this.setListData(list);
                return true;
            }
            return false;
        }
    }
}

