/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.ViewChange;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.lists.GeneList;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.sam.InsertionManager;
import org.broad.igv.session.History;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ObservableForObject;

public class Session
implements IGVEventObserver {
    private static Logger log = LogManager.getLogger(Session.class);
    private int version;
    private String path;
    private String groupTracksBy;
    public boolean expandInsertions = false;
    private int nextAutoscaleGroup;
    private ReferenceFrame referenceFrame = FrameManager.getDefaultFrame();
    private TrackFilter filter;
    private HashMap<String, String> preferences;
    private HashMap<TrackType, ContinuousColorScale> colorScales;
    private boolean removeEmptyPanels = false;
    double[] dividerFractions = null;
    private String groupByAttribute = null;
    private History history;
    private Map<String, Collection<RegionOfInterest>> regionsOfInterest;
    private ObservableForObject<Map<String, Collection<RegionOfInterest>>> regionsOfInterestObservable;
    private GeneList currentGeneList;
    private GeneListMode geneListMode = GeneListMode.NORMAL;
    private Set<String> hiddenAttributes;
    private String locus;

    public Session(String path) {
        this.init(path);
    }

    private void init(String path) {
        this.path = path;
        this.nextAutoscaleGroup = 1;
        this.groupByAttribute = null;
        this.regionsOfInterest = new LinkedHashMap<String, Collection<RegionOfInterest>>();
        this.regionsOfInterestObservable = new ObservableForObject<Map<String, Collection<RegionOfInterest>>>(this.regionsOfInterest);
        this.preferences = new HashMap();
        this.colorScales = new HashMap();
        this.hiddenAttributes = null;
        this.history = new History(100);
        IGVEventBus.getInstance().subscribe(ViewChange.class, this);
    }

    public void reset(String path) {
        this.init(path);
        this.setCurrentGeneList(null);
        if (FrameManager.getFrames().size() > 1) {
            IGV.getInstance().resetFrames();
        }
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            frame.setExpandedInsertion(null);
        }
        InsertionManager.getInstance().clear();
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof ViewChange) {
            ViewChange e = (ViewChange)event;
            if (e.recordHistory()) {
                this.recordHistory();
            }
        } else {
            log.warn("Unknown event type: " + event.getClass());
        }
    }

    public void clearDividerLocations() {
        this.dividerFractions = null;
    }

    public void setDividerFractions(double[] divs) {
        this.dividerFractions = divs;
    }

    public double[] getDividerFractions() {
        return this.dividerFractions;
    }

    public void recordHistory() {
        ReferenceFrame defaultFrame = FrameManager.getDefaultFrame();
        this.history.push(defaultFrame.getFormattedLocusString(), defaultFrame.getZoom());
    }

    public void clearHistory() {
        this.history.clear();
    }

    public String getSessionVersion() {
        return String.valueOf(this.version);
    }

    public String getPath() {
        return this.path;
    }

    public String getGroupByAttribute() {
        return this.groupByAttribute;
    }

    public void setGroupByAttribute(String groupByAttribute) {
        this.groupByAttribute = groupByAttribute;
    }

    public void setPreference(String key, String value) {
        this.preferences.put(key, value);
    }

    public void removePreference(String key) {
        this.preferences.remove(key);
    }

    public void setColorScale(TrackType trackType, ContinuousColorScale colorScale) {
        this.colorScales.put(trackType, colorScale);
    }

    public ContinuousColorScale getColorScale(TrackType trackType) {
        if (this.colorScales.containsKey((Object)trackType)) {
            return this.colorScales.get((Object)trackType);
        }
        return PreferencesManager.getPreferences().getColorScale(trackType);
    }

    public boolean getPreferenceAsBoolean(String key) {
        if (this.preferences.containsKey(key)) {
            try {
                return Boolean.parseBoolean(this.preferences.get(key));
            }
            catch (Exception e) {
                log.error("Error converting boolean preference " + key + "=" + this.preferences.get(key));
            }
        }
        return PreferencesManager.getPreferences().getAsBoolean(key);
    }

    public String getPreference(String key) {
        if (this.preferences.containsKey(key)) {
            return this.preferences.get(key);
        }
        return PreferencesManager.getPreferences().get(key);
    }

    public String getPersistent(String key, String def) {
        if (this.preferences.containsKey(key)) {
            return this.preferences.get(key);
        }
        return PreferencesManager.getPreferences().getPersistent(key, def);
    }

    public boolean getOverlayMutationTracks() {
        String key = "OVERLAY_TRACKS_KEY";
        if (this.preferences.containsKey("OVERLAY_TRACKS_KEY")) {
            try {
                return Boolean.parseBoolean(this.preferences.get("OVERLAY_TRACKS_KEY"));
            }
            catch (Exception e) {
                log.error("Error converting boolean preference OVERLAY_TRACKS_KEY=" + this.preferences.get("OVERLAY_TRACKS_KEY"));
            }
        }
        return PreferencesManager.getPreferences().getAsBoolean("OVERLAY_TRACKS_KEY");
    }

    public boolean getColorOverlay() {
        String key = "COVER_OVERLAY_KEY";
        if (this.preferences.containsKey("COVER_OVERLAY_KEY")) {
            try {
                return Boolean.parseBoolean(this.preferences.get("COVER_OVERLAY_KEY"));
            }
            catch (Exception e) {
                log.error("Error converting boolean preference COVER_OVERLAY_KEY=" + this.preferences.get("COVER_OVERLAY_KEY"));
            }
        }
        return PreferencesManager.getPreferences().getAsBoolean("COVER_OVERLAY_KEY");
    }

    public String getOverlayAttribute() {
        String key = "OVERLAY_ATTRIBUTE_KEY";
        if (this.preferences.containsKey("OVERLAY_ATTRIBUTE_KEY")) {
            return this.preferences.get("OVERLAY_ATTRIBUTE_KEY");
        }
        return PreferencesManager.getPreferences().get("OVERLAY_ATTRIBUTE_KEY");
    }

    public String getTrackAttributeName() {
        String key = "TRACK_ATTRIBUTE_NAME_KEY";
        if (this.preferences.containsKey("TRACK_ATTRIBUTE_NAME_KEY")) {
            return this.preferences.get("TRACK_ATTRIBUTE_NAME_KEY");
        }
        return PreferencesManager.getPreferences().get("TRACK_ATTRIBUTE_NAME_KEY");
    }

    public String getLocusString() {
        if (this.getReferenceFrame().getChrName().equals("All")) {
            return "All";
        }
        Range range = this.getReferenceFrame().getCurrentRange();
        String startStr = String.valueOf(range.getStart());
        String endStr = String.valueOf(range.getEnd());
        String position = range.getChr() + ":" + startStr + "-" + endStr;
        return position;
    }

    public void setLocus(String locus) {
        this.locus = locus;
    }

    public String getLocus() {
        return this.locus;
    }

    public TrackFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TrackFilter filter) {
        this.filter = filter;
    }

    public String getGroupTracksBy() {
        return this.groupTracksBy;
    }

    public void setGroupTracksBy(String groupTracksBy) {
        this.groupTracksBy = groupTracksBy;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public Collection<RegionOfInterest> getRegionsOfInterest(String chr) {
        if (chr.equals("All")) {
            return this.getAllRegionsOfInterest();
        }
        return this.regionsOfInterest.get(chr);
    }

    public Collection<RegionOfInterest> getAllRegionsOfInterest() {
        ArrayList<RegionOfInterest> roiList = new ArrayList<RegionOfInterest>();
        for (Collection<RegionOfInterest> roi : this.regionsOfInterest.values()) {
            roiList.addAll(roi);
        }
        return roiList;
    }

    public boolean removeRegionsOfInterest(Collection<RegionOfInterest> rois) {
        boolean result = true;
        for (RegionOfInterest roi : rois) {
            Collection<RegionOfInterest> roiList = this.regionsOfInterest.get(roi.getChr());
            if (roiList == null) continue;
            result = result && roiList.remove(roi);
        }
        this.regionsOfInterestObservable.setChangedAndNotify();
        return result;
    }

    public void addRegionOfInterestWithNoListeners(RegionOfInterest roi) {
        String chr = roi.getChr();
        Collection<RegionOfInterest> roiList = this.regionsOfInterest.get(chr);
        if (roiList == null) {
            roiList = new ArrayList<RegionOfInterest>();
            this.regionsOfInterest.put(chr, roiList);
        }
        roiList.add(roi);
        this.regionsOfInterestObservable.setChangedAndNotify();
    }

    public void clearRegionsOfInterest() {
        if (this.regionsOfInterest != null) {
            this.regionsOfInterest.clear();
        }
        this.regionsOfInterestObservable.setChangedAndNotify();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public History getHistory() {
        return this.history;
    }

    public List<History.Entry> getAllHistory() {
        return this.getHistory().getAllHistory();
    }

    public GeneList getCurrentGeneList() {
        return this.currentGeneList;
    }

    public void setCurrentGeneList(GeneList currentGeneList) {
        boolean frameReset = currentGeneList != null || FrameManager.isGeneListMode();
        this.currentGeneList = currentGeneList;
        if (frameReset) {
            FrameManager.resetFrames(currentGeneList);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setNextAutoscaleGroup(int nextAutoscaleGroup) {
        this.nextAutoscaleGroup = nextAutoscaleGroup;
    }

    public int getNextAutoscaleGroup() {
        return this.nextAutoscaleGroup++;
    }

    public Set<String> getHiddenAttributes() {
        if (this.hiddenAttributes == null) {
            return PreferencesManager.getPreferences().getAsBoolean("SHOW_DEFAULT_TRACK_ATTRIBUTES") ? Collections.emptySet() : new HashSet<String>(AttributeManager.defaultTrackAttributes);
        }
        return this.hiddenAttributes;
    }

    public void setHiddenAttributes(Set<String> attributes) {
        this.hiddenAttributes = attributes;
    }

    public boolean isRemoveEmptyPanels() {
        return this.removeEmptyPanels;
    }

    public void setRemoveEmptyPanels(boolean removeEmptyPanels) {
        this.removeEmptyPanels = removeEmptyPanels;
    }

    private static int[] getStartEnd(String posString) {
        try {
            String endString;
            String[] posTokens = posString.split("-");
            String startString = posTokens[0].replaceAll(",", "");
            int start = Math.max(0, Integer.parseInt(startString)) - 1;
            int end = start + 1;
            if (posTokens.length > 1) {
                endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            if (posTokens.length == 1 || end - start < 10) {
                int center = (start + end) / 2;
                start = center - 20;
                end = center + 20;
            } else {
                endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            return new int[]{Math.min(start, end), Math.max(start, end)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public ObservableForObject<Map<String, Collection<RegionOfInterest>>> getRegionsOfInterestObservable() {
        return this.regionsOfInterestObservable;
    }

    public static enum GeneListMode {
        NORMAL,
        CURSOR;

    }

    static class Locus {
        String chr;
        int start;
        int end;

        Locus(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
        }
    }
}

