/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import htsjdk.samtools.util.SequenceUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BaseModificationKey
implements Comparable {
    char base;
    char strand;
    String modification;
    static Map<String, BaseModificationKey> keyCache = Collections.synchronizedMap(new HashMap());
    static Map<String, Integer> modificationRankOrder;

    public static BaseModificationKey getKey(char base, char strand, String modification) {
        String name = base + strand + modification;
        if (keyCache.containsKey(name)) {
            return keyCache.get(name);
        }
        BaseModificationKey key = new BaseModificationKey(base, strand, modification);
        keyCache.put(name, key);
        return key;
    }

    private BaseModificationKey(char base, char strand, String modification) {
        this.base = base;
        this.strand = strand;
        this.modification = modification;
    }

    public char getBase() {
        return this.base;
    }

    public char getCanonicalBase() {
        return this.strand == '+' ? this.base : (char)SequenceUtil.complement((byte)((byte)this.base));
    }

    public char getStrand() {
        return this.strand;
    }

    public String getModification() {
        return this.modification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseModificationKey key = (BaseModificationKey)o;
        return this.base == key.base && this.strand == key.strand && this.modification.equals(key.modification);
    }

    public int hashCode() {
        return Objects.hash(Character.valueOf(this.base), Character.valueOf(this.strand), this.modification);
    }

    public String toString() {
        return "" + this.base + this.strand + this.modification;
    }

    public int compareTo(Object o) {
        BaseModificationKey otherKey = (BaseModificationKey)o;
        String mod1 = this.modification;
        String mod2 = otherKey.modification;
        if (mod1.equals(mod2)) {
            return (byte)this.strand - (byte)otherKey.strand;
        }
        if (modificationRankOrder == null) {
            modificationRankOrder = new HashMap<String, Integer>();
            String[] tmp = new String[]{"NONE_C", "NONE_T", "NONE_G", "NONE_A", "m", "h", "f", "c", "C", "g", "e", "b", "T", "U", "a", "A", "o", "G", "n", "N"};
            for (int idx = 0; idx < tmp.length; ++idx) {
                modificationRankOrder.put(tmp[idx], idx);
            }
        }
        if (modificationRankOrder.containsKey(mod1) & modificationRankOrder.containsKey(mod2)) {
            return modificationRankOrder.get(mod1) - modificationRankOrder.get(mod2);
        }
        if (modificationRankOrder.containsKey(mod1)) {
            return 1;
        }
        if (modificationRankOrder.containsKey(mod2)) {
            return -1;
        }
        return mod1.compareTo(mod2);
    }
}

