/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentReader;

public class MergedAlignmentReader
implements AlignmentReader {
    private static Logger log = LogManager.getLogger(MergedAlignmentReader.class);
    private final Genome genome;
    List<AlignmentReader> readers;
    List<String> sequenceNames;
    Map<AlignmentReader, Map<String, String>> readerChrNameMaps;
    SAMFileHeader header;

    public MergedAlignmentReader(List<AlignmentReader> readers) throws IOException {
        this.readers = readers;
        this.genome = GenomeManager.getInstance().getCurrentGenome();
        this.loadSequenceNames();
    }

    public CloseableIterator<Alignment> iterator() {
        return new MergedFileIterator();
    }

    public CloseableIterator<Alignment> query(String chr, int start, int end, boolean contained) throws IOException {
        return new MergedFileIterator(chr, start, end, contained);
    }

    @Override
    public void close() throws IOException {
        for (AlignmentReader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    @Override
    public Set<String> getPlatforms() {
        HashSet<String> platforms = new HashSet<String>();
        for (AlignmentReader reader : this.readers) {
            Set<String> plf = reader.getPlatforms();
            if (plf == null) continue;
            platforms.addAll(plf);
        }
        return platforms;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        if (this.header == null) {
            this.header = this.loadHeaders();
        }
        return this.header;
    }

    public void loadSequenceNames() throws IOException {
        this.readerChrNameMaps = new HashMap<AlignmentReader, Map<String, String>>();
        LinkedHashSet<String> names = new LinkedHashSet<String>(50);
        for (AlignmentReader reader : this.readers) {
            HashMap<String, String> chrNameMap = new HashMap<String, String>();
            List<String> readerSequenceNames = reader.getSequenceNames();
            for (String seq : readerSequenceNames) {
                String chr = this.genome.getCanonicalChrName(seq);
                names.add(chr);
                chrNameMap.put(chr, seq);
            }
            this.readerChrNameMaps.put(reader, chrNameMap);
        }
        this.sequenceNames = new ArrayList<String>(names);
    }

    private SAMFileHeader loadHeaders() {
        ArrayList<SAMFileHeader> headersList = new ArrayList<SAMFileHeader>();
        SAMFileHeader.SortOrder sortOrder = null;
        for (AlignmentReader reader : this.readers) {
            SAMFileHeader curHeader = reader.getFileHeader();
            if (curHeader == null) continue;
            headersList.add(curHeader);
            sortOrder = curHeader.getSortOrder();
        }
        if (sortOrder != null) {
            SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(sortOrder, headersList, true);
            return headerMerger.getMergedHeader();
        }
        return null;
    }

    @Override
    public boolean hasIndex() {
        return this.readers.iterator().next().hasIndex();
    }

    public class MergedFileIterator
    implements CloseableIterator<Alignment> {
        List<CloseableIterator<Alignment>> allIterators = new ArrayList<CloseableIterator<Alignment>>();
        PriorityQueue<RecordIterWrapper> iteratorQueue;

        public MergedFileIterator() {
            try {
                this.create(null, -1, -1, false);
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }

        public MergedFileIterator(String chr, int start, int end, boolean contained) throws IOException {
            this.create(chr, start, end, contained);
        }

        private void create(String chr, int start, int end, boolean contained) throws IOException {
            this.iteratorQueue = new PriorityQueue<RecordIterWrapper>(MergedAlignmentReader.this.readers.size(), new AlignmentStartComparator());
            boolean iterate = start == end && start == -1;
            for (AlignmentReader reader : MergedAlignmentReader.this.readers) {
                CloseableIterator iter;
                if (iterate) {
                    iter = reader.iterator();
                } else {
                    String seq = MergedAlignmentReader.this.readerChrNameMaps.containsKey(reader) ? MergedAlignmentReader.this.readerChrNameMaps.get(reader).get(chr) : chr;
                    iter = reader.query(seq, start, end, contained);
                }
                this.allIterators.add(iter);
                if (!iter.hasNext()) continue;
                this.iteratorQueue.add(new RecordIterWrapper(iter));
            }
        }

        public boolean hasNext() {
            return this.iteratorQueue.size() > 0;
        }

        public Alignment next() {
            RecordIterWrapper wrapper = this.iteratorQueue.poll();
            Alignment next = wrapper.advance();
            if (wrapper.hasNext()) {
                this.iteratorQueue.add(wrapper);
            }
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not implemented");
        }

        public void close() {
            for (CloseableIterator<Alignment> iter : this.allIterators) {
                iter.close();
            }
            this.allIterators.clear();
            this.iteratorQueue.clear();
        }

        class AlignmentStartComparator
        implements Comparator<RecordIterWrapper> {
            AlignmentStartComparator() {
            }

            @Override
            public int compare(RecordIterWrapper wrapper1, RecordIterWrapper wrapper2) {
                Alignment a1 = wrapper1.nextRecord;
                Alignment a2 = wrapper2.nextRecord;
                int chrCompare = MergedAlignmentReader.this.genome.getCanonicalChrName(a1.getChr()).compareTo(MergedAlignmentReader.this.genome.getCanonicalChrName(a2.getChr()));
                if (chrCompare != 0) {
                    return chrCompare;
                }
                return a1.getAlignmentStart() - a2.getAlignmentStart();
            }
        }

        class RecordIterWrapper {
            Alignment nextRecord;
            CloseableIterator<Alignment> iterator;

            RecordIterWrapper(CloseableIterator<Alignment> iter) {
                this.iterator = iter;
                this.nextRecord = this.iterator.hasNext() ? (Alignment)this.iterator.next() : null;
            }

            Alignment advance() {
                Alignment tmp = this.nextRecord;
                this.nextRecord = this.iterator.hasNext() ? (Alignment)this.iterator.next() : null;
                return tmp;
            }

            boolean hasNext() {
                return this.nextRecord != null;
            }

            void close() {
                if (this.iterator != null) {
                    this.iterator.close();
                    this.iterator = null;
                }
            }
        }
    }
}

