/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.event.MouseEvent;
import org.broad.igv.Globals;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.ViewChange;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.InsertionManager;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.MessageUtils;

public class ReferenceFrame {
    private static Logger log = LogManager.getLogger(ReferenceFrame.class);
    IGVEventBus eventBus;
    public volatile double origin = 0.0;
    public static int binsPerTile = 700;
    boolean visible = true;
    private String name;
    protected String chrName = "chrAll";
    private int minZoom = 0;
    public int maxZoom = 23;
    protected static final int minBP = 40;
    protected int zoom = this.minZoom;
    volatile int pixelX;
    protected int widthInPixels;
    protected double nTiles = 1.0;
    protected volatile double scale;
    protected Locus initialLocus = null;

    public ReferenceFrame(String name) {
        this.name = name;
        Genome genome = ReferenceFrame.getGenome();
        this.chrName = genome == null ? "" : genome.getHomeChromosome();
        this.eventBus = IGVEventBus.getInstance();
    }

    public ReferenceFrame(ReferenceFrame otherFrame) {
        this(otherFrame, otherFrame.eventBus);
    }

    public ReferenceFrame(ReferenceFrame otherFrame, IGVEventBus eventBus) {
        this.chrName = otherFrame.chrName;
        this.initialLocus = otherFrame.initialLocus;
        this.scale = otherFrame.scale;
        this.minZoom = otherFrame.minZoom;
        this.name = otherFrame.name;
        this.nTiles = otherFrame.nTiles;
        this.origin = otherFrame.origin;
        this.pixelX = otherFrame.pixelX;
        this.widthInPixels = otherFrame.widthInPixels;
        this.zoom = otherFrame.zoom;
        this.maxZoom = otherFrame.maxZoom;
        this.eventBus = eventBus;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void dragStopped() {
        this.setOrigin(Math.round(this.origin));
        this.eventBus.post(ViewChange.Result());
    }

    public void changeGenome(Genome genome) {
        this.setChromosomeName(genome.getHomeChromosome(), true);
    }

    public void changeChromosome(String chrName, boolean recordHistory) {
        boolean changed = this.setChromosomeName(chrName, false);
        ViewChange resultEvent = ViewChange.ChromosomeChangeResult(chrName);
        resultEvent.setRecordHistory(recordHistory);
        this.eventBus.post(resultEvent);
        this.changeZoom(0);
    }

    public void changeZoom(int newZoom) {
        this.doSetZoom(newZoom);
        ViewChange result = ViewChange.Result();
        result.setRecordHistory(false);
        this.eventBus.post(result);
    }

    public void setBounds(int pixelX, int widthInPixels) {
        this.pixelX = pixelX;
        if (this.widthInPixels != widthInPixels) {
            if (this.widthInPixels > 0 && this.initialLocus == null) {
                int start = (int)this.getOrigin();
                int end = (int)this.getEnd();
                if (start >= 0 && end >= 1) {
                    this.initialLocus = new Locus(this.getChrName(), start, end);
                }
            }
            this.widthInPixels = widthInPixels;
            this.computeLocationScale();
            this.computeZoom();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setZoom(int newZoom) {
        if (this.zoom != newZoom) {
            ReferenceFrame referenceFrame = this;
            synchronized (referenceFrame) {
                this.setZoomWithinLimits(newZoom);
                this.computeLocationScale();
            }
        }
    }

    public void setOrigin(double position) {
        int windowLengthBP = (int)((double)this.widthInPixels * this.getScale());
        IGVPreferences preferences = PreferencesManager.getPreferences();
        double newOrigin = preferences.getAsBoolean("SAM.SHOW_SOFT_CLIPPED") ? Math.max((double)(-preferences.getAsInt("SAM.MAX_SOFT_CLIP")), Math.min(position, (double)(this.getMaxCoordinate() + preferences.getAsInt("SAM.MAX_SOFT_CLIP") - windowLengthBP))) : Math.max(0.0, Math.min(position, (double)(this.getMaxCoordinate() - windowLengthBP)));
        this.origin = newOrigin;
    }

    protected synchronized void setZoomWithinLimits(int newZoom) {
        this.zoom = Math.max(this.minZoom, Math.min(this.maxZoom, newZoom));
        this.nTiles = Math.pow(2.0, this.zoom);
    }

    public void doZoomIncrement(int zoomIncrement) {
        double currentCenter = this.getGenomeCenterPosition();
        this.doIncrementZoom(zoomIncrement, currentCenter);
    }

    public void doSetZoom(int newZoom) {
        double currentCenter = this.getGenomeCenterPosition();
        this.doSetZoomCenter(newZoom, currentCenter);
    }

    public void doIncrementZoom(int zoomIncrement, double newCenter) {
        this.doSetZoomCenter(this.getZoom() + zoomIncrement, newCenter);
    }

    public void doSetZoomCenter(int newZoom, double newCenter) {
        if (this.chrName.equals("All")) {
            this.chrName = ReferenceFrame.getGenome().getHomeChromosome();
        }
        if (!this.chrName.equals("All")) {
            this.setZoom(newZoom);
            this.centerOnLocation(newCenter);
        }
    }

    protected double getGenomeCenterPosition() {
        return this.origin + (double)(this.widthInPixels / 2) * this.getScale();
    }

    public double getScale() {
        if (this.scale <= 0.0) {
            this.computeLocationScale();
        }
        return this.scale;
    }

    public boolean setChromosomeName(String name) {
        return this.setChromosomeName(name, false);
    }

    public synchronized boolean setChromosomeName(String name, boolean force) {
        if (this.shouldChangeChromosome(name) || force) {
            this.chrName = name;
            this.origin = 0.0;
            this.scale = -1.0;
            this.calculateMaxZoom();
            this.zoom = -1;
            this.setZoom(0);
            return true;
        }
        return false;
    }

    public void recordHistory() {
        IGV.getInstance().getSession().getHistory().push(this.getFormattedLocusString(), this.zoom);
    }

    public void shiftOriginPixels(int delta) {
        double shiftBP = (double)delta * this.getScale();
        this.setOrigin(this.origin + shiftBP);
        this.eventBus.post(ViewChange.Result());
    }

    public void centerOnLocation(String chr, double chrLocation) {
        if (!this.chrName.equals(chr)) {
            this.setChromosomeName(chr);
        }
        this.centerOnLocation(chrLocation);
    }

    public void centerOnLocation(double chrLocation) {
        double windowWidth = (double)this.widthInPixels * this.getScale() / 2.0;
        this.setOrigin(Math.round(chrLocation - windowWidth));
        this.eventBus.post(ViewChange.LocusChangeResult(this.chrName, this.origin, chrLocation + windowWidth));
    }

    public boolean windowAtEnd() {
        double windowLengthBP = (double)this.widthInPixels * this.getScale();
        return this.origin + windowLengthBP + 1.0 > (double)this.getMaxCoordinate();
    }

    public void jumpTo(String chr, int start, int end) {
        Locus locus = new Locus(chr, start, end);
        this.jumpTo(locus);
    }

    public void jumpTo(Locus locus) {
        String chr = locus.getChr();
        int start = locus.getStart();
        int end = locus.getEnd();
        Genome genome = ReferenceFrame.getGenome();
        if (chr != null && genome.getChromosome(chr) == null && !chr.contains("All")) {
            MessageUtils.showMessage(chr + " is not a valid chromosome.");
            return;
        }
        end = Math.min(ReferenceFrame.getMaxCoordinate(chr), end);
        this.initialLocus = locus;
        this.chrName = chr;
        if (start >= 0 && end >= 0) {
            this.origin = start;
            this.beforeScaleZoom(locus);
            this.computeLocationScale();
            this.computeZoom();
        }
        if (log.isDebugEnabled()) {
            log.debug("Data panel width = " + this.widthInPixels);
            log.debug("New start = " + (int)this.origin);
            log.debug("New end = " + (int)this.getEnd());
            log.debug("New center = " + (int)this.getCenter());
            log.debug("Scale = " + this.scale);
        }
        this.eventBus.post(ViewChange.LocusChangeResult(this.chrName, start, end));
    }

    public double getOrigin() {
        return this.origin;
    }

    public double getCenter() {
        return this.origin + this.getScale() * (double)this.widthInPixels / 2.0;
    }

    public double getEnd() {
        return this.origin + this.getScale() * (double)this.widthInPixels;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getAdjustedZoom() {
        return this.zoom - this.minZoom;
    }

    public void setAdjustedZoom(int zoom) {
        this.doSetZoom(this.minZoom + zoom);
    }

    private boolean shouldChangeChromosome(String newChrName) {
        return this.chrName == null || !this.chrName.equals(newChrName);
    }

    protected void calculateMaxZoom() {
        this.maxZoom = "All".equals(this.chrName) ? 0 : (int)Math.ceil(Globals.log2(this.getChromosomeLength() / 40));
    }

    public String getChrName() {
        return this.chrName;
    }

    public int getWidthInPixels() {
        return this.widthInPixels;
    }

    public double getChromosomePosition(MouseEvent e) {
        return this.getChromosomePosition(e.getX());
    }

    public double getChromosomePosition(int screenPosition) {
        InsertionMarker i = InsertionManager.getInstance().getSelectedInsertion(this.getChrName());
        if (i != null && (double)i.position > this.origin) {
            double start = this.getOrigin();
            double scale = this.getScale();
            double iEnd = 0.0;
            double iStart = 0.0;
            iStart = iEnd + ((double)i.position - start) / scale;
            if ((double)screenPosition < iStart) {
                return start + scale * ((double)screenPosition - iEnd);
            }
            iEnd = iStart + (double)i.size / scale;
            if ((double)screenPosition < iEnd) {
                return i.position;
            }
            start = i.position + 1;
            return start + scale * ((double)screenPosition - iEnd);
        }
        return this.origin + this.getScale() * (double)screenPosition;
    }

    public int getScreenPosition(double chromosomePosition) {
        InsertionMarker i = InsertionManager.getInstance().getSelectedInsertion(this.chrName);
        if (i == null || (double)i.position < this.origin || (double)i.position > chromosomePosition) {
            return (int)((chromosomePosition - this.origin) / this.getScale());
        }
        return (int)((chromosomePosition + (double)i.size - this.origin) / this.getScale());
    }

    public Chromosome getChromosome() {
        Genome genome = ReferenceFrame.getGenome();
        if (genome == null) {
            return null;
        }
        return genome.getChromosome(this.chrName);
    }

    public int getMaxCoordinate() {
        return this.getChromosomeLength();
    }

    private static int getMaxCoordinate(String chrName) {
        return ReferenceFrame.getChromosomeLength(chrName);
    }

    public int getChromosomeLength() {
        return ReferenceFrame.getChromosomeLength(this.chrName);
    }

    public double getTilesTimesBinsPerTile() {
        return this.nTiles * (double)binsPerTile;
    }

    public int getMidpoint() {
        return this.pixelX + this.widthInPixels / 2;
    }

    public String getFormattedLocusString() {
        if (this.zoom == 0) {
            return this.getChrName();
        }
        Range range = this.getCurrentRange();
        return Locus.getFormattedLocusString(range.getChr(), range.getStart(), range.getEnd());
    }

    public Range getCurrentRange() {
        int endLoc = (int)Math.round(this.getChromosomePosition(this.widthInPixels));
        Range range = new Range(this.getChrName(), (int)this.origin, endLoc);
        return range;
    }

    public void reset() {
        this.jumpTo(FrameManager.getLocus(this.name));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private synchronized void computeLocationScale() {
        Genome genome = ReferenceFrame.getGenome();
        if (genome != null) {
            int setEnd = -1;
            if (this.initialLocus != null) {
                setEnd = this.initialLocus.getEnd();
            }
            if (setEnd > 0 && this.widthInPixels > 0) {
                this.scale = ((double)setEnd - this.origin) / (double)this.widthInPixels;
                this.initialLocus = null;
            } else {
                double virtualPixelSize = this.getTilesTimesBinsPerTile();
                double nPixel = Math.max(virtualPixelSize, (double)this.widthInPixels);
                this.scale = (double)this.getChromosomeLength() / nPixel;
            }
        }
    }

    private void computeZoom() {
        int newZoom = this.calculateZoom(this.getOrigin(), this.getEnd());
        this.setZoomWithinLimits(newZoom);
    }

    private void beforeScaleZoom(Locus locus) {
        this.calculateMaxZoom();
    }

    public int calculateZoom(double start, double end) {
        double windowLength = Math.min(end - start, (double)this.getChromosomeLength());
        return (int)Math.round(Globals.log2((double)this.getChromosomeLength() / windowLength * ((double)this.widthInPixels / (double)binsPerTile)));
    }

    private static int getChromosomeLength(String chrName) {
        Genome genome = ReferenceFrame.getGenome();
        if (genome == null) {
            return 1;
        }
        if (chrName.equals("All")) {
            return (int)(genome.getNominalLength() / 1000L);
        }
        Chromosome chromosome = genome.getChromosome(chrName);
        if (chromosome == null) {
            log.error("Null chromosome: " + chrName);
            if (genome.getChromosomes().size() == 0) {
                return 1;
            }
            return genome.getChromosomes().iterator().next().getLength();
        }
        return chromosome.getLength();
    }

    public int stateHash() {
        long temp = Double.doubleToLongBits(this.origin);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.chrName.hashCode();
        result = 31 * result + this.zoom;
        result = 31 * result + this.pixelX;
        result = 31 * result + this.widthInPixels;
        temp = Double.doubleToLongBits(this.scale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    private static Genome getGenome() {
        return GenomeManager.getInstance().getCurrentGenome();
    }
}

