/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.converters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.broad.igv.util.ParsingUtils;

public class TarjeiToBedgraph {
    public static void main(String[] args) throws IOException {
        File dir = new File(args[0]);
        File[] files = dir.listFiles();
        LinkedHashSet<String> chromosomes = new LinkedHashSet<String>();
        LinkedHashSet<String> samples = new LinkedHashSet<String>();
        for (File f : files) {
            String[] tokens = f.getName().split("\\.");
            chromosomes.add(tokens[0]);
            Object sample = tokens[1];
            for (int idx = 2; idx < tokens.length - 1; ++idx) {
                sample = (String)sample + "." + tokens[idx];
            }
            samples.add((String)sample);
        }
        for (String sample : samples) {
            LinkedHashMap<String, String> chrFileMap = new LinkedHashMap<String, String>();
            for (String chr : chromosomes) {
                File f = new File(dir, chr + "." + sample + ".txt");
                if (!f.exists()) continue;
                chrFileMap.put(chr, f.getAbsolutePath());
            }
            String ofile = new File(dir, sample + ".bedgraph").getAbsolutePath();
            TarjeiToBedgraph.convert(chrFileMap, ofile);
        }
    }

    public static void convert(LinkedHashMap<String, String> chrFileMap, String ofile) throws IOException {
        int step = 25;
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
        for (Map.Entry<String, String> entry : chrFileMap.entrySet()) {
            String nextLine;
            String chr = entry.getKey();
            String ifile = entry.getValue();
            BufferedReader reader = null;
            reader = ParsingUtils.openBufferedReader(ifile);
            int start = 0;
            while ((nextLine = reader.readLine()) != null) {
                float counts = Float.parseFloat(nextLine.trim());
                if (counts > 0.0f) {
                    pw.println(chr + "\t" + start + "\t" + (start + step) + "\t" + counts);
                }
                start += step;
            }
            reader.close();
        }
        pw.close();
    }
}

