/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.session.SessionReader;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.LoadFromURLDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.GoogleUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;

public class LoadFromURLMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(LoadFilesMenuAction.class);
    public static final String LOAD_FROM_URL = "Load from URL...";
    public static final String LOAD_GENOME_FROM_URL = "Load Genome from URL...";
    private IGV igv;

    public LoadFromURLMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String url;
        JPanel ta = new JPanel();
        ta.setPreferredSize(new Dimension(600, 20));
        if (e.getActionCommand().equalsIgnoreCase(LOAD_FROM_URL)) {
            String inputURLs;
            LoadFromURLDialog dlg = new LoadFromURLDialog(IGV.getInstance().getMainFrame());
            dlg.setVisible(true);
            if (!dlg.isCanceled() && (inputURLs = dlg.getFileURL()) != null && inputURLs.trim().length() > 0) {
                String[] inputs = Globals.whitespacePattern.split(inputURLs.trim());
                this.checkURLs(inputs);
                if (inputs.length == 1 && SessionReader.isSessionFile(inputs[0])) {
                    String url2 = inputs[0];
                    if (url2.startsWith("s3://")) {
                        this.checkAWSAccessbility(url2);
                    }
                    try {
                        LongRunningTask.submit(() -> this.igv.loadSession(url2, null));
                    }
                    catch (Exception ex) {
                        MessageUtils.showMessage("Error loading url: " + url2 + " (" + ex.toString() + ")");
                    }
                } else {
                    String[] indexes = null;
                    String indexURLs = dlg.getIndexURL();
                    if (indexURLs != null && indexURLs.trim().length() > 0) {
                        indexes = Globals.whitespacePattern.split(indexURLs.trim());
                        if (indexes.length != inputs.length) {
                            throw new RuntimeException("The number of Index URLs must equal the number of File URLs");
                        }
                        this.checkURLs(indexes);
                    }
                    ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
                    for (int i = 0; i < inputs.length; ++i) {
                        String url3 = inputs[i];
                        ResourceLocator rl = new ResourceLocator(url3.trim());
                        if (indexes != null) {
                            String indexUrl = indexes[i];
                            rl.setIndexPath(indexUrl);
                        }
                        locators.add(rl);
                    }
                    this.igv.loadTracks(locators);
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase(LOAD_GENOME_FROM_URL) && (url = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter URL to .genome or FASTA file", 3)) != null && url.trim().length() > 0) {
            url = url.trim();
            try {
                this.checkURLs(new String[]{url});
                GenomeManager.getInstance().loadGenome(url, null);
            }
            catch (Exception e1) {
                MessageUtils.showMessage("Error loading genome: " + e1.getMessage());
            }
        }
    }

    private void checkURLs(String[] urls) {
        for (String url : urls) {
            if (url.startsWith("s3://")) {
                this.checkAWSAccessbility(url);
                continue;
            }
            if (GoogleUtils.isGoogleURL(url)) {
                this.enableGoogleMenu();
                continue;
            }
            if (!url.startsWith("ftp://")) continue;
            MessageUtils.showMessage("FTP protocol is not supported");
        }
    }

    private void enableGoogleMenu() {
        if (!PreferencesManager.getPreferences().getAsBoolean("ENABLE_GOOGLE_MENU")) {
            PreferencesManager.getPreferences().put("ENABLE_GOOGLE_MENU", true);
            IGVMenuBar.getInstance().enableGoogleMenu(true);
        }
    }

    private void checkAWSAccessbility(String url) {
        try {
            String key;
            String bucket;
            AmazonUtils.s3ObjectAccessResult res;
            if (AmazonUtils.isAwsS3Path(url).booleanValue() && !(res = AmazonUtils.isObjectAccessible(bucket = AmazonUtils.getBucketFromS3URL(url), key = AmazonUtils.getKeyFromS3URL(url))).isObjectAvailable()) {
                MessageUtils.showErrorMessage(res.getErrorReason(), null);
                return;
            }
        }
        catch (NullPointerException npe) {
            AmazonUtils.checkLogin();
        }
    }
}

