/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentTrack;

public class BaseModificationColors {
    private static Logger log = LogManager.getLogger(BaseModificationColors.class);
    static Color mColor = Color.red;
    static Color hColor = new Color(11, 132, 165);
    static Color oColor = new Color(111, 78, 129);
    static Color fColor = new Color(246, 200, 95);
    static Color cColor = new Color(157, 216, 102);
    static Color gColor = new Color(255, 160, 86);
    static Color eColor = new Color(141, 221, 208);
    static Color bColor = new Color(202, 71, 47);
    static Color genericColor = new Color(132, 178, 158);
    public static Color noModColor5MC = Color.blue;
    static HashMap<String, Color> colors = new HashMap();
    static HashMap<String, Color> colors5MC = new HashMap();
    static Map<String, Color> modColorMap;
    static Map<String, Color> modColorMap5MC;

    public static Color getModColor(String modification, byte likelihood, AlignmentTrack.ColorOption colorOption) {
        Color baseColor = BaseModificationColors.getBaseColor(modification, colorOption);
        int l = Byte.toUnsignedInt(likelihood);
        if (l > 255) {
            return baseColor;
        }
        String key = modification + "--" + l;
        if (colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_5MC || colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_C) {
            if (!modColorMap5MC.containsKey(key)) {
                int alpha = Math.min(255, (int)((float)(l * l) / 64.0f - (float)(4 * l) + 256.0f));
                if (l >= 128) {
                    modColorMap5MC.put(key, new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha));
                } else {
                    modColorMap5MC.put(key, new Color(noModColor5MC.getRed(), noModColor5MC.getGreen(), noModColor5MC.getBlue(), alpha));
                }
            }
            return modColorMap5MC.get(key);
        }
        if (l > 250) {
            return baseColor;
        }
        double threshold = 256.0f * PreferencesManager.getPreferences().getAsFloat("SAM.BASEMOD_THRESHOLD");
        if ((double)l < threshold) {
            l = 0;
        }
        if (!modColorMap.containsKey(key)) {
            modColorMap.put(key, new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), l));
        }
        return modColorMap.get(key);
    }

    public static Color getNoModColor(byte likelihood) {
        Color baseColor = noModColor5MC;
        int l = Byte.toUnsignedInt(likelihood);
        if (l > 255) {
            return baseColor;
        }
        String key = "NOMOD--" + l;
        if (!modColorMap5MC.containsKey(key)) {
            int alpha = Math.min(255, (int)((float)(l * l) / 64.0f - (float)(4 * l) + 256.0f));
            modColorMap5MC.put(key, new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha));
        }
        return modColorMap5MC.get(key);
    }

    private static Color getBaseColor(String modification, AlignmentTrack.ColorOption colorOption) {
        if ((colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_5MC || colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_C) && colors5MC.containsKey(modification)) {
            return colors5MC.get(modification);
        }
        if (colors.containsKey(modification)) {
            return colors.get(modification);
        }
        return genericColor;
    }

    static {
        colors.put("m", mColor);
        colors.put("h", hColor);
        colors.put("o", oColor);
        colors.put("f", fColor);
        colors.put("c", cColor);
        colors.put("g", gColor);
        colors.put("e", eColor);
        colors.put("b", bColor);
        colors5MC.put("h", new Color(255, 0, 255));
        modColorMap = new HashMap<String, Color>();
        modColorMap5MC = new HashMap<String, Color>();
    }
}

