/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.BundleResourceBase;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.utils.ValidationUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class InputStreamResource
extends BundleResourceBase {
    private static final long serialVersionUID = 1L;
    private static final int MINIMUM_STREAM_BUFFER_SIZE = 65536;
    private final InputStream rawInputStream;
    private BufferedInputStream bufferedInputStream;

    public InputStreamResource(InputStream inputStream, String displayName, String contentType) {
        this(inputStream, displayName, contentType, null);
    }

    public InputStreamResource(InputStream inputStream, String displayName, String contentType, String format) {
        super(displayName, contentType, format);
        ValidationUtils.nonNull(inputStream, "input stream");
        this.rawInputStream = inputStream;
    }

    @Override
    public Optional<InputStream> getInputStream() {
        return Optional.of(this.bufferedInputStream == null ? this.rawInputStream : this.bufferedInputStream);
    }

    @Override
    public SignatureStream getSignatureStream(int signatureProbeLength) {
        ValidationUtils.validateArg(signatureProbeLength > 0, "signatureProbeLength must be > 0");
        if (this.bufferedInputStream != null) {
            throw new IllegalStateException(String.format("Only one SignatureStream stream can be created for an InputStream resource", new Object[0]));
        }
        byte[] signaturePrefix = new byte[signatureProbeLength];
        try {
            this.bufferedInputStream = new BufferedInputStream(this.rawInputStream, Integer.max(signatureProbeLength, 65536));
            this.bufferedInputStream.mark(signatureProbeLength);
            this.bufferedInputStream.read(signaturePrefix);
            this.bufferedInputStream.reset();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Error during signature probing on %s with prefix size %d", this.getDisplayName(), signatureProbeLength), e);
        }
        return new SignatureStream(signatureProbeLength, signaturePrefix);
    }

    @Override
    public boolean hasInputType() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputStreamResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InputStreamResource that = (InputStreamResource)o;
        return this.getInputStream().equals(that.getInputStream());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getInputStream().hashCode();
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s: %s", super.toString(), this.rawInputStream);
    }
}

