/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broad.igv.Globals;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.SortOption;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.session.SessionWriter;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.OverlayTracksMenuAction;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.URLUtils;

public class CommandExecutor {
    private static Logger log = LogManager.getLogger(CommandExecutor.class);
    private File snapshotDirectory;
    private IGV igv;
    private String scriptDir;
    private int sleepInterval = 0;

    public CommandExecutor(IGV igv) {
        this(igv, null);
    }

    public CommandExecutor(IGV igv, String scriptDir) {
        this.igv = igv;
        this.scriptDir = scriptDir;
    }

    private List<String> getArgs(String[] tokens) {
        ArrayList<String> args = new ArrayList<String>(tokens.length);
        for (String s : tokens) {
            if (s.trim().length() <= 0) continue;
            args.add(s.trim());
        }
        return args;
    }

    public String execute(String commandLine) {
        List<String> args = this.getArgs(StringUtils.breakQuotedString(commandLine, ' ').toArray(new String[0]));
        Object result = "OK";
        log.debug("Executing: " + commandLine);
        try {
            String param4;
            if (args.size() == 0) {
                return result;
            }
            String cmd = args.get(0).toLowerCase();
            String param1 = args.size() > 1 ? args.get(1) : null;
            String param2 = args.size() > 2 ? args.get(2) : null;
            String param3 = args.size() > 3 ? args.get(3) : null;
            String string = param4 = args.size() > 4 ? args.get(4) : null;
            if (cmd.equalsIgnoreCase("echo")) {
                result = param1 != null ? param1 : cmd;
            } else if (cmd.equalsIgnoreCase("gotoimmediate") || cmd.equalsIgnoreCase("goto")) {
                result = this.goto1(args);
            } else if (cmd.equalsIgnoreCase("addframes")) {
                result = this.addFrames(args);
            } else if (cmd.equalsIgnoreCase("scrolltotrack") || cmd.equalsIgnoreCase("gototrack")) {
                boolean res = this.igv.scrollToTrack(StringUtils.stripQuotes(param1));
                result = res ? "OK" : String.format("Error: Track %s not found", param1);
            } else if (cmd.equalsIgnoreCase("snapshotdirectory")) {
                result = this.setSnapshotDirectory(param1);
            } else if (cmd.equalsIgnoreCase("snapshot")) {
                result = this.createSnapshot(param1, param2);
            } else if (cmd.equalsIgnoreCase("savesession")) {
                String filename = param1;
                result = this.saveSession(filename);
            } else if ((cmd.equalsIgnoreCase("loadfile") || cmd.equalsIgnoreCase("load")) && param1 != null) {
                result = this.load(param1, args.size() > 2 ? args.subList(2, args.size()) : null);
            } else if (cmd.equalsIgnoreCase("genome") && args.size() > 1) {
                result = this.genome(param1);
            } else if (cmd.equalsIgnoreCase("new") || cmd.equalsIgnoreCase("reset") || cmd.equalsIgnoreCase("clear")) {
                this.igv.newSession();
            } else if (cmd.equalsIgnoreCase("region")) {
                this.defineRegion(param1, param2, param3, param4);
            } else if (cmd.equalsIgnoreCase("sort")) {
                result = this.sort(param1, param2, param3, param4);
            } else if (cmd.equalsIgnoreCase("group")) {
                result = this.group(param1, param2);
            } else if (cmd.equalsIgnoreCase("colorBy")) {
                result = this.colorBy(param1, param2);
            } else if (cmd.equalsIgnoreCase("collapse")) {
                String trackName = CommandExecutor.parseTrackName(param1);
                this.setTrackDisplayMode(Track.DisplayMode.COLLAPSED, trackName);
            } else if (cmd.equalsIgnoreCase("setSequenceStrand")) {
                this.setSequenceTrackStrand(Strand.fromString(param1));
            } else if (cmd.equalsIgnoreCase("setSequenceShowTranslation")) {
                boolean showTranslation;
                try {
                    if (!param1.equalsIgnoreCase("true") && !param1.equalsIgnoreCase("false")) {
                        return "ERROR: showTranslation value (" + param1 + ")is not 'true' or 'false'.";
                    }
                    showTranslation = Boolean.valueOf(param1);
                }
                catch (IllegalArgumentException e) {
                    return e.getMessage();
                }
                this.setSequenceShowTranslation(showTranslation);
            } else if (cmd.equalsIgnoreCase("expand")) {
                String trackName = CommandExecutor.parseTrackName(param1);
                this.setTrackDisplayMode(Track.DisplayMode.EXPANDED, trackName);
            } else if (cmd.equalsIgnoreCase("squish")) {
                String trackName = CommandExecutor.parseTrackName(param1);
                this.setTrackDisplayMode(Track.DisplayMode.SQUISHED, trackName);
            } else if (cmd.equalsIgnoreCase("remove")) {
                String trackName = CommandExecutor.parseTrackName(param1);
                result = this.removeTrack(trackName);
            } else if (cmd.equalsIgnoreCase("tweakdivider")) {
                this.igv.tweakPanelDivider();
            } else if (cmd.equalsIgnoreCase("setDataRange")) {
                result = this.setDataRange(param1, param2);
            } else if (cmd.equalsIgnoreCase("setLogScale")) {
                result = this.setLogScale(param1, param2);
            } else if (cmd.equalsIgnoreCase("setColor")) {
                result = this.setColor(param1, param2, false);
            } else if (cmd.equalsIgnoreCase("setAltColor")) {
                result = this.setColor(param1, param2, true);
            } else {
                if (cmd.equalsIgnoreCase("maxpanelheight") && param1 != null) {
                    return this.setMaxPanelHeight(param1);
                }
                if (cmd.equalsIgnoreCase("tofront")) {
                    return UIUtilities.bringToFront();
                }
                if (cmd.equalsIgnoreCase("viewaspairs")) {
                    return this.setViewAsPairs(param1, param2);
                }
                if (cmd.equalsIgnoreCase("samplingwindowsize")) {
                    return this.setSamplingWindowSize(param1);
                }
                if (cmd.equalsIgnoreCase("maxdepth") || cmd.equalsIgnoreCase("samplingreadcount")) {
                    return this.setSamplingReadCount(param1);
                }
                if (cmd.equalsIgnoreCase("setSleepInterval")) {
                    return this.setSleepInterval(param1);
                }
                if (cmd.equalsIgnoreCase("setCredentials")) {
                    return this.setCredentials(param1, param2);
                }
                if (cmd.equalsIgnoreCase("clearCredentials")) {
                    return this.clearCredentials();
                }
                if (cmd.equals("preference")) {
                    return this.overridePreference(param1, param2);
                }
                if (cmd.equalsIgnoreCase("version")) {
                    return Globals.VERSION;
                }
                if (cmd.equals("exit")) {
                    System.exit(0);
                } else if (cmd.equals("zoomin")) {
                    FrameManager.incrementZoom(1);
                } else if (cmd.equals("zoomout")) {
                    FrameManager.incrementZoom(-1);
                } else if ("oauth".equals(cmd) || cmd.equalsIgnoreCase("setaccesstoken")) {
                    HttpUtils.getInstance().setAccessToken(param1, param2);
                } else if (cmd.equals("clearaccesstokens")) {
                    HttpUtils.getInstance().clearAccessTokens();
                } else if (cmd.equalsIgnoreCase("sortByAttribute")) {
                    result = this.sortByAttribute(args);
                } else if (cmd.equalsIgnoreCase("fitTracks")) {
                    this.igv.fitTracksToPanel();
                } else if (cmd.equalsIgnoreCase("showAttributes")) {
                    result = this.showAttributes(args);
                } else if (cmd.equalsIgnoreCase("showDataRange")) {
                    result = this.setShowDataRange(param1, param2);
                } else if (cmd.equalsIgnoreCase("setTrackHeight")) {
                    result = this.setTrackHeight(param1, param2);
                } else if (cmd.equalsIgnoreCase("overlay")) {
                    result = this.overlay(args);
                } else if (cmd.equalsIgnoreCase("separate")) {
                    result = this.separate(param1);
                } else {
                    result = "UNKOWN COMMAND: " + commandLine;
                    log.warn((String)result);
                    return result;
                }
            }
            this.igv.repaint();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.5) {
                log.debug("Running garbage collection");
                System.gc();
            }
            log.debug("Finished execution: " + commandLine + "  sleeping ....");
            if (this.sleepInterval > 0) {
                try {
                    Thread.sleep(this.sleepInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            log.debug("Finished sleeping");
        }
        catch (IOException e) {
            log.error(e);
            result = "Error: " + e.getMessage();
        }
        log.debug((String)result);
        return result;
    }

    private String sortByAttribute(List<String> args) {
        int nattributes = (args.size() - 1) / 2;
        if (nattributes == 0 || (args.size() - 1) % 2 != 0) {
            return String.format("Error: sortByAttribute usage: sortByAttribute attributeName asc|desc", new Object[0]);
        }
        List<String> allAttributes = AttributeManager.getInstance().getAttributeNames();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String att : allAttributes) {
            attributeMap.put(att.toUpperCase(), att);
        }
        boolean[] ascending = new boolean[nattributes];
        String[] attributes = new String[nattributes];
        int attributeIndex = 0;
        int i = 1;
        while (attributeIndex < nattributes) {
            String attributeArg = StringUtils.stripQuotes(args.get(i)).toUpperCase();
            String attributeName = (String)attributeMap.get(attributeArg);
            if (attributeName == null) {
                return String.format("Error: Attribute %s not found", attributeName);
            }
            String order = args.get(i + 1);
            ascending[attributeIndex] = order.equalsIgnoreCase("asc");
            attributes[attributeIndex] = attributeName;
            ++attributeIndex;
            i += 2;
        }
        this.igv.sortAllTracksByAttributes(attributes, ascending);
        return "OK";
    }

    private String removeTrack(String trackName) {
        if (trackName == null) {
            return "Error: NULL TRACK NAME";
        }
        List<Track> tracks = this.tracksMatchingName(trackName);
        if (tracks.size() > 0) {
            this.igv.deleteTracks(tracks);
            return "OK";
        }
        return String.format("Error: Track %s not found", trackName);
    }

    static String parseTrackName(String param1) {
        return param1 == null ? null : StringUtils.stripQuotes(param1);
    }

    private String overridePreference(String prefKey, String prefVal) {
        PreferencesManager.setOverride(prefKey, prefVal);
        return "OK";
    }

    private String setDataRange(String dataRangeString, String trackName) {
        boolean autoscale;
        DataRange range;
        block9: {
            String[] tokens = dataRangeString.split(",");
            range = null;
            boolean bl = autoscale = dataRangeString.trim().equalsIgnoreCase("auto") || dataRangeString.trim().equalsIgnoreCase("autoscale");
            if (!autoscale) {
                try {
                    if (tokens.length == 2) {
                        range = new DataRange(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]));
                        break block9;
                    }
                    if (tokens.length == 3) {
                        range = new DataRange(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                        break block9;
                    }
                    throw new IllegalArgumentException(String.format("ERROR: parsing %s for data range. \nString must be of form <min,max> or <min,baseline,max>", dataRangeString));
                }
                catch (NumberFormatException e) {
                    return "ERROR: Could not parse input string as a Float. " + e.getMessage();
                }
                catch (IllegalArgumentException e) {
                    return e.getMessage();
                }
            }
        }
        List<Track> tracks = this.tracksMatchingName(trackName);
        for (Track track : tracks) {
            if (!autoscale) {
                if (track.getDataRange().isLog()) {
                    range.setType(DataRange.Type.LOG);
                }
                track.setDataRange(range);
            }
            track.setAutoScale(autoscale);
        }
        this.igv.repaint();
        return "OK";
    }

    private String setLogScale(String logScaleString, String trackName) {
        boolean logScale;
        try {
            if (!logScaleString.equalsIgnoreCase("true") && !logScaleString.equalsIgnoreCase("false")) {
                return "ERROR: logscale value (" + logScaleString + ")is not 'true' or 'false'.";
            }
            logScale = Boolean.valueOf(logScaleString);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
        DataRange.Type scaleType = logScale ? DataRange.Type.LOG : DataRange.Type.LINEAR;
        List<Track> tracks = this.tracksMatchingName(trackName);
        for (Track track : tracks) {
            track.getDataRange().setType(scaleType);
        }
        this.igv.repaint(tracks);
        return "OK";
    }

    private String setColor(String colorString, String trackName, boolean alt) {
        try {
            Color color = ColorUtilities.stringToColorNoDefault(colorString);
            if (color == null) {
                return "Error: unrecognized color value " + colorString;
            }
            List<Track> tracks = this.tracksMatchingName(trackName);
            ArrayList<Track> affectedTracks = new ArrayList<Track>();
            for (Track track : tracks) {
                if (alt) {
                    track.setAltColor(color);
                } else {
                    track.setColor(color);
                }
                affectedTracks.add(track);
            }
            this.igv.repaint(affectedTracks);
            return "OK";
        }
        catch (Exception e) {
            return "Error setting track color: " + e.getMessage();
        }
    }

    private String overlay(List<String> args) {
        if (args.size() > 2) {
            String name = StringUtils.isQuoted(args.get(1)) ? StringUtils.stripQuotes(args.get(1)) : URLDecoder.decode(args.get(1), Charset.defaultCharset());
            ArrayList<DataTrack> tracks = new ArrayList<DataTrack>();
            for (int i = 2; i < args.size(); ++i) {
                List<Track> tmp = this.tracksMatchingName(args.get(i));
                for (Track t : tmp) {
                    if (!(t instanceof DataTrack)) continue;
                    tracks.add((DataTrack)t);
                }
            }
            OverlayTracksMenuAction.merge(tracks, name);
            return "OK";
        }
        return "overlay command requires at least 2 arguments (trackName track1 track2 ...)";
    }

    private String separate(String trackName) {
        List<Track> tmp = this.tracksMatchingName(trackName);
        if (tmp != null && tmp.size() > 0) {
            OverlayTracksMenuAction.unmerge(tmp);
            return "OK";
        }
        return "No track found matching " + trackName;
    }

    private List<Track> tracksMatchingName(String name) {
        List<Track> tracks = this.igv.getAllTracks();
        if (name == null) {
            return tracks;
        }
        String altName = StringUtils.isQuoted(name) ? StringUtils.stripQuotes(name) : URLDecoder.decode(name, Charset.defaultCharset());
        return tracks.stream().filter(t -> name.equalsIgnoreCase(t.getName()) || altName.equalsIgnoreCase(t.getName()) || t.getResourceLocator() != null && name.equals(t.getResourceLocator().getPath()) || t.getResourceLocator() != null && altName.equals(t.getResourceLocator().getPath())).collect(Collectors.toList());
    }

    private String setViewAsPairs(String vAPString, String trackName) {
        List<Track> tracks = this.tracksMatchingName(trackName);
        boolean vAP = !"false".equalsIgnoreCase(vAPString);
        for (Track track : tracks) {
            if (!(track instanceof AlignmentTrack)) continue;
            AlignmentTrack atrack = (AlignmentTrack)track;
            atrack.setViewAsPairs(vAP);
        }
        return "OK";
    }

    private String showAttributes(List<String> args) {
        HashSet<String> hiddenAttributes = new HashSet<String>(AttributeManager.getInstance().getAttributeNames());
        hiddenAttributes.addAll(this.igv.getSession().getHiddenAttributes());
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String att : hiddenAttributes) {
            attributeMap.put(att.toUpperCase(), att);
        }
        for (int i = 1; i < args.size(); ++i) {
            String attributeArg = StringUtils.stripQuotes(args.get(i)).toUpperCase();
            String attributeName = (String)attributeMap.get(attributeArg);
            if (!hiddenAttributes.contains(attributeName)) {
                return String.format("Error: Attribute %s not found", attributeName);
            }
            hiddenAttributes.remove(attributeName);
        }
        this.igv.getSession().setHiddenAttributes(hiddenAttributes);
        this.igv.revalidateTrackPanels();
        return "OK";
    }

    private void setTrackDisplayMode(Track.DisplayMode mode, String trackName) {
        for (Track t : this.tracksMatchingName(trackName)) {
            t.setDisplayMode(mode);
        }
    }

    private void setSequenceTrackStrand(Strand trackStrand) {
        for (Track t : this.igv.getAllTracks()) {
            if (!(t instanceof SequenceTrack)) continue;
            ((SequenceTrack)t).setStrand(trackStrand);
        }
    }

    private void setSequenceShowTranslation(boolean shouldShowTranslation) {
        for (Track t : this.igv.getAllTracks()) {
            if (!(t instanceof SequenceTrack)) continue;
            ((SequenceTrack)t).setShowTranslation(shouldShowTranslation);
        }
    }

    private String setTrackHeight(String param1, String param2) {
        String trackName;
        int height;
        try {
            height = Integer.parseInt(param1);
            trackName = CommandExecutor.parseTrackName(param2);
        }
        catch (NumberFormatException e) {
            height = Integer.parseInt(param2);
            trackName = CommandExecutor.parseTrackName(param1);
        }
        height = Math.max(0, height);
        List<Track> tracks = this.tracksMatchingName(trackName);
        if (tracks.size() > 0) {
            for (Track track : tracks) {
                track.setHeight(height, true);
                this.igv.repaint(track);
            }
            return "OK";
        }
        return String.format("Error: Track %s not found", trackName);
    }

    private String setShowDataRange(String show, String trackName) {
        boolean showDataRange;
        try {
            if (!show.equalsIgnoreCase("true") && !show.equalsIgnoreCase("false")) {
                return "ERROR: showDataRange value (" + show + ") is not 'true' or 'false'.";
            }
            showDataRange = Boolean.valueOf(show);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
        ArrayList<Track> affectedTracks = new ArrayList<Track>();
        List<Track> tracks = this.tracksMatchingName(trackName);
        for (Track track : tracks) {
            if (!(track instanceof DataTrack)) continue;
            ((DataTrack)track).setShowDataRange(showDataRange);
            affectedTracks.add(track);
        }
        this.igv.repaint(affectedTracks);
        return "OK";
    }

    private String setSamplingWindowSize(String windowSize) {
        try {
            Integer.parseInt(windowSize);
            PreferencesManager.getPreferences().override("SAM.SAMPLING_WINDOW", String.valueOf(windowSize));
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR: SAMPLING WINDOW IS NOT A NUMBER: " + windowSize;
        }
    }

    private String setSamplingReadCount(String samplingReadCount) {
        try {
            Integer.parseInt(samplingReadCount);
            PreferencesManager.getPreferences().override("SAM.MAX_LEVELS", String.valueOf(samplingReadCount));
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR: SAMPLING READ COUNT IS NOT A NUMBER: " + samplingReadCount;
        }
    }

    private String gotoImmediate(List<String> args) {
        return this.goto1(args);
    }

    private String setMaxPanelHeight(String param1) {
        try {
            Integer h = Integer.parseInt(param1.trim());
            SnapshotUtilities.setMaxPanelHeight(h);
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR - max panel height value ('" + param1 + ".) must be an integer number";
        }
    }

    public String setSleepInterval(String param1) {
        try {
            this.sleepInterval = Integer.parseInt(param1.trim());
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR - sleep interval value ('" + param1 + ".) must be an integer number";
        }
    }

    private String setCredentials(String param1, String param2) {
        HttpUtils.getInstance().setDefaultUserName(param1);
        HttpUtils.getInstance().setDefaultPassword(param2);
        return "OK";
    }

    private String clearCredentials() {
        HttpUtils.getInstance().clearDefaultCredentials();
        return "OK";
    }

    private String genome(String param1) {
        if (param1 == null) {
            return "ERROR missing genome parameter";
        }
        Object result = "OK";
        String genomeID = param1;
        this.igv.selectGenomeFromList(genomeID);
        if (GenomeManager.getInstance().getCurrentGenome().getId().equals(genomeID)) {
            return result;
        }
        String genomePath = this.resolveFileReference(genomeID);
        try {
            GenomeManager.getInstance().loadGenome(genomePath, null);
        }
        catch (IOException e) {
            result = "ERROR: Could not load genome: " + genomeID;
            MessageUtils.showMessage((String)result);
        }
        return result;
    }

    private String load(String fileString, List<String> params) throws IOException {
        String name = null;
        String index = null;
        String coverage = null;
        String format = null;
        boolean merge = true;
        if (params != null) {
            for (String param : params) {
                if (param != null && param.startsWith("name=")) {
                    name = param.substring(5);
                    continue;
                }
                if (param != null && param.startsWith("merge=")) {
                    String mergeString = param.substring(6);
                    merge = !mergeString.equalsIgnoreCase("false");
                    continue;
                }
                if (param != null && param.startsWith("index=")) {
                    index = param.substring(6);
                    continue;
                }
                if (param != null && param.startsWith("coverage=")) {
                    coverage = param.substring(9);
                    continue;
                }
                if (param == null || !param.startsWith("format=")) continue;
                format = param.substring(7);
            }
        }
        String locus = null;
        Map<String, String> ignore = null;
        String sort = null;
        String sortTag = null;
        return this.loadFiles(fileString, index, coverage, name, format, locus, merge, ignore, sort, sortTag, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String loadFiles(String fileString, String indexString, String coverageString, String nameString, String formatString, String locus, boolean merge, Map<String, String> params, String sort, String sortTag, boolean dup) {
        boolean currentBatchSetting = Globals.isBatch();
        try {
            Globals.setBatch(true);
            boolean isDataURL = ParsingUtils.isDataURL(fileString);
            List<String> files = isDataURL ? Arrays.asList(fileString) : CommandExecutor.breakFileString(fileString);
            List<String> indexFiles = isDataURL ? null : CommandExecutor.breakFileString(indexString);
            List<String> coverageFiles = CommandExecutor.breakFileString(coverageString);
            List<String> names = CommandExecutor.breakFileString(nameString);
            List<String> formats = CommandExecutor.breakFileString(formatString);
            if (names != null && names.size() != files.size()) {
                String string = "Error: If file is a comma-separated list, names must also be a comma-separated list of the same length";
                return string;
            }
            if (indexFiles != null && indexFiles.size() != files.size()) {
                String string = "Error: If file is a comma-separated list, index must also be a comma-separated list of the same length";
                return string;
            }
            if (isDataURL && formatString == null) {
                String string = "Error: format must be specified for dataURLs";
                return string;
            }
            if (formats != null) {
                for (int i = 0; i < formats.size(); ++i) {
                    String formatOrExt = CommandExecutor.decodeFileString(formats.get(i));
                    String format = formatOrExt.startsWith(".") ? formatOrExt.substring(1) : formatOrExt;
                    formats.set(i, format);
                }
            }
            ArrayList<ResourceLocator> fileLocators = new ArrayList<ResourceLocator>();
            if (!SessionReader.isSessionFile(fileString) && !merge) {
                this.igv.newSession();
            }
            HashSet<String> loadedFiles = new HashSet<String>();
            for (ResourceLocator rl : this.igv.getDataResourceLocators()) {
                loadedFiles.add(rl.getPath());
            }
            for (int fi = 0; fi < files.size(); ++fi) {
                File file;
                String f = this.resolveFileReference(files.get(fi));
                if (isDataURL && formats == null) {
                    String string = "Error: format must be specified for dataURLs";
                    return string;
                }
                if (!dup && loadedFiles.contains(f)) continue;
                if (SessionReader.isSessionFile(f)) {
                    this.igv.loadSession(f, locus);
                    continue;
                }
                ResourceLocator rl = new ResourceLocator(f);
                if (names != null) {
                    rl.setName(names.get(fi));
                } else if (isDataURL) {
                    rl.setName("Data");
                }
                if (indexFiles != null) {
                    rl.setIndexPath(indexFiles.get(fi));
                }
                if (coverageFiles != null) {
                    rl.setCoverage(coverageFiles.get(fi));
                }
                if (formats != null) {
                    rl.setFormat(formats.get(fi));
                }
                if (params != null) {
                    String trackLine = this.createTrackLine(params);
                    rl.setTrackLine(trackLine);
                }
                if (!isDataURL && rl.isLocal() && !(file = new File(rl.getPath())).exists()) {
                    String string = "Error: " + f + " does not exist.";
                    return string;
                }
                fileLocators.add(rl);
            }
            if (fileLocators.size() > 0) {
                this.igv.loadTracks(fileLocators);
            }
            if (locus != null) {
                this.igv.goToLocus(locus);
            }
            if (this.igv.getAlignmentTracks().size() > 0) {
                String[] tokens;
                if (locus != null && sort == null && (tokens = locus.split(":", 2)).length == 2 && !tokens[1].contains("-")) {
                    sort = "base";
                }
                if (sort != null) {
                    SortOption sortOption = CommandExecutor.getAlignmentSortOption(sort);
                    this.igv.sortAlignmentTracks(sortOption, sortTag, false);
                }
            }
            String string = "OK";
            return string;
        }
        finally {
            Globals.setBatch(currentBatchSetting);
        }
    }

    private String resolveFileReference(String f) {
        if (FileUtils.isRemote(f)) {
            return f;
        }
        File maybeFile = this.getFile(f);
        if (maybeFile.exists()) {
            f = maybeFile.getAbsolutePath();
        }
        return f;
    }

    static List<String> breakFileString(String fileString) {
        List<String> files2;
        if (fileString == null) {
            return null;
        }
        List<String> files = StringUtils.breakQuotedString(fileString, ',');
        if (files.size() == 1 && (files2 = StringUtils.breakQuotedString(fileString.replaceAll("%2C", ","), ',')).size() > 1) {
            files = files2;
        }
        for (int ii = 0; ii < files.size(); ++ii) {
            files.set(ii, CommandExecutor.decodeFileString(files.get(ii)));
        }
        return files;
    }

    static String decodeFileString(String fileString) {
        if (StringUtils.isQuoted(fileString)) {
            return StringUtils.stripQuotes(fileString);
        }
        if (CommandExecutor.needsDecode(fileString)) {
            return StringUtils.decodeURL(fileString);
        }
        return fileString;
    }

    static boolean needsDecode(String fileString) {
        String decodedString = CommandExecutor.decodeSafe(fileString);
        return decodedString != null && (URLUtils.isURL(fileString) || URLUtils.isURL(decodedString));
    }

    private static String decodeSafe(String string) {
        String tmp = null;
        try {
            tmp = StringUtils.decodeURL(string);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        return tmp;
    }

    private String createTrackLine(Map<String, String> params) {
        return params.get("hgt.customText");
    }

    String setSnapshotDirectory(String param1) {
        Object result;
        if (param1 == null) {
            return "ERROR: missing directory parameter";
        }
        File snapshotDir = this.getFile(param1);
        if (snapshotDir.exists()) {
            this.snapshotDirectory = snapshotDir;
            result = "OK";
        } else {
            CommandExecutor.createParents(snapshotDir);
            snapshotDir.mkdir();
            if (snapshotDir.exists()) {
                this.snapshotDirectory = snapshotDir;
                result = "OK";
            } else {
                result = "ERROR: directory: " + param1 + " does not exist";
            }
        }
        return result;
    }

    private File getFile(String path) {
        if (((String)(path = StringUtils.stripQuotes((String)path))).startsWith("~")) {
            path = System.getProperty("user.home") + ((String)path).substring(1);
            return new File((String)path);
        }
        if (((String)path).startsWith("$SCRIPT_DIR") && this.scriptDir != null) {
            return new File(this.scriptDir + ((String)path).substring("$SCRIPT_DIR".length()));
        }
        File maybeFile = new File((String)path);
        if (maybeFile.exists()) {
            return maybeFile;
        }
        if (this.scriptDir != null && (maybeFile = new File(this.scriptDir, (String)path)).exists()) {
            return maybeFile;
        }
        return new File((String)path);
    }

    private String goto1(List<String> args) {
        if (args == null || args.size() < 2) {
            return "ERROR: missing locus parameter";
        }
        Object locus = args.get(1);
        for (int i = 2; i < args.size(); ++i) {
            locus = (String)locus + " " + args.get(i);
        }
        this.igv.goToLocus((String)locus);
        return "OK";
    }

    private String addFrames(List<String> args) {
        if (args == null || args.size() < 3) {
            return "ERROR: missing locus parameter";
        }
        FrameManager.addFrames(args.subList(1, args.size()));
        return "OK";
    }

    private void defineRegion(String param1, String param2, String param3, String param4) {
        Locus locus;
        String desc;
        RegionOfInterest roi = null;
        if (param1 != null && param2 != null && param3 != null) {
            int start = Math.max(0, Integer.parseInt(param2) - 1);
            int end = Integer.parseInt(param3);
            desc = param4 != null ? param4 : "";
            roi = new RegionOfInterest(param1, start, end, desc);
        }
        if (param1 != null && (locus = Locus.fromString(param1)) != null) {
            int start = Math.max(0, locus.getStart() - 1);
            desc = param2 != null ? param2 : "";
            roi = new RegionOfInterest(locus.getChr(), start, locus.getEnd(), desc);
        }
        if (roi != null) {
            this.igv.addRegionOfInterest(roi);
        }
    }

    private String sort(String sortArg, String param2, String param3, String param4) {
        String reverseString;
        String locusString;
        RegionScoreType regionSortOption = CommandExecutor.getRegionSortOption(sortArg);
        if (regionSortOption != null) {
            Locus locus;
            RegionOfInterest roi = null;
            if (param2 != null && (locus = Locus.fromString(param2)) != null) {
                int start = Math.max(0, locus.getStart() - 1);
                roi = new RegionOfInterest(locus.getChr(), start, locus.getEnd(), "");
            }
            this.igv.sortByRegionScore(roi, regionSortOption, FrameManager.getFirstFrame());
            return "OK";
        }
        String tag = null;
        if (sortArg.equalsIgnoreCase("tag")) {
            tag = param2;
            locusString = param3;
            reverseString = param4;
        } else {
            locusString = param2;
            reverseString = param3;
        }
        if (reverseString == null && "reverse".equalsIgnoreCase(locusString)) {
            reverseString = locusString;
            locusString = null;
        }
        Double location = null;
        if (locusString != null && locusString.trim().length() > 0) {
            Locus locus = Locus.fromString(locusString);
            if (locus != null) {
                location = locus.getStart();
            } else {
                try {
                    location = Double.valueOf(locusString.replace(",", ""));
                    if (location != null) {
                        Double d = location;
                        Double d2 = location = Double.valueOf(location - 1.0);
                    }
                }
                catch (NumberFormatException e) {
                    return "Error parsing location: " + locusString;
                }
            }
        }
        boolean invertSort = "reverse".equalsIgnoreCase(reverseString);
        this.igv.sortAlignmentTracks(CommandExecutor.getAlignmentSortOption(sortArg), location, tag, invertSort);
        return "OK";
    }

    private String group(String groupArg, String tagArg) {
        AlignmentTrack.GroupOption groupOption = CommandExecutor.getAlignmentGroupOption(groupArg);
        Range r = null;
        if (groupOption == AlignmentTrack.GroupOption.BASE_AT_POS) {
            if (tagArg == null) {
                return "Error: position is required";
            }
            try {
                Locus locus = Locus.fromString(tagArg);
                r = new Range(locus.getChr(), locus.getStart(), locus.getEnd());
            }
            catch (Exception e) {
                return "Error: invalid position: " + tagArg;
            }
        }
        this.igv.groupAlignmentTracks(groupOption, tagArg, r);
        return "OK";
    }

    private String colorBy(String colorArg, String tagArg) {
        AlignmentTrack.ColorOption colorOption = AlignmentTrack.ColorOption.valueOf(colorArg.toUpperCase());
        this.igv.colorAlignmentTracks(colorOption, tagArg);
        return "OK";
    }

    private String createSnapshot(String filename, String region) {
        File file;
        if (filename == null) {
            String locus = FrameManager.getCurrentLocusString();
            filename = locus.replaceAll(":", "_").replace("-", "_") + ".png";
        } else {
            filename = StringUtils.stripQuotes((String)filename);
        }
        if (this.snapshotDirectory == null) {
            file = this.getFile((String)filename);
            if (!file.getAbsoluteFile().getParentFile().exists()) {
                CommandExecutor.createParents(file);
            }
        } else {
            file = new File(this.snapshotDirectory, (String)filename);
        }
        MainPanel target = null;
        if (region == null || region.trim().length() == 0) {
            target = this.igv.getContentPane().getMainPanel();
        } else if ("trackpanels".equalsIgnoreCase(region)) {
            target = this.igv.getMainPanel().getCenterSplitPane();
        }
        if (target == null) {
            String msg = "ERROR. Could not create snapshot. Unknown region: " + region;
            log.error(msg);
            return msg;
        }
        try {
            return this.igv.createSnapshotNonInteractive(target, file, true);
        }
        catch (Exception e) {
            log.error(e);
            return e.getMessage();
        }
    }

    private String saveSession(String filename) {
        File targetFile;
        Session currentSession = this.igv.getSession();
        if (!((String)filename).endsWith(".xml")) {
            filename = (String)filename + ".xml";
        }
        if ((targetFile = this.getFile((String)filename)).getParentFile().exists()) {
            currentSession.setPath(targetFile.getAbsolutePath());
            try {
                new SessionWriter().saveSession(currentSession, targetFile);
                return "OK";
            }
            catch (Exception e) {
                return "Error writingin sesssion: " + e.getMessage();
            }
        }
        return "Error: directory not found: " + targetFile.getParentFile().getAbsolutePath();
    }

    private static void createParents(File outputFile) {
        File parent = outputFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    private static RegionScoreType getRegionSortOption(String str) {
        if (str == null) {
            return null;
        }
        String option = str.toUpperCase();
        try {
            return RegionScoreType.valueOf(option);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static SortOption getAlignmentSortOption(String str) {
        String string = str = str == null ? "base" : str;
        if (str.equalsIgnoreCase("start") || str.equalsIgnoreCase("position")) {
            return SortOption.START;
        }
        if (str.equalsIgnoreCase("strand")) {
            return SortOption.STRAND;
        }
        if (str.equalsIgnoreCase("base")) {
            return SortOption.NUCLEOTIDE;
        }
        if (str.equalsIgnoreCase("quality")) {
            return SortOption.QUALITY;
        }
        if (str.equalsIgnoreCase("sample")) {
            return SortOption.SAMPLE;
        }
        if (str.equalsIgnoreCase("readGroup") || str.equalsIgnoreCase("read_group")) {
            return SortOption.READ_GROUP;
        }
        if (str.equalsIgnoreCase("insertSize") || str.equalsIgnoreCase("insert_size")) {
            return SortOption.INSERT_SIZE;
        }
        if (str.equalsIgnoreCase("firstOfPairStrand")) {
            return SortOption.FIRST_OF_PAIR_STRAND;
        }
        if (str.equalsIgnoreCase("mateChr")) {
            return SortOption.MATE_CHR;
        }
        if (str.equalsIgnoreCase("readOrder")) {
            return SortOption.READ_ORDER;
        }
        if (str.equalsIgnoreCase("readname")) {
            return SortOption.READ_NAME;
        }
        if (str.equalsIgnoreCase("alignedReadLength")) {
            return SortOption.ALIGNED_READ_LENGTH;
        }
        try {
            return SortOption.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("Unknown sort option: " + str);
            return SortOption.NUCLEOTIDE;
        }
    }

    private static AlignmentTrack.GroupOption getAlignmentGroupOption(String str) {
        if (str == null || str.length() == 0) {
            return AlignmentTrack.GroupOption.NONE;
        }
        if (str.equalsIgnoreCase("strand")) {
            return AlignmentTrack.GroupOption.STRAND;
        }
        if (str.equalsIgnoreCase("sample")) {
            return AlignmentTrack.GroupOption.SAMPLE;
        }
        if (str.equalsIgnoreCase("library")) {
            return AlignmentTrack.GroupOption.LIBRARY;
        }
        if (str.equalsIgnoreCase("readGroup") || str.equalsIgnoreCase("read_group")) {
            return AlignmentTrack.GroupOption.READ_GROUP;
        }
        try {
            return AlignmentTrack.GroupOption.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("Unknown group by option: " + str);
            return AlignmentTrack.GroupOption.NONE;
        }
    }
}

