/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.math3.stat.StatUtils;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;

public class SetTrackHeightMenuAction
extends MenuAction {
    IGV igv;
    static Logger log = LogManager.getLogger(SetTrackHeightMenuAction.class);
    static int lastTrackHeight = -1;

    public SetTrackHeightMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doSetTrackHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doSetTrackHeight() {
        boolean repaint = false;
        try {
            JPanel container = new JPanel();
            JLabel trackHeightLabel = new JLabel("Track Height (pixels)");
            JTextField trackHeightField = new JTextField();
            Dimension preferredSize = trackHeightField.getPreferredSize();
            trackHeightField.setPreferredSize(new Dimension(50, (int)preferredSize.getHeight()));
            container.add(trackHeightLabel);
            container.add(trackHeightField);
            int repTrackHeight = this.getRepresentativeTrackHeight();
            trackHeightField.setText(String.valueOf(repTrackHeight));
            int status = JOptionPane.showConfirmDialog(this.igv.getMainFrame(), container, "Set Track Height", 2, -1, null);
            if (status == 2 || status == -1) {
                return;
            }
            try {
                int newTrackHeight = Integer.parseInt(trackHeightField.getText().trim());
                IGV.getInstance().setAllTrackHeights(newTrackHeight);
                lastTrackHeight = newTrackHeight;
                repaint = true;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.igv.getMainFrame(), "Track height must be an integer number.");
            }
        }
        finally {
            if (repaint) {
                this.igv.repaint();
            }
            this.igv.resetStatusMessage();
        }
    }

    private int getRepresentativeTrackHeight() {
        if (lastTrackHeight > 0) {
            return lastTrackHeight;
        }
        List<Track> tracks = IGV.getInstance().getAllTracks();
        double[] heights = new double[tracks.size()];
        for (int i = 0; i < tracks.size(); ++i) {
            heights[i] = tracks.get(i).getHeight();
        }
        int medianTrackHeight = (int)Math.round(StatUtils.percentile((double[])heights, (double)50.0));
        if (medianTrackHeight > 0) {
            return medianTrackHeight;
        }
        return PreferencesManager.getPreferences().getAsInt("15");
    }
}

