/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import htsjdk.samtools.util.SequenceUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.mods.BaseModificationColors;
import org.broad.igv.sam.mods.BaseModificationCounts;
import org.broad.igv.track.RenderContext;

public class BaseModificationCoverageRenderer {
    public static void drawModifications(RenderContext context, int pX, int pBottom, int dX, int barHeight, int pos, AlignmentCounts alignmentCounts, AlignmentTrack.ColorOption colorOption) {
        switch (colorOption) {
            case BASE_MODIFICATION_5MC: {
                BaseModificationCoverageRenderer.draw5MC(context, pX, pBottom, dX, barHeight, pos, alignmentCounts, false);
                break;
            }
            case BASE_MODIFICATION_C: {
                BaseModificationCoverageRenderer.draw5MC(context, pX, pBottom, dX, barHeight, pos, alignmentCounts, true);
                break;
            }
            default: {
                BaseModificationCoverageRenderer.draw(context, pX, pBottom, dX, barHeight, pos, alignmentCounts);
            }
        }
    }

    private static void draw(RenderContext context, int pX, int pBottom, int dX, int barHeight, int pos, AlignmentCounts alignmentCounts) {
        BaseModificationCounts modificationCounts = alignmentCounts.getModifiedBaseCounts();
        if (modificationCounts != null) {
            Graphics2D graphics = context.getGraphics();
            for (BaseModificationCounts.Key key : modificationCounts.getAllModifications()) {
                int modificationCount = modificationCounts.getCount(pos, key);
                if (barHeight <= 0 || modificationCount <= 0) continue;
                byte base = (byte)key.getBase();
                byte complement = SequenceUtil.complement((byte)base);
                char modStrand = key.getStrand();
                String modification = key.getModification();
                int baseCount = alignmentCounts.getPosCount(pos, base) + alignmentCounts.getNegCount(pos, complement);
                int calledBarHeight = (int)((float)modificationCount / (float)baseCount * (float)barHeight);
                Color modColor = BaseModificationColors.getModColor(modification, (byte)-1, AlignmentTrack.ColorOption.BASE_MODIFICATION);
                float averageLikelihood = (float)modificationCounts.getLikelhoodSum(pos, key) / (float)(modificationCount * 255);
                int modHeight = (int)(averageLikelihood * (float)calledBarHeight);
                float threshold = PreferencesManager.getPreferences().getAsFloat("SAM.BASEMOD_THRESHOLD");
                if (!(averageLikelihood > threshold) || modHeight <= 0) continue;
                int baseY = pBottom - modHeight;
                graphics.setColor(modColor);
                graphics.fillRect(pX, baseY, dX, modHeight);
                pBottom = baseY;
            }
        }
    }

    private static void draw5MC(RenderContext context, int pX, int pBottom, int dX, int barHeight, int pos, AlignmentCounts alignmentCounts, boolean allMods) {
        BaseModificationCounts modificationCounts = alignmentCounts.getModifiedBaseCounts();
        if (modificationCounts != null) {
            int base = 67;
            int complement = 71;
            HashMap<String, Integer> likelihoodSums = new HashMap<String, Integer>();
            HashMap<String, Integer> modCounts = new HashMap<String, Integer>();
            for (BaseModificationCounts.Key key : modificationCounts.getAllModifications()) {
                if (key.getCanonicalBase() != 'C' || !key.getModification().equals("m") && !allMods) continue;
                String mod = key.getModification();
                int count = modificationCounts.getCount(pos, key);
                if (count <= 0) continue;
                modCounts.put(mod, count);
                int likelhoodSum = modificationCounts.getLikelhoodSum(pos, key);
                likelihoodSums.put(mod, likelhoodSum);
            }
            if (likelihoodSums.size() > 0) {
                double modifiableBaseCount = alignmentCounts.getPosCount(pos, (byte)67) + alignmentCounts.getNegCount(pos, (byte)71);
                double cgCount = alignmentCounts.getCount(pos, (byte)67) + alignmentCounts.getCount(pos, (byte)71);
                double snpFactor = cgCount / (double)alignmentCounts.getTotalCount(pos);
                double calledBarHeight = snpFactor * (double)barHeight;
                double t = modifiableBaseCount * 255.0;
                int c = (Integer)Collections.max(modCounts.values());
                double noModProb = c * 255;
                for (String m : modCounts.keySet()) {
                    if (!likelihoodSums.containsKey(m)) continue;
                    noModProb -= (double)((Integer)likelihoodSums.get(m)).intValue();
                }
                int noModHeight = (int)Math.round(noModProb / t * calledBarHeight);
                int baseY = pBottom - noModHeight;
                Graphics2D graphics = context.getGraphics();
                graphics.setColor(BaseModificationColors.noModColor5MC);
                graphics.fillRect(pX, baseY, dX, noModHeight);
                String[] orderedMods = likelihoodSums.keySet().toArray(new String[0]);
                Arrays.sort(orderedMods, (o1, o2) -> -1 * o1.compareTo((String)o2));
                for (String m : orderedMods) {
                    Color mColor = BaseModificationColors.getModColor(m, (byte)-1, AlignmentTrack.ColorOption.BASE_MODIFICATION_5MC);
                    int mModHeight = (int)Math.round((double)((Integer)likelihoodSums.get(m)).intValue() / t * calledBarHeight);
                    if (mModHeight <= 0) continue;
                    graphics.setColor(mColor);
                    graphics.fillRect(pX, baseY -= mModHeight, dX, mModHeight);
                }
            }
        }
    }
}

