/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BedData;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.CompressionUtils;

public class BigBedDataBlock {
    private static Logger log = LogManager.getLogger(BigBedDataBlock.class);
    private long fileOffset;
    private long dataBlockSize;
    private boolean isLowToHigh;
    private Map<Integer, String> chromosomeMap;
    private RPTreeLeafNodeItem leafHitItem;
    private byte[] bedBuffer;
    private int remDataSize;
    private ByteBuffer byteBuffer;
    private ArrayList<BedData> bedFeatureList;

    public BigBedDataBlock(SeekableStream fis, BBFileHeader header, RPTreeLeafNodeItem leafHitItem, Map<Integer, String> chromosomeMap, boolean isLowToHigh, int uncompressBufSize) {
        this.leafHitItem = leafHitItem;
        this.chromosomeMap = chromosomeMap;
        this.isLowToHigh = isLowToHigh;
        this.dataBlockSize = this.leafHitItem.geDataSize();
        byte[] buffer = new byte[(int)this.dataBlockSize];
        this.fileOffset = this.leafHitItem.getDataOffset();
        try {
            fis.seek(this.fileOffset);
            fis.readFully(buffer);
            this.bedBuffer = uncompressBufSize > 0 ? new CompressionUtils().decompress(buffer, uncompressBufSize) : buffer;
        }
        catch (IOException ex) {
            String error = String.format("Error reading Bed data for leaf item %d \n", new Object[0]);
            log.error(error, ex);
            throw new RuntimeException(error, ex);
        }
        ByteOrder bo = this.isLowToHigh ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.byteBuffer = ByteBuffer.wrap(this.bedBuffer);
        this.byteBuffer.order(bo);
        this.remDataSize = this.bedBuffer.length;
    }

    public ArrayList<BedData> getBedData(RPChromosomeRegion selectionRegion, boolean contained) {
        block6: {
            int itemNumber = 0;
            int minItemSize = 13;
            this.bedFeatureList = new ArrayList();
            try {
                int index = 0;
                while (this.remDataSize >= minItemSize) {
                    itemNumber = index + 1;
                    int chromID = this.byteBuffer.getInt();
                    int chromStart = this.byteBuffer.getInt();
                    int chromEnd = this.byteBuffer.getInt();
                    String restOfFields = this.readHighToLowString();
                    int leafHitValue = selectionRegion.compareRegions(chromID, chromStart, chromID, chromEnd);
                    if (leafHitValue == -2 || contained && leafHitValue == -1) {
                        this.remDataSize -= minItemSize + restOfFields.length();
                        break;
                    }
                    if (leafHitValue == 2 || contained && leafHitValue == 1) {
                        this.remDataSize -= minItemSize + restOfFields.length();
                    } else {
                        this.remDataSize -= minItemSize + restOfFields.length();
                        String chromosome = this.chromosomeMap.get(chromID);
                        BedData bbItem = new BedData(itemNumber, chromosome, chromStart, chromEnd, restOfFields);
                        this.bedFeatureList.add(bbItem);
                    }
                    ++index;
                }
            }
            catch (IOException ex) {
                log.error("Read error for Bed data item " + itemNumber, ex);
                if (itemNumber != 1) break block6;
                throw new RuntimeException("Read error for Bed data item " + itemNumber, ex);
            }
        }
        return this.bedFeatureList;
    }

    private String readHighToLowString() throws IOException {
        byte b;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(100);
        while ((b = this.byteBuffer.get()) != 0) {
            bis.write(b);
        }
        String restOfFields = new String(bis.toByteArray());
        return restOfFields;
    }

    public void print() {
        log.debug("BigBed data for " + this.bedFeatureList.size() + " items");
        for (int index = 0; index <= this.bedFeatureList.size(); ++index) {
            this.bedFeatureList.get(index).print();
        }
    }
}

