/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.mods.BaseModificationColors;
import org.broad.igv.sam.mods.BaseModificationSet;

public class BaseModificationRenderer {
    public static void drawModifications(Alignment alignment, double bpStart, double locScale, Rectangle rowRect, Graphics g, AlignmentTrack.ColorOption colorOption) {
        switch (colorOption) {
            case BASE_MODIFICATION_5MC: {
                BaseModificationRenderer.draw5mC(alignment, bpStart, locScale, rowRect, g, false);
                break;
            }
            case BASE_MODIFICATION_C: {
                BaseModificationRenderer.draw5mC(alignment, bpStart, locScale, rowRect, g, true);
                break;
            }
            default: {
                BaseModificationRenderer.draw(alignment, bpStart, locScale, rowRect, g);
            }
        }
    }

    private static void draw(Alignment alignment, double bpStart, double locScale, Rectangle rowRect, Graphics g) {
        List<BaseModificationSet> baseModificationSets = alignment.getBaseModificationSets();
        if (baseModificationSets != null) {
            block0: for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                int pY = (int)rowRect.getY();
                int dY = (int)rowRect.getHeight();
                int dX = (int)Math.max(1.0, 1.0 / locScale);
                for (int i = block.getBases().startOffset; i < block.getBases().startOffset + block.getBases().length; ++i) {
                    int blockIdx = i - block.getBases().startOffset;
                    int pX = (int)(((double)(block.getStart() + blockIdx) - bpStart) / locScale);
                    if ((double)pX > rowRect.getMaxX()) continue block0;
                    if ((double)(pX + dX) < rowRect.getX()) continue;
                    byte lh = 0;
                    String modification = null;
                    for (BaseModificationSet bmSet : baseModificationSets) {
                        if (!bmSet.containsPosition(i) || modification != null && Byte.toUnsignedInt(bmSet.getLikelihoods().get(i)) <= Byte.toUnsignedInt(lh)) continue;
                        modification = bmSet.getModification();
                        lh = bmSet.getLikelihoods().get(i);
                    }
                    if (modification == null) continue;
                    Color c = BaseModificationColors.getModColor(modification, lh, AlignmentTrack.ColorOption.BASE_MODIFICATION);
                    g.setColor(c);
                    if (dX < 3) {
                        dX = 3;
                        --pX;
                    }
                    g.fillRect(pX, pY, dX, Math.max(1, dY - 2));
                }
            }
        }
    }

    private static void draw5mC(Alignment alignment, double bpStart, double locScale, Rectangle rowRect, Graphics g, boolean allMods) {
        List<BaseModificationSet> baseModificationSets = alignment.getBaseModificationSets();
        if (baseModificationSets != null) {
            block0: for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                int pY = (int)rowRect.getY();
                int dY = (int)rowRect.getHeight();
                int dX = (int)Math.max(1.0, 1.0 / locScale);
                for (int i = block.getBases().startOffset; i < block.getBases().startOffset + block.getBases().length; ++i) {
                    int blockIdx = i - block.getBases().startOffset;
                    int pX = (int)(((double)(block.getStart() + blockIdx) - bpStart) / locScale);
                    if ((double)pX > rowRect.getMaxX()) continue block0;
                    if ((double)(pX + dX) < rowRect.getX()) continue;
                    int lh = -1;
                    String modification = null;
                    int noModificationLikelihood = 255;
                    for (BaseModificationSet bmSet : baseModificationSets) {
                        if (bmSet.getCanonicalBase() != 'C' || !bmSet.getModification().equals("m") && !allMods || !bmSet.containsPosition(i)) continue;
                        int l = Byte.toUnsignedInt(bmSet.getLikelihoods().get(i));
                        noModificationLikelihood -= l;
                        if (modification != null && l <= lh) continue;
                        modification = bmSet.getModification();
                        lh = l;
                    }
                    if (modification == null) continue;
                    Color c = noModificationLikelihood > lh ? BaseModificationColors.getNoModColor((byte)noModificationLikelihood) : BaseModificationColors.getModColor(modification, (byte)lh, AlignmentTrack.ColorOption.BASE_MODIFICATION_5MC);
                    g.setColor(c);
                    if (dX < 3) {
                        dX = 3;
                        --pX;
                    }
                    g.fillRect(pX, pY, dX, Math.max(1, dY - 2));
                }
            }
        }
    }
}

