/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;

public class ImportRegionsMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(ImportRegionsMenuAction.class);
    IGV igv;

    public ImportRegionsMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
        this.setToolTipText("Load regions from a file");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                File file = FileDialogUtils.chooseFile("Import regions of interest");
                if (file != null) {
                    ImportRegionsMenuAction.this.readRegionsOfInterestFile(file);
                }
            }
        });
    }

    private void readRegionsOfInterestFile(File roiFile) {
        if (roiFile == null) {
            log.warn("No regions found in file");
            return;
        }
        if (!roiFile.exists()) {
            MessageUtils.showMessage(roiFile.getAbsolutePath() + "  not found");
            return;
        }
        try {
            BufferedReader reader = null;
            int coordConvention = 0;
            try {
                reader = new BufferedReader(new FileReader(roiFile));
                while (true) {
                    String[] data;
                    String[] tmp;
                    String dataRecord;
                    if ((dataRecord = reader.readLine()) == null) {
                        return;
                    }
                    if (dataRecord.startsWith("track")) continue;
                    if (dataRecord.startsWith("#coords") && (tmp = dataRecord.split("=")).length > 1) {
                        try {
                            coordConvention = Integer.parseInt(tmp[1]);
                        }
                        catch (NumberFormatException e) {
                            log.error("Error parsing coordinate convention direction for file: " + roiFile);
                        }
                    }
                    if ((data = dataRecord.split("\t")).length < 2) continue;
                    try {
                        String name = data.length > 3 ? data[3] : null;
                        int start = Integer.parseInt(data[1]) - coordConvention;
                        int end = data.length > 2 ? Integer.parseInt(data[2]) : start + 1;
                        String chr = data[0];
                        Genome genome = GenomeManager.getInstance().getCurrentGenome();
                        if (genome != null) {
                            chr = genome.getCanonicalChrName(chr);
                        }
                        RegionOfInterest regionOfInterest = new RegionOfInterest(chr, start, end, name);
                        this.igv.addRegionOfInterest(regionOfInterest);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.error("Error importing regions of interest", numberFormatException);
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                this.igv.repaint();
            }
        }
        catch (Exception e) {
            log.error("Failed to write Region of Interest export file!", e);
            return;
        }
    }
}

