/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.broad.igv.Globals;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.jbrowse.CircularViewUtilities;
import org.broad.igv.lists.GeneList;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.HaplotypeUtils;
import org.broad.igv.sam.LinkedAlignment;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.sam.SortOption;
import org.broad.igv.sam.SpliceJunctionTrack;
import org.broad.igv.sashimi.SashimiPlot;
import org.broad.igv.session.Session;
import org.broad.igv.tools.PFMExporter;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.InsertSizeSettingsDialog;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.extview.ExtendViewClient;

class AlignmentTrackMenu
extends IGVPopupMenu {
    private static Logger log = LogManager.getLogger(AlignmentTrackMenu.class);
    private final AlignmentTrack alignmentTrack;
    private final AlignmentDataManager dataManager;
    private final AlignmentTrack.RenderOptions renderOptions;
    private static int nClusters = 2;

    AlignmentTrackMenu(AlignmentTrack alignmentTrack, TrackClickEvent e) {
        this.alignmentTrack = alignmentTrack;
        this.dataManager = alignmentTrack.getDataManager();
        this.renderOptions = alignmentTrack.getRenderOptions();
        MouseEvent me = e.getMouseEvent();
        ReferenceFrame frame = e.getFrame();
        Alignment clickedAlignment = frame == null ? null : alignmentTrack.getAlignmentAt(frame.getChromosomePosition(me.getX()), me.getY(), frame);
        JLabel popupTitle = new JLabel("  " + alignmentTrack.getName(), 0);
        Font newFont = this.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        this.add(popupTitle);
        if (PreferencesManager.getPreferences().getAsBoolean("CIRC_VIEW_ENABLED") && CircularViewUtilities.ping()) {
            this.addSeparator();
            JMenuItem item = new JMenuItem("Add Discordant Pairs to Circular View");
            item.setEnabled(alignmentTrack.getDataManager().isPairedEnd());
            this.add(item);
            item.addActionListener(ae -> alignmentTrack.sendPairsToCircularView(e));
            JMenuItem item2 = new JMenuItem("Add Split Reads to Circular View");
            this.add(item2);
            item2.addActionListener(ae -> alignmentTrack.sendSplitToCircularView(e));
        }
        List<Track> tracks = List.of(alignmentTrack);
        this.addSeparator();
        this.add(TrackMenuUtils.getTrackRenameItem(tracks));
        this.addCopyToClipboardItem(e, clickedAlignment);
        this.addSeparator();
        JMenuItem item = new JMenuItem("Change Track Color...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackColor(tracks));
        this.add(item);
        this.addSeparator();
        this.addExperimentTypeMenuItem();
        if (alignmentTrack.getExperimentType() == AlignmentTrack.ExperimentType.THIRD_GEN) {
            this.addHaplotype(e);
        }
        this.addLinkedReadItems();
        this.addSeparator();
        this.addGroupMenuItem(e);
        this.addSortMenuItem();
        this.addColorByMenuItem();
        this.addShadeAlignmentsMenuItem();
        this.addPackMenuItem();
        this.addSeparator();
        this.addShadeBaseByMenuItem();
        JMenuItem misMatchesItem = this.addShowMismatchesMenuItem();
        JMenuItem showAllItem = this.addShowAllBasesMenuItem();
        misMatchesItem.addActionListener(new Deselector(misMatchesItem, showAllItem));
        showAllItem.addActionListener(new Deselector(showAllItem, misMatchesItem));
        this.addSeparator();
        this.addViewAsPairsMenuItem();
        if (clickedAlignment != null) {
            this.addGoToMate(e, clickedAlignment);
            this.showMateRegion(e, clickedAlignment);
        }
        this.addInsertSizeMenuItem();
        this.addSeparator();
        this.addThirdGenItems();
        this.addSeparator();
        TrackMenuUtils.addDisplayModeItems(tracks, this);
        this.addSeparator();
        this.addSelectByNameItem();
        this.addClearSelectionsMenuItem();
        this.addSeparator();
        this.addCopySequenceItems(e);
        this.addConsensusSequence(e);
        this.addSeparator();
        this.addBlatItem(e);
        this.addBlatClippingItems(e);
        AlignmentBlock insertion = alignmentTrack.getInsertion(clickedAlignment, e.getMouseEvent().getX());
        if (insertion != null) {
            this.addSeparator();
            this.addInsertionItems(insertion);
        }
        this.addSeparator();
        JMenuItem sashimi = new JMenuItem("Sashimi Plot");
        sashimi.addActionListener(e1 -> SashimiPlot.openSashimiPlot());
        this.add(sashimi);
        this.addSeparator();
        this.addShowItems();
    }

    private void addHaplotype(TrackClickEvent e) {
        JMenuItem item = new JMenuItem("Cluster (phase) alignments");
        ReferenceFrame frame = e.getFrame() == null && FrameManager.getFrames().size() == 1 ? FrameManager.getFrames().get(0) : e.getFrame();
        item.setEnabled(frame != null);
        this.add(item);
        item.addActionListener(ae -> {
            if (frame == null) {
                MessageUtils.showMessage("Unknown region bounds");
                return;
            }
            String nString = MessageUtils.showInputDialog("Enter the number of clusters", String.valueOf(nClusters));
            if (nString == null) {
                return;
            }
            try {
                nClusters = Integer.parseInt(nString);
            }
            catch (NumberFormatException e1) {
                MessageUtils.showMessage("Clusters size must be an integer");
                return;
            }
            int start = (int)frame.getOrigin();
            int end = (int)frame.getEnd();
            AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
            HaplotypeUtils haplotypeUtils = new HaplotypeUtils(interval);
            boolean success = haplotypeUtils.clusterAlignments(frame.getChrName(), start, end, nClusters);
            if (success) {
                this.alignmentTrack.groupAlignments(AlignmentTrack.GroupOption.HAPLOTYPE, null, null);
                this.alignmentTrack.repaint();
            }
        });
    }

    private void addConsensusSequence(TrackClickEvent e) {
        JMenuItem item = new JMenuItem("Copy consensus sequence");
        ReferenceFrame frame = e.getFrame() == null && FrameManager.getFrames().size() == 1 ? FrameManager.getFrames().get(0) : e.getFrame();
        item.setEnabled(frame != null);
        this.add(item);
        item.addActionListener(ae -> {
            if (frame == null) {
                MessageUtils.showMessage("Unknown region bounds, cannot export consensus");
                return;
            }
            int start = (int)frame.getOrigin();
            int end = (int)frame.getEnd();
            if (end - start > 1000000) {
                MessageUtils.showMessage("Cannot export region more than 1 Megabase");
                return;
            }
            AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
            AlignmentCounts counts = interval.getCounts();
            String text = PFMExporter.createPFMText(counts, frame.getChrName(), start, end);
            StringUtils.copyTextToClipboard(text);
        });
    }

    private JMenu getBisulfiteContextMenuItem(ButtonGroup group) {
        JMenu bisulfiteContextMenu = new JMenu("bisulfite mode");
        JRadioButtonMenuItem nomeESeqOption = null;
        boolean showNomeESeq = this.alignmentTrack.getPreferences().getAsBoolean("SAM.NOMESEQ_ENABLED");
        if (showNomeESeq) {
            nomeESeqOption = new JRadioButtonMenuItem("NOMe-seq bisulfite mode");
            nomeESeqOption.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.NOMESEQ);
            nomeESeqOption.addActionListener(aEvt -> {
                this.alignmentTrack.setColorOption(AlignmentTrack.ColorOption.NOMESEQ);
                this.alignmentTrack.repaint();
            });
            group.add(nomeESeqOption);
        }
        for (AlignmentTrack.BisulfiteContext item : AlignmentTrack.BisulfiteContext.values()) {
            String optionStr = AlignmentTrackMenu.getBisulfiteContextPubStr(item);
            JRadioButtonMenuItem m1 = new JRadioButtonMenuItem(optionStr);
            m1.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.BISULFITE && this.renderOptions.bisulfiteContext == item);
            m1.addActionListener(aEvt -> {
                this.alignmentTrack.setColorOption(AlignmentTrack.ColorOption.BISULFITE);
                this.alignmentTrack.setBisulfiteContext(item);
                this.alignmentTrack.repaint();
            });
            bisulfiteContextMenu.add(m1);
            group.add(m1);
        }
        if (nomeESeqOption != null) {
            bisulfiteContextMenu.add(nomeESeqOption);
        }
        return bisulfiteContextMenu;
    }

    void addSelectByNameItem() {
        JMenuItem item = new JMenuItem("Select by name...");
        item.addActionListener(aEvt -> {
            String val = MessageUtils.showInputDialog("Enter read name: ");
            if (val != null && val.trim().length() > 0) {
                this.alignmentTrack.getSelectedReadNames().put(val, this.alignmentTrack.getReadNamePalette().get(val));
                this.alignmentTrack.repaint();
            }
        });
        this.add(item);
    }

    void addExperimentTypeMenuItem() {
        LinkedHashMap<String, AlignmentTrack.ExperimentType> mappings = new LinkedHashMap<String, AlignmentTrack.ExperimentType>();
        mappings.put("Other", AlignmentTrack.ExperimentType.OTHER);
        mappings.put("RNA", AlignmentTrack.ExperimentType.RNA);
        mappings.put("3rd Gen", AlignmentTrack.ExperimentType.THIRD_GEN);
        JMenu groupMenu = new JMenu("Experiment Type");
        ButtonGroup group = new ButtonGroup();
        for (Map.Entry el : mappings.entrySet()) {
            JCheckBoxMenuItem mi = this.getExperimentTypeMenuItem((String)el.getKey(), (AlignmentTrack.ExperimentType)((Object)el.getValue()));
            groupMenu.add(mi);
            group.add(mi);
        }
        this.add(groupMenu);
    }

    private JCheckBoxMenuItem getExperimentTypeMenuItem(String label, AlignmentTrack.ExperimentType option) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label);
        mi.setSelected(this.alignmentTrack.getExperimentType() == option);
        mi.addActionListener(aEvt -> this.alignmentTrack.setExperimentType(option));
        return mi;
    }

    void addGroupMenuItem(TrackClickEvent te) {
        AlignmentTrack.GroupOption[] groupOptions;
        MouseEvent me = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            frame = FrameManager.getDefaultFrame();
        }
        Range range = frame.getCurrentRange();
        String chrom = range.getChr();
        int chromStart = (int)frame.getChromosomePosition(me.getX());
        JMenu groupMenu = new JMenu("Group alignments by");
        ButtonGroup group = new ButtonGroup();
        for (AlignmentTrack.GroupOption option : groupOptions = new AlignmentTrack.GroupOption[]{AlignmentTrack.GroupOption.NONE, AlignmentTrack.GroupOption.STRAND, AlignmentTrack.GroupOption.FIRST_OF_PAIR_STRAND, AlignmentTrack.GroupOption.SAMPLE, AlignmentTrack.GroupOption.LIBRARY, AlignmentTrack.GroupOption.READ_GROUP, AlignmentTrack.GroupOption.MATE_CHROMOSOME, AlignmentTrack.GroupOption.PAIR_ORIENTATION, AlignmentTrack.GroupOption.SUPPLEMENTARY, AlignmentTrack.GroupOption.REFERENCE_CONCORDANCE, AlignmentTrack.GroupOption.MOVIE, AlignmentTrack.GroupOption.ZMW, AlignmentTrack.GroupOption.READ_ORDER, AlignmentTrack.GroupOption.LINKED, AlignmentTrack.GroupOption.PHASE, AlignmentTrack.GroupOption.MAPPING_QUALITY}) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(option.label);
            mi.setSelected(this.renderOptions.getGroupByOption() == option);
            mi.addActionListener(aEvt -> this.alignmentTrack.groupAlignments(option, null, null));
            groupMenu.add(mi);
            group.add(mi);
        }
        JCheckBoxMenuItem tagOption = new JCheckBoxMenuItem("tag");
        tagOption.addActionListener(aEvt -> {
            String tag = MessageUtils.showInputDialog("Enter tag", this.renderOptions.getGroupByTag());
            if (tag != null) {
                if (tag.trim().length() > 0) {
                    this.alignmentTrack.groupAlignments(AlignmentTrack.GroupOption.TAG, tag, null);
                } else {
                    this.alignmentTrack.groupAlignments(AlignmentTrack.GroupOption.NONE, null, null);
                }
            }
        });
        tagOption.setSelected(this.renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.TAG);
        groupMenu.add(tagOption);
        group.add(tagOption);
        Range oldGroupByPos = this.renderOptions.getGroupByPos();
        if (oldGroupByPos != null && this.renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.BASE_AT_POS) {
            JCheckBoxMenuItem oldGroupByPosOption = new JCheckBoxMenuItem("base at " + oldGroupByPos.getChr() + ":" + Globals.DECIMAL_FORMAT.format(1 + oldGroupByPos.getStart()));
            groupMenu.add(oldGroupByPosOption);
            oldGroupByPosOption.setSelected(true);
        }
        if (this.renderOptions.getGroupByOption() != AlignmentTrack.GroupOption.BASE_AT_POS || oldGroupByPos == null || !oldGroupByPos.getChr().equals(chrom) || oldGroupByPos.getStart() != chromStart) {
            JCheckBoxMenuItem newGroupByPosOption = new JCheckBoxMenuItem("base at " + chrom + ":" + Globals.DECIMAL_FORMAT.format(1 + chromStart));
            newGroupByPosOption.addActionListener(aEvt -> {
                Range groupByPos = new Range(chrom, chromStart, chromStart + 1);
                this.alignmentTrack.groupAlignments(AlignmentTrack.GroupOption.BASE_AT_POS, null, groupByPos);
            });
            groupMenu.add(newGroupByPosOption);
            group.add(newGroupByPosOption);
        }
        groupMenu.add(new JPopupMenu.Separator());
        JCheckBoxMenuItem invertGroupNameSortingOption = new JCheckBoxMenuItem("Reverse group order");
        invertGroupNameSortingOption.setSelected(this.renderOptions.isInvertGroupSorting());
        invertGroupNameSortingOption.addActionListener(aEvt -> {
            this.renderOptions.setInvertGroupSorting(!this.renderOptions.isInvertGroupSorting());
            this.dataManager.packAlignments(this.renderOptions);
            this.alignmentTrack.repaint();
        });
        groupMenu.add(invertGroupNameSortingOption);
        this.add(groupMenu);
    }

    void addSortMenuItem() {
        JMenu sortMenu = new JMenu("Sort alignments by");
        LinkedHashMap<String, SortOption> mappings = new LinkedHashMap<String, SortOption>();
        mappings.put("start location", SortOption.START);
        mappings.put("read strand", SortOption.STRAND);
        mappings.put("first-of-pair strand", SortOption.FIRST_OF_PAIR_STRAND);
        mappings.put("base", SortOption.NUCLEOTIDE);
        mappings.put("mapping quality", SortOption.QUALITY);
        mappings.put("sample", SortOption.SAMPLE);
        mappings.put("read group", SortOption.READ_GROUP);
        mappings.put("read order", SortOption.READ_ORDER);
        mappings.put("read name", SortOption.READ_NAME);
        mappings.put("aligned read length", SortOption.ALIGNED_READ_LENGTH);
        if (this.dataManager.isPairedEnd()) {
            mappings.put("insert size", SortOption.INSERT_SIZE);
            mappings.put("chromosome of mate", SortOption.MATE_CHR);
        }
        for (Map.Entry el : mappings.entrySet()) {
            JMenuItem mi = new JMenuItem((String)el.getKey());
            mi.addActionListener(aEvt -> {
                SortOption option = (SortOption)((Object)((Object)el.getValue()));
                this.renderOptions.setSortOption(option);
                this.alignmentTrack.sortAlignmentTracks(option, null, this.renderOptions.isInvertSorting());
            });
            sortMenu.add(mi);
        }
        JMenuItem tagOption = new JMenuItem("tag");
        tagOption.addActionListener(aEvt -> {
            String tag = MessageUtils.showInputDialog("Enter tag", this.renderOptions.getSortByTag());
            if (tag != null && tag.trim().length() > 0) {
                this.renderOptions.setSortByTag(tag);
                this.renderOptions.setSortOption(SortOption.TAG);
                this.alignmentTrack.sortAlignmentTracks(SortOption.TAG, tag, this.renderOptions.isInvertSorting());
            }
        });
        sortMenu.add(tagOption);
        sortMenu.add(new JPopupMenu.Separator());
        JCheckBoxMenuItem invertGroupNameSortingOption = new JCheckBoxMenuItem("reverse sorting");
        invertGroupNameSortingOption.setSelected(this.renderOptions.isInvertSorting());
        invertGroupNameSortingOption.addActionListener(aEvt -> {
            boolean updatedInvertSorting = !this.renderOptions.isInvertSorting();
            this.renderOptions.setInvertSorting(updatedInvertSorting);
            this.alignmentTrack.sortAlignmentTracks(this.renderOptions.getSortOption(), this.renderOptions.getSortByTag(), updatedInvertSorting);
        });
        sortMenu.add(invertGroupNameSortingOption);
        this.add(sortMenu);
    }

    public void addFilterMenuItem() {
        JMenu filterMenu = new JMenu("Filter alignments by");
        JMenuItem mi = new JMenuItem("mapping quality");
        mi.addActionListener(aEvt -> {
            String defString = PreferencesManager.getPreferences().get("SAM.QUALITY_THRESHOLD");
            if (defString == null) {
                defString = "";
            }
            String mqString = MessageUtils.showInputDialog("Minimum mapping quality: ", defString);
            try {
                int n = Integer.parseInt(mqString);
            }
            catch (NumberFormatException e) {
                MessageUtils.showMessage("Mapping quality must be an integer");
            }
        });
        filterMenu.add(mi);
        this.add(filterMenu);
    }

    private JRadioButtonMenuItem getColorMenuItem(String label, AlignmentTrack.ColorOption option) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(label);
        mi.setSelected(this.renderOptions.getColorOption() == option);
        mi.addActionListener(aEvt -> {
            this.alignmentTrack.setColorOption(option);
            this.alignmentTrack.repaint();
        });
        return mi;
    }

    void addColorByMenuItem() {
        JMenu colorMenu = new JMenu("Color alignments by");
        ButtonGroup group = new ButtonGroup();
        LinkedHashMap<String, AlignmentTrack.ColorOption> mappings = new LinkedHashMap<String, AlignmentTrack.ColorOption>();
        mappings.put("none", AlignmentTrack.ColorOption.NONE);
        if (this.dataManager.hasYCTags()) {
            mappings.put("YC tag", AlignmentTrack.ColorOption.YC_TAG);
        }
        if (this.dataManager.isPairedEnd()) {
            mappings.put("insert size", AlignmentTrack.ColorOption.INSERT_SIZE);
            mappings.put("pair orientation", AlignmentTrack.ColorOption.PAIR_ORIENTATION);
            mappings.put("insert size and pair orientation", AlignmentTrack.ColorOption.UNEXPECTED_PAIR);
        }
        mappings.put("read strand", AlignmentTrack.ColorOption.READ_STRAND);
        if (this.dataManager.isPairedEnd()) {
            mappings.put("first-of-pair strand", AlignmentTrack.ColorOption.FIRST_OF_PAIR_STRAND);
        }
        mappings.put("read group", AlignmentTrack.ColorOption.READ_GROUP);
        if (this.dataManager.isPairedEnd()) {
            mappings.put("read order", AlignmentTrack.ColorOption.READ_ORDER);
        }
        mappings.put("sample", AlignmentTrack.ColorOption.SAMPLE);
        mappings.put("library", AlignmentTrack.ColorOption.LIBRARY);
        mappings.put("movie", AlignmentTrack.ColorOption.MOVIE);
        mappings.put("ZMW", AlignmentTrack.ColorOption.ZMW);
        for (Map.Entry el : mappings.entrySet()) {
            JRadioButtonMenuItem mi = this.getColorMenuItem((String)el.getKey(), (AlignmentTrack.ColorOption)((Object)el.getValue()));
            colorMenu.add(mi);
            group.add(mi);
        }
        JRadioButtonMenuItem tagOption = new JRadioButtonMenuItem("tag");
        tagOption.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.TAG);
        tagOption.addActionListener(aEvt -> {
            this.alignmentTrack.setColorOption(AlignmentTrack.ColorOption.TAG);
            String tag = MessageUtils.showInputDialog("Enter tag", this.renderOptions.getColorByTag());
            if (tag != null && tag.trim().length() > 0) {
                this.alignmentTrack.setColorByTag(tag);
                this.alignmentTrack.repaint();
            }
        });
        colorMenu.add(tagOption);
        group.add(tagOption);
        colorMenu.add(this.getBisulfiteContextMenuItem(group));
        mappings.clear();
        mappings.put("base modification", AlignmentTrack.ColorOption.BASE_MODIFICATION);
        mappings.put("base modification (5mC)", AlignmentTrack.ColorOption.BASE_MODIFICATION_5MC);
        mappings.put("base modification (all C)", AlignmentTrack.ColorOption.BASE_MODIFICATION_C);
        colorMenu.addSeparator();
        for (Map.Entry el : mappings.entrySet()) {
            JRadioButtonMenuItem mi = this.getColorMenuItem((String)el.getKey(), (AlignmentTrack.ColorOption)((Object)el.getValue()));
            colorMenu.add(mi);
            group.add(mi);
        }
        this.add(colorMenu);
    }

    void addShadeAlignmentsMenuItem() {
        JMenu shadeMenu = new JMenu("Shade alignments by");
        for (AlignmentTrack.ShadeAlignmentsOption option : AlignmentTrack.ShadeAlignmentsOption.values()) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(option.label);
            mi.setSelected(this.renderOptions.getShadeAlignmentsOption() == option);
            mi.addActionListener(aEvt -> {
                this.alignmentTrack.setShadeAlignmentsOptions(option);
                this.alignmentTrack.repaint();
            });
            shadeMenu.add(mi);
        }
        this.add(shadeMenu);
    }

    void addPackMenuItem() {
        JMenuItem item = new JMenuItem("Re-pack alignments");
        item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            IGV.getInstance().packAlignmentTracks();
            this.alignmentTrack.repaint();
        }));
        this.add(item);
    }

    void addCopyToClipboardItem(TrackClickEvent te, Alignment alignment) {
        MouseEvent me = te.getMouseEvent();
        JMenuItem item = new JMenuItem("Copy read details to clipboard");
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            item.setEnabled(false);
        } else {
            double location = frame.getChromosomePosition(me.getX());
            item.addActionListener(aEvt -> this.copyToClipboard(te, alignment, location, me.getX()));
            if (alignment == null) {
                item.setEnabled(false);
            }
        }
        this.add(item);
    }

    void addViewAsPairsMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("View as pairs");
        item.setSelected(this.renderOptions.isViewPairs());
        item.addActionListener(aEvt -> {
            boolean viewAsPairs = item.isSelected();
            this.alignmentTrack.setViewAsPairs(viewAsPairs);
        });
        item.setEnabled(this.dataManager.isPairedEnd());
        this.add(item);
    }

    void addGoToMate(TrackClickEvent te, Alignment alignment) {
        JMenuItem item = new JMenuItem("Go to mate");
        MouseEvent e = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            item.setEnabled(false);
        } else {
            item.addActionListener(aEvt -> this.gotoMate(te, alignment));
            if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                item.setEnabled(false);
            }
        }
        this.add(item);
    }

    void showMateRegion(TrackClickEvent te, Alignment clickedAlignment) {
        JMenuItem item = new JMenuItem("View mate region in split screen");
        MouseEvent e = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            item.setEnabled(false);
        } else {
            double location = frame.getChromosomePosition(e.getX());
            if (clickedAlignment instanceof PairedAlignment) {
                Alignment first = ((PairedAlignment)clickedAlignment).getFirstAlignment();
                Alignment second = ((PairedAlignment)clickedAlignment).getSecondAlignment();
                clickedAlignment = first.contains(location) ? first : (second.contains(location) ? second : null);
            }
            Alignment alignment = clickedAlignment;
            item.addActionListener(aEvt -> this.splitScreenMate(te, alignment));
            if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                item.setEnabled(false);
            }
        }
        this.add(item);
    }

    void addClearSelectionsMenuItem() {
        JMenuItem item = new JMenuItem("Clear selections");
        item.addActionListener(aEvt -> {
            this.alignmentTrack.getSelectedReadNames().clear();
            this.alignmentTrack.repaint();
        });
        this.add(item);
    }

    JMenuItem addShowAllBasesMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show all bases");
        if (this.renderOptions.getColorOption() != AlignmentTrack.ColorOption.BISULFITE && this.renderOptions.getColorOption() != AlignmentTrack.ColorOption.NOMESEQ) {
            item.setSelected(this.renderOptions.isShowAllBases());
        }
        item.addActionListener(aEvt -> {
            this.renderOptions.setShowAllBases(item.isSelected());
            this.alignmentTrack.repaint();
        });
        this.add(item);
        return item;
    }

    void addQuickConsensusModeItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Quick consensus mode");
        item.setSelected(this.renderOptions.isQuickConsensusMode());
        item.addActionListener(aEvt -> {
            this.renderOptions.setQuickConsensusMode(item.isSelected());
            this.alignmentTrack.repaint();
        });
        this.add(item);
    }

    JMenuItem addShowMismatchesMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show mismatched bases");
        item.setSelected(this.renderOptions.isShowMismatches());
        item.addActionListener(aEvt -> {
            this.renderOptions.setShowMismatches(item.isSelected());
            this.alignmentTrack.repaint();
        });
        this.add(item);
        return item;
    }

    void addInsertSizeMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set insert size options ...");
        item.addActionListener(aEvt -> {
            InsertSizeSettingsDialog dlg = new InsertSizeSettingsDialog(IGV.getInstance().getMainFrame(), this.renderOptions);
            dlg.setModal(true);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                this.renderOptions.setComputeIsizes(dlg.isComputeIsize());
                this.renderOptions.setMinInsertSizePercentile(dlg.getMinPercentile());
                this.renderOptions.setMaxInsertSizePercentile(dlg.getMaxPercentile());
                if (this.renderOptions.computeIsizes.booleanValue()) {
                    this.dataManager.updatePEStats(this.renderOptions);
                }
                this.renderOptions.setMinInsertSize(dlg.getMinThreshold());
                this.renderOptions.setMaxInsertSize(dlg.getMaxThreshold());
                this.alignmentTrack.repaint();
            }
        });
        item.setEnabled(this.dataManager.isPairedEnd());
        this.add(item);
    }

    void addShadeBaseByMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade base by quality");
        item.setSelected(this.renderOptions.getShadeBasesOption());
        item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            this.renderOptions.setShadeBasesOption(item.isSelected());
            this.alignmentTrack.repaint();
        }));
        this.add(item);
    }

    void addShowItems() {
        SpliceJunctionTrack spliceJunctionTrack;
        CoverageTrack coverageTrack1 = this.alignmentTrack.getCoverageTrack();
        CoverageTrack coverageTrack = coverageTrack1;
        if (coverageTrack != null) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Coverage Track");
            item.setSelected(coverageTrack.isVisible());
            item.setEnabled(!coverageTrack.isRemoved());
            item.addActionListener(aEvt -> {
                coverageTrack.setVisible(item.isSelected());
                IGV.getInstance().repaint(Arrays.asList(coverageTrack));
            });
            this.add(item);
        }
        if ((spliceJunctionTrack = this.alignmentTrack.getSpliceJunctionTrack()) != null) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Splice Junction Track");
            item.setSelected(spliceJunctionTrack.isVisible());
            item.setEnabled(!spliceJunctionTrack.isRemoved());
            item.addActionListener(aEvt -> {
                this.alignmentTrack.setVisible(item.isSelected());
                IGV.getInstance().repaint(Arrays.asList(spliceJunctionTrack));
            });
            this.add(item);
        }
        JCheckBoxMenuItem alignmentItem = new JCheckBoxMenuItem("Show Alignment Track");
        alignmentItem.setSelected(true);
        alignmentItem.addActionListener(e -> {
            this.alignmentTrack.setVisible(alignmentItem.isSelected());
            IGV.getInstance().repaint(Arrays.asList(this.alignmentTrack));
        });
        if (!(coverageTrack != null && coverageTrack.isVisible() || spliceJunctionTrack != null && spliceJunctionTrack.isVisible())) {
            alignmentItem.setEnabled(false);
        }
        this.add(alignmentItem);
    }

    void addCopySequenceItems(TrackClickEvent te) {
        JMenuItem item = new JMenuItem("Copy read sequence");
        this.add(item);
        Alignment alignment = this.getSpecficAlignment(te);
        if (alignment == null) {
            item.setEnabled(false);
            return;
        }
        String seq = alignment.getReadSequence();
        if (seq == null) {
            item.setEnabled(false);
            return;
        }
        item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(seq));
        int minimumBlatLength = 20;
        int[] clipping = SAMAlignment.getClipping(alignment.getCigarString());
        if (clipping[1] > 0) {
            String lcSeq = this.getClippedSequence(alignment.getReadSequence(), alignment.getReadStrand(), 0, clipping[1]);
            JMenuItem lccItem = new JMenuItem("Copy left-clipped sequence");
            this.add(lccItem);
            lccItem.addActionListener(aEvt -> StringUtils.copyTextToClipboard(lcSeq));
        }
        if (clipping[3] > 0) {
            int seqLength = seq.length();
            String rcSeq = this.getClippedSequence(alignment.getReadSequence(), alignment.getReadStrand(), seqLength - clipping[3], seqLength);
            JMenuItem rccItem = new JMenuItem("Copy right-clipped sequence");
            this.add(rccItem);
            rccItem.addActionListener(aEvt -> StringUtils.copyTextToClipboard(rcSeq));
        }
    }

    void addBlatItem(TrackClickEvent te) {
        JMenuItem item = new JMenuItem("BLAT read sequence");
        this.add(item);
        Alignment alignment = this.getSpecficAlignment(te);
        if (alignment == null) {
            item.setEnabled(false);
            return;
        }
        String seq = alignment.getReadSequence();
        if (seq == null || seq.equals("*")) {
            item.setEnabled(false);
            return;
        }
        item.addActionListener(aEvt -> {
            String blatSeq = alignment.getReadStrand() == Strand.NEGATIVE ? SequenceTrack.getReverseComplement(seq) : seq;
            BlatClient.doBlatQuery(blatSeq, alignment.getReadName());
        });
    }

    void addBlatClippingItems(TrackClickEvent te) {
        Alignment alignment = this.getSpecficAlignment(te);
        if (alignment == null) {
            return;
        }
        int minimumBlatLength = 20;
        int[] clipping = SAMAlignment.getClipping(alignment.getCigarString());
        if (clipping[1] > minimumBlatLength) {
            String lcSeq = this.getClippedSequence(alignment.getReadSequence(), alignment.getReadStrand(), 0, clipping[1]);
            JMenuItem lcbItem = new JMenuItem("BLAT left-clipped sequence");
            this.add(lcbItem);
            lcbItem.addActionListener(aEvt -> BlatClient.doBlatQuery(lcSeq, alignment.getReadName() + " - left clip"));
        }
        if (clipping[3] > minimumBlatLength) {
            String seq = alignment.getReadSequence();
            int seqLength = seq.length();
            String rcSeq = this.getClippedSequence(alignment.getReadSequence(), alignment.getReadStrand(), seqLength - clipping[3], seqLength);
            JMenuItem rcbItem = new JMenuItem("BLAT right-clipped sequence");
            this.add(rcbItem);
            rcbItem.addActionListener(aEvt -> BlatClient.doBlatQuery(rcSeq, alignment.getReadName() + " - right clip"));
        }
    }

    private String getClippedSequence(String readSequence, Strand strand, int i, int i2) {
        if (readSequence == null || readSequence.equals("*")) {
            return "*";
        }
        String seq = readSequence.substring(i, i2);
        if (strand == Strand.NEGATIVE) {
            seq = SequenceTrack.getReverseComplement(seq);
        }
        return seq;
    }

    void addExtViewItem(TrackClickEvent te) {
        JMenuItem item = new JMenuItem("ExtView");
        this.add(item);
        Alignment alignment = this.getAlignment(te);
        if (alignment == null) {
            item.setEnabled(false);
            return;
        }
        String seq = alignment.getReadSequence();
        if (seq == null) {
            item.setEnabled(false);
            return;
        }
        item.addActionListener(aEvt -> ExtendViewClient.postExtendView(alignment));
    }

    void addLinkedReadItems() {
        this.addSeparator();
        this.add(this.linkedReadViewItem("BX"));
        this.add(this.linkedReadViewItem("MI"));
        this.addSeparator();
        JCheckBoxMenuItem supplementalItem = new JCheckBoxMenuItem("Link supplementary alignments");
        supplementalItem.setSelected(this.alignmentTrack.isLinkedReads() && "READNAME".equals(this.renderOptions.getLinkByTag()));
        supplementalItem.addActionListener(aEvt -> {
            boolean linkedReads = supplementalItem.isSelected();
            this.setLinkByTag(linkedReads, "READNAME");
        });
        this.add(supplementalItem);
        String linkedTagsString = PreferencesManager.getPreferences().get("SAM.LINK_BY_TAGS");
        if (linkedTagsString != null) {
            String[] t;
            for (String tag : t = Globals.commaPattern.split(linkedTagsString)) {
                if (tag.length() <= 0) continue;
                this.add(this.linkedReadItem(tag));
            }
        }
        JMenuItem linkByTagItem = new JMenuItem("Link by tag...");
        linkByTagItem.addActionListener(aEvt -> {
            String tag = MessageUtils.showInputDialog("Link by tag:");
            if (tag != null) {
                this.setLinkByTag(true, tag);
                Object linkedTags = PreferencesManager.getPreferences().get("SAM.LINK_BY_TAGS");
                linkedTags = linkedTags == null ? tag : (String)linkedTags + "," + tag;
                PreferencesManager.getPreferences().put("SAM.LINK_BY_TAGS", (String)linkedTags);
            }
        });
        this.add(linkByTagItem);
    }

    private JCheckBoxMenuItem linkedReadViewItem(String tag) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Linked read view (" + tag + ")");
        item.setSelected(this.alignmentTrack.isLinkedReadView() && tag != null && tag.equals(this.renderOptions.getLinkByTag()));
        item.addActionListener(aEvt -> {
            boolean linkedReads = item.isSelected();
            this.alignmentTrack.setLinkedReadView(linkedReads, tag);
        });
        return item;
    }

    private JCheckBoxMenuItem linkedReadItem(String tag) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Link by " + tag);
        item.setSelected(!this.alignmentTrack.isLinkedReadView() && this.alignmentTrack.isLinkedReads() && tag.equals(this.renderOptions.getLinkByTag()));
        item.addActionListener(aEvt -> {
            boolean linkedReads = item.isSelected();
            this.setLinkByTag(linkedReads, tag);
        });
        return item;
    }

    private void addInsertionItems(AlignmentBlock insertion) {
        JMenuItem item = new JMenuItem("Copy insert sequence");
        this.add(item);
        item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(insertion.getBases().getString()));
        if (insertion.getBases() != null && insertion.getBases().length >= 10) {
            JMenuItem blatItem = new JMenuItem("BLAT insert sequence");
            this.add(blatItem);
            blatItem.addActionListener(aEvt -> {
                String blatSeq = insertion.getBases().getString();
                BlatClient.doBlatQuery(blatSeq, "BLAT insert sequence");
            });
        }
    }

    void addThirdGenItems() {
        JCheckBoxMenuItem qcItem = new JCheckBoxMenuItem("Quick consensus mode");
        qcItem.setSelected(this.renderOptions.isQuickConsensusMode());
        qcItem.addActionListener(aEvt -> {
            this.renderOptions.setQuickConsensusMode(qcItem.isSelected());
            this.alignmentTrack.repaint();
        });
        JMenuItem thresholdItem = new JMenuItem("Small indel threshold...");
        thresholdItem.addActionListener(evt -> UIUtilities.invokeOnEventThread(() -> {
            String sith = MessageUtils.showInputDialog("Small indel threshold: ", String.valueOf(this.renderOptions.getSmallIndelThreshold()));
            try {
                this.renderOptions.setSmallIndelThreshold(Integer.parseInt(sith));
                this.alignmentTrack.repaint();
            }
            catch (NumberFormatException e) {
                log.error("Error setting small indel threshold - not an integer", e);
            }
        }));
        thresholdItem.setEnabled(this.renderOptions.isHideSmallIndels());
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Hide small indels");
        item.setSelected(this.renderOptions.isHideSmallIndels());
        item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            this.renderOptions.setHideSmallIndels(item.isSelected());
            thresholdItem.setEnabled(item.isSelected());
            this.alignmentTrack.repaint();
        }));
        JCheckBoxMenuItem imItem = new JCheckBoxMenuItem("Show insertion markers");
        imItem.setSelected(this.renderOptions.isShowInsertionMarkers());
        imItem.addActionListener(aEvt -> {
            this.renderOptions.setShowInsertionMarkers(imItem.isSelected());
            this.alignmentTrack.repaint();
        });
        this.add(imItem);
        this.add(qcItem);
        this.add(item);
        this.add(thresholdItem);
    }

    private void copyToClipboard(TrackClickEvent e, Alignment alignment, double location, int mouseX) {
        if (alignment != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(alignment.getClipboardString(location, mouseX).replace("<b>", "").replace("</b>", "").replace("<br>", "\n").replace("<br/>", "\n").replace("<hr>", "\n------------------\n").replace("<hr/>", "\n------------------\n"));
            buf.append("\n");
            buf.append("Alignment start position = ").append(alignment.getChr()).append(":").append(alignment.getAlignmentStart() + 1);
            buf.append("\n");
            buf.append(alignment.getReadSequence());
            StringSelection stringSelection = new StringSelection(buf.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private void gotoMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.alignmentTrack.setSelectedAlignment(alignment);
                String chr = mate.getChr();
                int start = mate.start - 1;
                double range = te.getFrame().getEnd() - te.getFrame().getOrigin();
                int newStart = (int)Math.max(0.0, (double)(start + (alignment.getEnd() - alignment.getStart()) / 2) - range / 2.0);
                int newEnd = newStart + (int)range;
                te.getFrame().jumpTo(chr, newStart, newEnd);
                te.getFrame().recordHistory();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    private void splitScreenMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                List<Object> loci;
                this.alignmentTrack.setSelectedAlignment(alignment);
                String mateChr = mate.getChr();
                int mateStart = mate.start - 1;
                ReferenceFrame frame = te.getFrame();
                String locus1 = frame.getFormattedLocusString();
                Range range = frame.getCurrentRange();
                int length = range.getLength();
                int s2 = Math.max(0, mateStart - length / 2);
                int e2 = s2 + length;
                String startStr = String.valueOf(s2);
                String endStr = String.valueOf(e2);
                String mateLocus = mateChr + ":" + startStr + "-" + endStr;
                Session currentSession = IGV.getInstance().getSession();
                if (FrameManager.isGeneListMode()) {
                    loci = new ArrayList(FrameManager.getFrames().size());
                    for (ReferenceFrame referenceFrame : FrameManager.getFrames()) {
                        String string = referenceFrame.getName();
                        if (Locus.fromString(string) != null) {
                            loci.add(string);
                            continue;
                        }
                        loci.add(referenceFrame.getFormattedLocusString());
                    }
                    loci.add(mateLocus);
                } else {
                    loci = Arrays.asList(locus1, mateLocus);
                }
                StringBuilder listName = new StringBuilder();
                for (String string : loci) {
                    listName.append(string + "   ");
                }
                GeneList geneList = new GeneList(listName.toString(), loci, false);
                currentSession.setCurrentGeneList(geneList);
                Comparator comparator = (n0, n1) -> {
                    ReferenceFrame f0 = FrameManager.getFrame(n0);
                    ReferenceFrame f1 = FrameManager.getFrame(n1);
                    String chr0 = f0 == null ? "" : f0.getChrName();
                    String chr1 = f1 == null ? "" : f1.getChrName();
                    int s0 = f0 == null ? 0 : f0.getCurrentRange().getStart();
                    int s1 = f1 == null ? 0 : f1.getCurrentRange().getStart();
                    int chrComp = ChromosomeNameComparator.get().compare(chr0, chr1);
                    if (chrComp != 0) {
                        return chrComp;
                    }
                    return s0 - s1;
                };
                currentSession.sortGeneList(comparator);
                IGV.getInstance().resetFrames();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    Alignment getSpecficAlignment(TrackClickEvent te) {
        Alignment alignment = this.getAlignment(te);
        if (alignment != null) {
            ReferenceFrame frame = te.getFrame();
            MouseEvent e = te.getMouseEvent();
            double location = frame.getChromosomePosition(e.getX());
            if (alignment instanceof LinkedAlignment) {
                Alignment sa = null;
                for (Alignment a : ((LinkedAlignment)alignment).alignments) {
                    if (!a.contains(location) || sa != null && a.getAlignmentEnd() - a.getAlignmentStart() >= sa.getAlignmentEnd() - sa.getAlignmentStart()) continue;
                    sa = a;
                }
                alignment = sa;
            } else if (alignment instanceof PairedAlignment) {
                Alignment sa = null;
                if (((PairedAlignment)alignment).firstAlignment.contains(location)) {
                    sa = ((PairedAlignment)alignment).firstAlignment;
                } else if (((PairedAlignment)alignment).secondAlignment.contains(location)) {
                    sa = ((PairedAlignment)alignment).secondAlignment;
                }
                alignment = sa;
            }
        }
        return alignment;
    }

    private void setLinkByTag(boolean linkReads, String tag) {
        if (this.alignmentTrack.isLinkedReadView()) {
            this.alignmentTrack.undoLinkedReadView();
        }
        if (linkReads) {
            this.renderOptions.setLinkByTag(tag);
            if (this.renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.NONE) {
                this.renderOptions.setGroupByOption(AlignmentTrack.GroupOption.LINKED);
            }
        } else {
            this.renderOptions.setLinkByTag(null);
            if (this.renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.LINKED) {
                this.renderOptions.setGroupByOption(AlignmentTrack.GroupOption.NONE);
            }
        }
        this.renderOptions.setLinkedReads(linkReads);
        this.dataManager.packAlignments(this.renderOptions);
        this.repaint();
    }

    private Alignment getAlignment(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            return null;
        }
        double location = frame.getChromosomePosition(e.getX());
        return this.alignmentTrack.getAlignmentAt(location, e.getY(), frame);
    }

    private static String getBisulfiteContextPubStr(AlignmentTrack.BisulfiteContext item) {
        return AlignmentTrack.bisulfiteContextToPubString.get((Object)item);
    }

    private static class Deselector
    implements ActionListener {
        private final JMenuItem toDeselect;
        private final JMenuItem parent;

        Deselector(JMenuItem parent, JMenuItem toDeselect) {
            this.parent = parent;
            this.toDeselect = toDeselect;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.parent.isSelected()) {
                this.toDeselect.setSelected(false);
            }
        }
    }
}

