/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.oauth;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.HashMap;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.GoogleUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.JWTParser;
import software.amazon.awssdk.services.sts.model.Credentials;

public class OAuthProvider {
    private static Logger log = LogManager.getLogger(OAuthProvider.class);
    private String authProvider = "";
    private String appIdURI = null;
    public static String findString = null;
    public static String replaceString = null;
    private static final String REFRESH_TOKEN_KEY = "oauth_refresh_token";
    private String state;
    private String portNumber = PreferencesManager.getPreferences().getPortNumber();
    private String redirectURI = "http%3A%2F%2Flocalhost%3A" + this.portNumber + "%2FoauthCallback";
    private String clientId;
    private String clientSecret;
    private String authEndpoint;
    private String tokenEndpoint;
    private String accessToken;
    private String refreshToken;
    private long expirationTime;
    private String scope;
    private String[] hosts;
    private String currentUserName;
    private String currentUserID;
    private String currentUserEmail;
    private JsonObject response;
    private JsonObject config;

    public OAuthProvider(JsonObject obj) throws IOException {
        this.config = obj;
        this.state = UUID.randomUUID().toString();
        if (obj.has("installed") && !obj.has("client_id")) {
            obj = obj.get("installed").getAsJsonObject();
        }
        try {
            this.clientId = obj.get("client_id").getAsString();
            this.authEndpoint = obj.has("auth_uri") ? obj.get("auth_uri").getAsString() : obj.get("authorization_endpoint").getAsString();
            this.tokenEndpoint = obj.has("token_uri") ? obj.get("token_uri").getAsString() : obj.get("token_endpoint").getAsString();
        }
        catch (Exception e) {
            log.error(e);
            throw new IOException("oauthConfig is missing crucial attributes such as: client_id, authorization_endpoint/auth_uri or token_endpoint/token_uri");
        }
        this.clientSecret = obj.has("client_secret") ? obj.get("client_secret").getAsString() : null;
        this.setAuthProvider(obj.has("auth_provider") ? obj.get("auth_provider").getAsString() : this.authProvider);
        this.appIdURI = obj.has("app_id_uri") ? obj.get("app_id_uri").getAsString() : (obj.has("resource") ? obj.get("resource").getAsString() : null);
        findString = obj.has("find_string") ? obj.get("find_string").getAsString() : null;
        String string = replaceString = obj.has("replace_string") ? obj.get("replace_string").getAsString() : null;
        if (obj.has("scope")) {
            this.scope = obj.get("scope").getAsString();
        }
        if (obj.has("hosts")) {
            JsonElement hostsElement = obj.get("hosts");
            if (hostsElement.isJsonArray()) {
                JsonArray hostsArrJson = hostsElement.getAsJsonArray();
                this.hosts = new String[hostsArrJson.size()];
                for (int i = 0; i < hostsArrJson.size(); ++i) {
                    this.hosts[i] = hostsArrJson.get(i).getAsString();
                }
            } else {
                this.hosts = new String[1];
                this.hosts[0] = hostsElement.getAsString();
            }
        }
        if (this.isGoogle()) {
            if (this.scope == null) {
                String gsScope = "https://www.googleapis.com/auth/devstorage.read_only";
                String emailScope = "https://www.googleapis.com/auth/userinfo.email";
                this.scope = gsScope + "%20" + emailScope;
            }
            if (this.authProvider == null) {
                this.authProvider = "Google";
            }
        }
    }

    public String getState() {
        return this.state;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    public void setHosts(String[] hosts) {
        this.hosts = hosts;
    }

    public void openAuthorizationPage() throws IOException, URISyntaxException {
        if (!CommandListener.isListening()) {
            CommandListener.start();
        }
        if (!CommandListener.isListening()) {
            String ac = MessageUtils.showInputDialog("The IGV port listener is required for OAuth authentication.  If you have an access token enter it here.");
            if (ac != null) {
                this.setAccessToken(ac);
            }
        } else {
            Desktop desktop;
            String url = this.authEndpoint + "?state=" + this.state + "&redirect_uri=" + this.redirectURI + "&client_id=" + this.clientId + "&response_type=code";
            if (this.scope != null) {
                url = url + "&scope=" + this.scope;
            }
            if (this.appIdURI != null) {
                url = url + "&resource=" + this.appIdURI;
            }
            if ((desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(url));
            } else {
                MessageUtils.showMessage("Copy this authorization URL into your web browser: " + url);
            }
        }
    }

    public void setAuthorizationCode(String authorizationCode) throws IOException {
        URL url = HttpUtils.createURL(this.tokenEndpoint);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", authorizationCode);
        params.put("client_id", this.clientId);
        if (this.clientSecret != null) {
            params.put("client_secret", this.clientSecret);
        }
        new URLDecoder();
        params.put("redirect_uri", URLDecoder.decode(this.redirectURI, "utf-8"));
        params.put("grant_type", "authorization_code");
        if (this.appIdURI != null) {
            params.put("resource", this.appIdURI);
        }
        try {
            String res = HttpUtils.getInstance().doPost(url, params);
            JsonParser parser = new JsonParser();
            this.setResponse(parser.parse(res).getAsJsonObject());
            this.accessToken = this.response.get("access_token").getAsString();
            this.refreshToken = this.response.get("refresh_token").getAsString();
            this.expirationTime = System.currentTimeMillis() + (long)(this.response.get("expires_in").getAsInt() * 1000);
            if (this.response.has("id_token")) {
                JsonObject payload = JWTParser.getPayload(this.response.get("id_token").getAsString());
                this.fetchUserProfile(payload);
            }
            if (this.authProvider != null && "Amazon".equals(this.authProvider)) {
                Credentials aws_credentials = AmazonUtils.GetCognitoAWSCredentials();
                AmazonUtils.updateS3Client(aws_credentials);
            }
            if (this.isLoggedIn()) {
                IGVEventBus.getInstance().post(new AuthStateEvent(true, this.authProvider, this.getCurrentUserName()));
            }
        }
        catch (Exception e) {
            log.error(e);
            e.printStackTrace();
        }
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private void refreshAccessToken() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh_token", this.refreshToken);
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("grant_type", "refresh_token");
        if (this.appIdURI != null) {
            params.put("resource", this.appIdURI);
        }
        URL url = HttpUtils.createURL(this.tokenEndpoint);
        String response = HttpUtils.getInstance().doPost(url, params);
        JsonParser parser = new JsonParser();
        this.setResponse(parser.parse(response).getAsJsonObject());
        JsonObject obj = this.getResponse();
        JsonPrimitive atprim = obj.getAsJsonPrimitive("access_token");
        if (atprim != null) {
            this.accessToken = obj.getAsJsonPrimitive("access_token").getAsString();
            this.expirationTime = System.currentTimeMillis() + (long)(obj.getAsJsonPrimitive("expires_in").getAsInt() * 1000);
        } else {
            this.reauthorize();
        }
    }

    private void reauthorize() throws IOException {
        this.logout();
        try {
            this.openAuthorizationPage();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public JsonObject fetchUserProfile(JsonObject jwt_payload) {
        try {
            String string = this.currentUserName = jwt_payload.has("name") ? jwt_payload.get("name").getAsString() : null;
            if (this.currentUserName == null && jwt_payload.has("cognito:username")) {
                this.currentUserName = jwt_payload.get("cognito:username").getAsString();
            }
            this.currentUserEmail = jwt_payload.has("email") ? jwt_payload.get("email").getAsString() : null;
            this.currentUserID = jwt_payload.has("id") ? jwt_payload.get("id").getAsString() : null;
            return jwt_payload;
        }
        catch (Throwable exception) {
            log.error(exception);
            return null;
        }
    }

    public String getAccessToken() {
        if (this.accessToken == null || System.currentTimeMillis() > this.expirationTime - (long)Globals.TOKEN_EXPIRE_GRACE_TIME) {
            log.debug("Refreshing access token!");
            if (this.refreshToken != null) {
                try {
                    this.refreshAccessToken();
                }
                catch (IOException e) {
                    log.error("Error fetching access token", e);
                }
            }
        }
        return this.accessToken;
    }

    public Duration getExpirationTime() {
        Duration expiration = Duration.ofMillis(this.expirationTime - System.currentTimeMillis());
        log.debug("Current expiration time of credentials (and presigned urls is): " + expiration.toSeconds() + " seconds and expirationTime in class is: " + this.expirationTime);
        return expiration;
    }

    public boolean isLoggedIn() {
        return this.accessToken != null;
    }

    public String getCurrentUserName() {
        return this.currentUserName != null ? this.currentUserName : (this.currentUserEmail != null ? this.currentUserEmail : this.currentUserID);
    }

    public void logout() {
        this.accessToken = null;
        this.refreshToken = null;
        this.expirationTime = -1L;
        this.currentUserName = null;
        this.removeRefreshToken();
    }

    private void removeRefreshToken() {
        try {
            Preferences.userRoot().remove(REFRESH_TOKEN_KEY);
        }
        catch (Exception e) {
            log.error("Error removing oauth refresh token", e);
        }
    }

    public synchronized void checkLogin() {
        if (!this.isLoggedIn()) {
            try {
                this.openAuthorizationPage();
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                log.error("Error fetching oAuth tokens", ex);
            }
        }
        int i = 0;
        while (!this.isLoggedIn() && i < 600) {
            ++i;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean appliesToUrl(URL url) {
        if (this.hosts != null && this.hosts.length > 0) {
            for (String host : this.hosts) {
                if (url.getHost() == null || !url.getHost().equals(host)) continue;
                return true;
            }
        }
        if (this.isGoogle()) {
            return GoogleUtils.isGoogleURL(url.toExternalForm());
        }
        return false;
    }

    public boolean isGoogle() {
        return this.authEndpoint.contains("accounts.google.com");
    }

    public JsonObject getResponse() {
        return this.response;
    }

    public void setResponse(JsonObject res) {
        this.response = res;
    }

    public String getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(String authProvider) {
        this.authProvider = authProvider;
    }

    public class AuthStateEvent {
        boolean authenticated;
        String authProvider;
        String userName;
        String email;

        public AuthStateEvent(boolean authenticated, String authProvider, String userName) {
            this.authenticated = authenticated;
            this.authProvider = authProvider;
            this.userName = userName;
        }

        public boolean isAuthenticated() {
            return this.authenticated;
        }

        public String getAuthProvider() {
            return this.authProvider;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getEmail() {
            return OAuthProvider.this.currentUserEmail;
        }
    }
}

