/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class LoadFilesMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(LoadFilesMenuAction.class);
    IGV igv;

    public LoadFilesMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadFiles(this.chooseTrackFiles());
    }

    private File[] chooseTrackFiles() {
        File lastFile;
        File lastDirectoryFile = PreferencesManager.getPreferences().getLastTrackDirectory();
        IGVPreferences prefs = PreferencesManager.getPreferences();
        File[] trackFiles = FileDialogUtils.chooseMultiple("Select Files", lastDirectoryFile, null);
        if (trackFiles != null && trackFiles.length > 0 && (lastFile = trackFiles[0]) != null) {
            PreferencesManager.getPreferences().setLastTrackDirectory(lastFile);
        }
        this.igv.resetStatusMessage();
        return trackFiles;
    }

    private void loadFiles(File[] files) {
        if (files != null && files.length > 0) {
            ArrayList<File> validFileList = new ArrayList<File>();
            StringBuffer buffer = new StringBuffer();
            buffer.append("File(s) not found: ");
            boolean allFilesExist = true;
            for (File file : files) {
                if (!file.exists()) {
                    allFilesExist = false;
                    buffer.append("\n\t");
                    buffer.append(file.getAbsolutePath());
                    continue;
                }
                String path = file.getAbsolutePath();
                if (path.endsWith(".xml")) {
                    String msg = "File " + path + " appears to be an IGV Session file - please use the Open Session menu item to load it.";
                    log.error(msg);
                    MessageUtils.showMessage(msg);
                    continue;
                }
                validFileList.add(file);
            }
            files = validFileList.toArray(new File[validFileList.size()]);
            if (!allFilesExist) {
                String msg = buffer.toString();
                log.error(msg);
                MessageUtils.showMessage(msg);
            }
            if (files.length > 0) {
                List<ResourceLocator> locators = ResourceLocator.getLocators(Arrays.asList(files));
                this.igv.loadTracks(locators);
            }
        }
    }
}

