/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.oauth;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.broad.igv.DirectoryManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.oauth.OAuthProvider;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.GoogleUtils;
import org.broad.igv.util.HttpUtils;

public class OAuthUtils {
    private static Logger log = LogManager.getLogger(OAuthUtils.class);
    private static final String PROPERTIES_URL = "https://s3.amazonaws.com/igv.org.app/desktop_google";
    private static OAuthUtils theInstance;
    static OAuthProvider awsProvider;
    static OAuthProvider defaultProvider;
    static Map<String, OAuthProvider> providerCache;

    public static synchronized OAuthUtils getInstance() {
        if (theInstance == null) {
            theInstance = new OAuthUtils();
        }
        return theInstance;
    }

    private OAuthUtils() {
        try {
            providerCache = new LinkedHashMap<String, OAuthProvider>();
            this.fetchOauthProperties();
        }
        catch (Exception e) {
            log.error("Error fetching oAuth properties", e);
        }
    }

    public OAuthProvider getAWSProvider() {
        if (awsProvider == null) {
            throw new RuntimeException("AWS Oauth is not configured");
        }
        return awsProvider;
    }

    public OAuthProvider getDefaultProvider() {
        return defaultProvider;
    }

    private void fetchOauthProperties() throws IOException {
        String propString;
        String oauthConfig;
        String provisioningURL = PreferencesManager.getPreferences().getProvisioningURL();
        log.debug("The provisioning URL from prefs.properties is: " + provisioningURL);
        if (provisioningURL != null && provisioningURL.length() > 0) {
            String json = this.loadAsString(provisioningURL);
            this.parseProviderJson(json);
        }
        if (!new File(oauthConfig = DirectoryManager.getIgvDirectory() + "/oauth-config.json").exists()) {
            oauthConfig = DirectoryManager.getIgvDirectory() + "/oauth-config-custom.json";
        }
        if (new File(oauthConfig).exists()) {
            try {
                log.debug("Loading Oauth properties from: " + oauthConfig);
                String json = this.loadAsString(oauthConfig);
                this.parseProviderJson(json);
            }
            catch (IOException e) {
                log.error(e);
            }
        }
        if (defaultProvider == null && ((defaultProvider = this.parseProviderJson(propString = this.loadAsString(PROPERTIES_URL))).getAuthProvider() == null || defaultProvider.getAuthProvider().isEmpty())) {
            defaultProvider.setAuthProvider("Google");
        }
    }

    public void updateOauthProvider(String provisioningURL) throws IOException {
        if (provisioningURL != null && provisioningURL.trim().length() > 0) {
            String json = this.loadAsString(provisioningURL);
            this.parseProviderJson(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadAsString(String urlOrPath) throws IOException {
        try (InputStream is = null;){
            is = OAuthUtils.openInputStream(urlOrPath);
            byte[] bytes = is.readAllBytes();
            if (bytes[0] == 31 && bytes[1] == -117) {
                bytes = new GZIPInputStream(new ByteArrayInputStream(bytes)).readAllBytes();
            }
            String string = new String(bytes, "UTF-8");
            return string;
        }
    }

    private OAuthProvider parseProviderJson(String json) throws IOException {
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(json).getAsJsonObject();
        OAuthProvider p = new OAuthProvider(obj);
        providerCache.put(p.getState(), p);
        if (obj.has("auth_provider") && obj.get("auth_provider").getAsString().equals("Amazon")) {
            awsProvider = p;
            AmazonUtils.setCognitoConfig(obj);
        }
        if (p.isGoogle()) {
            defaultProvider = p;
        }
        return p;
    }

    public OAuthProvider getProviderForState(String state) throws IOException {
        if (providerCache.containsKey(state)) {
            return providerCache.get(state);
        }
        log.warn("No oAuth provider found for callback");
        return defaultProvider;
    }

    public OAuthProvider getProviderForURL(URL url) {
        for (OAuthProvider provider : providerCache.values()) {
            if (!provider.appliesToUrl(url)) continue;
            return provider;
        }
        if (GoogleUtils.isGoogleURL(url.toExternalForm()) && defaultProvider.isGoogle()) {
            return defaultProvider;
        }
        return null;
    }

    public static InputStream openInputStream(String urlOrPath) throws IOException {
        InputStream inputStream = null;
        if (urlOrPath.startsWith("http://") || urlOrPath.startsWith("https://")) {
            URL url = new URL(urlOrPath);
            HttpURLConnection conn = HttpUtils.getInstance().openProxiedConnection(url);
            inputStream = conn.getInputStream();
        } else {
            if (urlOrPath.startsWith("file://")) {
                urlOrPath = urlOrPath.substring(7);
            }
            File file = new File(urlOrPath);
            inputStream = new FileInputStream(file);
        }
        return inputStream;
    }
}

