/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.broad.igv.Globals;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.MessageUtils;

public class LongRunningTask
implements Callable {
    private static Logger log = LogManager.getLogger(LongRunningTask.class);
    private static final ExecutorService threadExecutor = Executors.newFixedThreadPool(5);
    Runnable runnable;

    public static Executor getThreadExecutor() {
        return threadExecutor;
    }

    public static Future submit(Runnable runnable) {
        if (Globals.isBatch()) {
            runnable.run();
            return null;
        }
        return threadExecutor.submit(new LongRunningTask(runnable));
    }

    private LongRunningTask(Runnable runnable) {
        this.runnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            this.runnable.run();
        }
        catch (Exception e) {
            MessageUtils.showMessage("<html>Unexpected error: " + e.getMessage() + ".<br>See igv.log for more details");
            log.error("Exception running task", e);
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            IGV iGV = IGV.getInstance();
            synchronized (iGV) {
                IGV.getInstance().notifyAll();
            }
        }
        return null;
    }
}

