/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.DragAndDropTransferHandler;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.HeaderDropTargetListener;
import org.broad.igv.ui.panel.HeaderPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;

public class HeaderPanelContainer
extends JPanel
implements Paintable {
    private JPanel contentPanel;

    public HeaderPanelContainer() {
        this.setLayout(new BorderLayout());
        this.setTransferHandler(new DragAndDropTransferHandler());
        this.setDropTarget(new DropTarget(this, new HeaderDropTargetListener(this)));
        this.createHeaderPanels();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.contentPanel != null) {
            for (Component c : this.contentPanel.getComponents()) {
                if (!(c instanceof HeaderPanel)) continue;
                c.setBackground(color);
            }
        }
    }

    public void createHeaderPanels() {
        GeneList gl;
        String name;
        this.removeAll();
        List<ReferenceFrame> frames = FrameManager.getFrames();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.contentPanel.setBackground(new Color(250, 250, 250));
        int hgap = 6;
        if (frames.size() > 10) {
            hgap = 1 + 20 / frames.size();
        }
        boolean first = true;
        for (ReferenceFrame f : frames) {
            if (!f.isVisible()) continue;
            if (!first) {
                this.contentPanel.add(Box.createRigidArea(new Dimension(hgap, 0)));
            }
            HeaderPanel dp = new HeaderPanel(f);
            dp.setBackground(this.getBackground());
            this.contentPanel.add(dp);
            first = false;
        }
        this.add((Component)this.contentPanel, "Center");
        if (FrameManager.isGeneListMode() && (name = (gl = IGV.getInstance().getSession().getCurrentGeneList()).getDisplayName()) != null && name.length() > 0) {
            JLabel label = new JLabel(name, 0);
            Border border = BorderFactory.createLineBorder(Color.lightGray);
            label.setBorder(border);
            this.add((Component)label, "North");
        }
        this.invalidate();
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect, boolean batch) {
        Component[] components;
        for (Component c : components = this.contentPanel.getComponents()) {
            if (!(c instanceof HeaderPanel)) continue;
            Graphics2D g2d = (Graphics2D)g.create();
            Rectangle panelRect = new Rectangle(0, rect.y, c.getWidth(), rect.height);
            g2d.translate(c.getX(), 0);
            g2d.setClip(panelRect);
            ((HeaderPanel)c).paintOffscreen(g2d, panelRect, batch);
        }
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        return this.getHeight();
    }
}

