/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.broad.igv.util.StringUtils;

public class GraphicUtils {
    public static void drawCenteredChar(Graphics g, char[] chars, int x, int y, int w, int h) {
        FontMetrics fm = g.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h / 2 - descent / 2 + ascent / 2;
        g.drawChars(chars, 0, 1, msgX, msgY);
    }

    public static void drawCenteredText(String text, Rectangle rect, Graphics g) {
        GraphicUtils.drawCenteredText(text, rect.x, rect.y, rect.width, rect.height, g);
    }

    public static void drawCenteredText(String text, int x, int y, int w, int h, Graphics g) {
        GraphicUtils.drawCenteredText(text, x, y, w, h, g, null);
    }

    public static void drawCenteredText(String text, int x, int y, int w, int h, Graphics g, Color backgroundColor) {
        FontMetrics fontMetrics = g.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(text, g);
        int xOffset = (int)(((double)w - textBounds.getWidth()) / 2.0);
        int yOffset = (int)(((double)h - textBounds.getHeight()) / 2.0);
        int xs = x + xOffset;
        int ys = y + h - yOffset - (int)(textBounds.getHeight() / 4.0);
        if (backgroundColor != null) {
            Graphics gb = g.create();
            gb.setColor(backgroundColor);
            int th = (int)textBounds.getHeight();
            gb.fillRect(xs, ys - 3 * th / 4, (int)textBounds.getWidth(), th);
        }
        g.drawString(text, xs, ys);
    }

    public static void drawVerticallyCenteredText(String text, int margin, Rectangle rect, Graphics g2D, boolean rightJustify) {
        GraphicUtils.drawVerticallyCenteredText(text, margin, rect, g2D, rightJustify, false);
    }

    public static void drawVerticallyCenteredText(String text, int margin, Rectangle rect, Graphics g2D, boolean rightJustify, boolean clear) {
        FontMetrics fontMetrics = g2D.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(text, g2D);
        int yOffset = (int)((rect.getHeight() - textBounds.getHeight()) / 2.0);
        int yPos = rect.y + rect.height - yOffset - (int)(textBounds.getHeight() / 4.0);
        if (clear) {
            int h = 2 * (int)textBounds.getHeight();
            int y = Math.max(rect.y, yPos - h);
            int h2 = Math.min(rect.height, 2 * h);
            Color c = g2D.getColor();
            g2D.setColor(Color.WHITE);
            g2D.fillRect(rect.x, y, rect.width, h2);
            g2D.setColor(c);
        }
        if (rightJustify) {
            GraphicUtils.drawRightJustifiedText(text, rect.x + rect.width - margin, yPos, g2D);
        } else {
            g2D.drawString(text, margin, yPos);
        }
    }

    public static void drawRightJustifiedText(String text, int right, int y, Graphics g) {
        FontMetrics fontMetrics = g.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(text, g);
        int x = right - (int)textBounds.getWidth();
        g.drawString(text, x, y);
    }

    public static void drawDottedDashLine(Graphics2D g, int x1, int y1, int x2, int y2) {
        BasicStroke thindashed = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{8.0f, 3.0f, 2.0f, 3.0f}, 0.0f);
        GraphicUtils.drawDashedLine(g, thindashed, x1, y1, x2, y2);
    }

    public static void drawDashedLine(Graphics2D g, int x1, int y1, int x2, int y2) {
        BasicStroke thindashed = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{3.0f, 3.0f}, 0.0f);
        GraphicUtils.drawDashedLine(g, thindashed, x1, y1, x2, y2);
    }

    public static void drawWrappedText(String string, Rectangle rect, Graphics2D g2D, boolean clear) {
        FontMetrics fontMetrics = g2D.getFontMetrics();
        Rectangle2D stringBounds = fontMetrics.getStringBounds(string, g2D);
        int margin = 5;
        int textHeight = (int)stringBounds.getHeight() + 5;
        double textWidth = stringBounds.getWidth() + 10.0;
        if (textWidth < (double)rect.width) {
            GraphicUtils.drawVerticallyCenteredText(string, 5, rect, g2D, false, clear);
        } else {
            int charWidth = (int)(stringBounds.getWidth() / (double)string.length());
            int charsPerLine = rect.width / charWidth;
            int nStrings = string.length() / charsPerLine + 1;
            if (nStrings * textHeight > rect.height) {
                String shortString;
                double w;
                int nChars = (rect.width - 10) / charWidth + 1;
                int nTries = 0;
                while ((w = fontMetrics.getStringBounds(shortString = StringUtils.checkLength(string, nChars), g2D).getWidth() + 10.0) > (double)rect.width && ++nTries <= 5 && --nChars > 1) {
                }
                GraphicUtils.drawVerticallyCenteredText(shortString, 5, rect, g2D, false, clear);
            } else {
                int breakPoint = 0;
                Rectangle tmp = new Rectangle(rect);
                tmp.y -= (nStrings - 1) * textHeight / 2;
                while (breakPoint < string.length()) {
                    int end = Math.min(string.length(), breakPoint + charsPerLine);
                    GraphicUtils.drawVerticallyCenteredText(string.substring(breakPoint, end), 5, tmp, g2D, false);
                    breakPoint += charsPerLine;
                    tmp.y += textHeight;
                }
            }
        }
    }

    public static void drawDashedLine(Graphics2D g, Stroke stroke, int x1, int y1, int x2, int y2) {
        Stroke currentStroke = g.getStroke();
        g.setStroke(stroke);
        g.drawLine(x1, y1, x2, y2);
        g.setStroke(currentStroke);
    }

    public static void drawHorizontalArrow(Graphics g, Rectangle r, boolean direction) {
        int[] y;
        int[] x;
        int dy = r.height / 3;
        int y0 = r.y;
        int y1 = y0 + dy;
        int y3 = y0 + r.height;
        int y2 = y3 - dy;
        int yc = (y1 + y2) / 2;
        int dx = yc - y0;
        if (direction) {
            int x1 = r.x;
            int x3 = x1 + r.width;
            int x2 = x3 - dx;
            x = new int[]{x1, x2, x2, x3, x2, x2, x1};
            y = new int[]{y1, y1, y0, yc, y3, y2, y2};
        } else {
            int x1 = r.x;
            int x3 = x1 + r.width;
            int x2 = x1 + dx;
            x = new int[]{x1, x2, x2, x3, x3, x2, x2};
            y = new int[]{yc, y0, y1, y1, y2, y2, y3};
        }
        g.fillPolygon(x, y, x.length);
    }

    public static void drawCenteredText(char[] chars, int x, int y, int w, int h, Graphics2D g) {
        FontMetrics fm = g.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h / 2 - descent / 2 + ascent / 2;
        g.drawChars(chars, 0, 1, msgX, msgY);
    }
}

