/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.swing.CheckBoxList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGVDialog;
import org.broad.igv.ui.panel.RadioButtonSelectionList;
import org.broad.igv.ui.panel.TrackWrapper;

public class TrackSelectionDialog<T extends Track>
extends IGVDialog {
    private boolean isCancelled = false;
    private final SelectionMode mode;
    private JPanel dialogPane;
    private JPanel vSpacer1;
    private JPanel contentPanel;
    private JScrollPane trackPanel;
    private CheckBoxList trackList;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    private void initTrackList() {
        switch (this.mode) {
            case MULTIPLE: {
                break;
            }
            case SINGLE: {
                this.trackList = new RadioButtonSelectionList();
            }
        }
    }

    public TrackSelectionDialog(Frame owner, SelectionMode mode, Collection<T> tracks) {
        super(owner);
        this.mode = mode;
        this.initComponents();
        this.setModal(true);
        List<TrackWrapper> wrappers = TrackWrapper.wrapTracks(tracks);
        this.trackList.setListData(wrappers.toArray());
        this.trackList.selectAll();
    }

    public Collection<T> getSelectedTracks() {
        if (this.isCancelled) {
            return null;
        }
        Object[] selectedObjects = this.trackList.getCheckBoxListSelectedValues();
        if (selectedObjects == null || selectedObjects.length == 0) {
            return null;
        }
        ArrayList selectedTracks = new ArrayList(selectedObjects.length);
        for (Object object : selectedObjects) {
            selectedTracks.add(((TrackWrapper)object).getTrack());
        }
        return selectedTracks;
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.isCancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    public boolean getIsCancelled() {
        return this.isCancelled;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.vSpacer1 = new JPanel(null);
        this.contentPanel = new JPanel();
        this.trackPanel = new JScrollPane();
        this.trackList = new CheckBoxList();
        this.initTrackList();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setMinimumSize(new Dimension(220, 220));
        this.dialogPane.setLayout(new BorderLayout());
        this.vSpacer1.setPreferredSize(new Dimension(10, 30));
        this.dialogPane.add((Component)this.vSpacer1, "North");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.trackList.setClickInCheckBoxOnly(false);
        this.trackList.setSelectionMode(0);
        this.trackPanel.setViewportView((Component)this.trackList);
        this.contentPanel.add(this.trackPanel);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSelectionDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSelectionDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "South");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static enum SelectionMode {
        SINGLE,
        MULTIPLE;

    }
}

