/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGVDialog;
import org.broad.igv.ui.color.ColorChooserPanel;
import org.jdesktop.layout.GroupLayout;

public class HeatmapLegendEditor
extends IGVDialog {
    private boolean canceled = true;
    private ContinuousColorScale colorScheme;
    private TrackType type;
    private JPanel jPanel1;
    private JLabel midColorLabel;
    private JLabel jLabel3;
    private JLabel minColorLabel;
    private ColorChooserPanel minColor;
    private ColorChooserPanel midColor;
    private ColorChooserPanel maxColor;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel negRangePanel;
    private JLabel negRangeLabel;
    private JTextField negRangeStart;
    private JLabel negRangeToLabel;
    private JTextField negRangeEnd;
    private JCheckBox doubleGradientCheckbox;
    private JPanel posRangePanel;
    private JLabel posRangeLabel;
    private JTextField posRangeStart;
    private JLabel posRangeToLabel;
    private JTextField posRangeEnd;

    public HeatmapLegendEditor(Frame parent, boolean modal, TrackType type, ColorScale colorScheme) {
        super(parent, modal);
        this.colorScheme = (ContinuousColorScale)colorScheme;
        this.type = type;
        this.initComponents();
        this.initValues();
        this.setLocationRelativeTo(parent);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initValues() {
        this.doubleGradientCheckbox.setSelected(this.colorScheme.isUseDoubleGradient());
        this.negRangeStart.setText(String.valueOf(this.colorScheme.getNegStart()));
        this.negRangeEnd.setText(String.valueOf(this.getColorScheme().getMinimum()));
        this.posRangeStart.setText(String.valueOf(this.colorScheme.getPosStart()));
        this.posRangeEnd.setText(String.valueOf(this.colorScheme.getMaximum()));
        this.minColor.setSelectedColor(this.colorScheme.getMinColor());
        this.maxColor.setSelectedColor(this.colorScheme.getMaxColor());
        Color mc = this.colorScheme.getMidColor();
        this.midColor.setSelectedColor(mc == null ? Color.white : mc);
        this.initDoubleGradientState();
    }

    private void initDoubleGradientState() {
        boolean doubleGradient = this.doubleGradientCheckbox.isSelected();
        this.negRangePanel.setVisible(doubleGradient);
        this.midColorLabel.setVisible(doubleGradient);
        this.midColor.setVisible(doubleGradient);
        this.posRangeLabel.setText(doubleGradient ? "Positive Range " : "Range");
    }

    private boolean updateValues() {
        try {
            double negStart = 0.0;
            double negEnd = 0.0;
            double posStart = Double.parseDouble(this.posRangeStart.getText());
            double posEnd = Double.parseDouble(this.posRangeEnd.getText());
            negStart = Double.parseDouble(this.negRangeStart.getText());
            negEnd = Double.parseDouble(this.negRangeEnd.getText());
            this.colorScheme = new ContinuousColorScale(Math.max(negStart, negEnd), Math.min(negStart, negEnd), Math.min(posStart, posEnd), Math.max(posStart, posEnd), this.minColor.getSelectedColor(), this.midColor.getSelectedColor(), this.maxColor.getSelectedColor());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Limit fields must be numeric.", "Error", 0);
            return false;
        }
    }

    public ContinuousColorScale getColorScheme() {
        return this.colorScheme;
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.canceled = false;
        if (this.updateValues()) {
            this.setVisible(false);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    private void negRangeEndActionPerformed(ActionEvent e) {
    }

    private void doubleGradientCheckboxActionPerformed(ActionEvent e) {
        this.initDoubleGradientState();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.midColorLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.minColorLabel = new JLabel();
        this.minColor = new ColorChooserPanel();
        this.midColor = new ColorChooserPanel();
        this.maxColor = new ColorChooserPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.negRangePanel = new JPanel();
        this.negRangeLabel = new JLabel();
        this.negRangeStart = new JTextField();
        this.negRangeToLabel = new JLabel();
        this.negRangeEnd = new JTextField();
        this.doubleGradientCheckbox = new JCheckBox();
        this.posRangePanel = new JPanel();
        this.posRangeLabel = new JLabel();
        this.posRangeStart = new JTextField();
        this.posRangeToLabel = new JLabel();
        this.posRangeEnd = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        this.midColorLabel.setText("Midpoint Color");
        this.jLabel3.setText("Maximum Color");
        this.minColorLabel.setText("Minimum Color");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup().add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup().add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.maxColor, -2, 50, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.minColorLabel).addPreferredGap(0, 9, Short.MAX_VALUE).add((Component)this.minColor, -2, 75, -2)).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.midColorLabel).addPreferredGap(0, 12, Short.MAX_VALUE).add((Component)this.midColor, -2, 50, -2))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.maxColor, this.midColor, this.minColor}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup().add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup().add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.minColorLabel).addPreferredGap(1).add((Component)this.midColorLabel)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.minColor, -2, 25, -2).add(14, 14, 14).add((Component)this.midColor, -2, 25, -2))).add(12, 12, 12).add((GroupLayout.Group)jPanel1Layout.createParallelGroup().add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel3).add(20, 20, 20)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.maxColor, -2, 25, -2).addContainerGap()))));
        jPanel1Layout.linkSize(new Component[]{this.jLabel3, this.maxColor}, 2);
        jPanel1Layout.linkSize(new Component[]{this.midColor, this.midColorLabel}, 2);
        jPanel1Layout.linkSize(new Component[]{this.minColor, this.minColorLabel}, 2);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapLegendEditor.this.okButtonActionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapLegendEditor.this.cancelButtonActionPerformed(e);
            }
        });
        this.negRangeLabel.setText("Negative Range: ");
        this.negRangeStart.setText("-0.1");
        this.negRangeToLabel.setText("To:");
        this.negRangeEnd.setText("-1.5");
        this.negRangeEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapLegendEditor.this.negRangeEndActionPerformed(e);
            }
        });
        GroupLayout negRangePanelLayout = new GroupLayout((Container)this.negRangePanel);
        this.negRangePanel.setLayout((LayoutManager)negRangePanelLayout);
        negRangePanelLayout.setHorizontalGroup((GroupLayout.Group)negRangePanelLayout.createParallelGroup().add((GroupLayout.Group)negRangePanelLayout.createSequentialGroup().add((Component)this.negRangeLabel, -2, 115, -2).addPreferredGap(0).add((Component)this.negRangeStart, -2, 59, -2).addPreferredGap(1).add((Component)this.negRangeToLabel, -2, 30, -2).addPreferredGap(0).add((Component)this.negRangeEnd, -2, 59, -2)));
        negRangePanelLayout.setVerticalGroup((GroupLayout.Group)negRangePanelLayout.createParallelGroup().add((GroupLayout.Group)negRangePanelLayout.createSequentialGroup().add((GroupLayout.Group)negRangePanelLayout.createParallelGroup().add((Component)this.negRangeLabel, -2, 22, -2).add((GroupLayout.Group)negRangePanelLayout.createParallelGroup(3).add((Component)this.negRangeStart, -2, -1, -2).add((Component)this.negRangeToLabel, -2, 22, -2).add((Component)this.negRangeEnd, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.doubleGradientCheckbox.setText("Use Double Gradient");
        this.doubleGradientCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapLegendEditor.this.doubleGradientCheckboxActionPerformed(e);
            }
        });
        this.posRangeLabel.setText("Positive Range: ");
        this.posRangeStart.setText("-0.1");
        this.posRangeToLabel.setText("To:");
        this.posRangeEnd.setText("-1.5");
        this.posRangeEnd.setMaximumSize(new Dimension(36, 22));
        this.posRangeEnd.setMinimumSize(new Dimension(36, 22));
        GroupLayout posRangePanelLayout = new GroupLayout((Container)this.posRangePanel);
        this.posRangePanel.setLayout((LayoutManager)posRangePanelLayout);
        posRangePanelLayout.setHorizontalGroup((GroupLayout.Group)posRangePanelLayout.createParallelGroup().add((GroupLayout.Group)posRangePanelLayout.createSequentialGroup().add((Component)this.posRangeLabel, -2, 115, -2).addPreferredGap(0).add((Component)this.posRangeStart, -2, 59, -2).addPreferredGap(1).add((Component)this.posRangeToLabel, -2, 30, -2).addPreferredGap(0).add((Component)this.posRangeEnd, -2, 59, -2)));
        posRangePanelLayout.setVerticalGroup((GroupLayout.Group)posRangePanelLayout.createParallelGroup().add((GroupLayout.Group)posRangePanelLayout.createSequentialGroup().add((GroupLayout.Group)posRangePanelLayout.createParallelGroup().add((Component)this.posRangeLabel, -2, 22, -2).add((GroupLayout.Group)posRangePanelLayout.createParallelGroup(3).add((Component)this.posRangeStart, -2, -1, -2).add((Component)this.posRangeToLabel, -2, 22, -2).add((Component)this.posRangeEnd, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout((LayoutManager)contentPaneLayout);
        contentPaneLayout.setHorizontalGroup((GroupLayout.Group)contentPaneLayout.createParallelGroup().add((GroupLayout.Group)contentPaneLayout.createSequentialGroup().add(35, 35, 35).add((GroupLayout.Group)contentPaneLayout.createParallelGroup(1, false).add((Component)this.doubleGradientCheckbox, -2, 175, -2).add((Component)this.jPanel1, -2, 184, -2).add((Component)this.negRangePanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.posRangePanel, -1, -1, Short.MAX_VALUE)).addContainerGap(101, Short.MAX_VALUE)).add(2, (GroupLayout.Group)contentPaneLayout.createSequentialGroup().addContainerGap(124, Short.MAX_VALUE).add((Component)this.okButton).addPreferredGap(0).add((Component)this.cancelButton).add(132, 132, 132)));
        contentPaneLayout.setVerticalGroup((GroupLayout.Group)contentPaneLayout.createParallelGroup().add((GroupLayout.Group)contentPaneLayout.createSequentialGroup().add(52, 52, 52).add((Component)this.doubleGradientCheckbox).add(18, 18, 18).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.negRangePanel, -2, 30, -2).addPreferredGap(1).add((Component)this.posRangePanel, -2, 30, -2).add(18, 18, 18).add((GroupLayout.Group)contentPaneLayout.createParallelGroup(3).add((Component)this.okButton).add((Component)this.cancelButton)).add(34, 34, 34)));
        this.setSize(425, 405);
        this.setLocationRelativeTo(this.getOwner());
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

