/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.broad.igv.Globals;

public class SupplementaryAlignment {
    public String chr;
    public int start;
    public char strand;
    public int mapQ;
    public int numMismatches;
    public int lenOnRef;

    public SupplementaryAlignment(String rec) {
        String[] tokens = Globals.commaPattern.split(rec);
        this.chr = tokens[0];
        this.start = Integer.parseInt(tokens[1]);
        this.strand = tokens[2].charAt(0);
        this.mapQ = Integer.parseInt(tokens[4]);
        this.numMismatches = Integer.parseInt(tokens[5]);
        this.lenOnRef = this.computeLengthOnReference(tokens[3]);
    }

    public String printString() {
        return this.chr + ":" + Globals.DECIMAL_FORMAT.format(this.start) + "-" + Globals.DECIMAL_FORMAT.format(this.start + this.lenOnRef) + " (" + this.strand + ") = " + Globals.DECIMAL_FORMAT.format(this.lenOnRef) + "bp  @MAPQ " + this.mapQ + " NM" + this.numMismatches;
    }

    int computeLengthOnReference(String cigarString) {
        int len = 0;
        StringBuffer buf = new StringBuffer();
        for (char c : cigarString.toCharArray()) {
            if (c > '/' && c < ':') {
                buf.append(c);
                continue;
            }
            switch (c) {
                case '=': 
                case 'D': 
                case 'M': 
                case 'N': 
                case 'X': {
                    len += Integer.parseInt(buf.toString());
                }
            }
            buf.setLength(0);
        }
        return len;
    }
}

