/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.InsertionMarker;

public class InsertionManager {
    private static InsertionManager theInstance = new InsertionManager();
    private Map<String, Map<Integer, InsertionMarker>> insertionMaps = Collections.synchronizedMap(new HashMap(100));
    private Map<String, List<Integer>> positionsMap = Collections.synchronizedMap(new HashMap(100));
    private Map<String, Integer> selectedInsertions = Collections.synchronizedMap(new HashMap(100));

    public static InsertionManager getInstance() {
        return theInstance;
    }

    private InsertionManager() {
    }

    public void clear() {
        this.insertionMaps.clear();
        this.positionsMap.clear();
        this.selectedInsertions.clear();
    }

    public List<InsertionMarker> getInsertions(String chrName, double start, double end) {
        Integer key;
        Map<Integer, InsertionMarker> insertionMap = this.insertionMaps.get(chrName);
        List<Integer> positions = this.positionsMap.get(chrName);
        if (insertionMap == null || positions == null) {
            return null;
        }
        ArrayList<InsertionMarker> insertionMarkers = new ArrayList<InsertionMarker>();
        for (int i = 0; i < positions.size() && !((double)(key = positions.get(i)).intValue() > end); ++i) {
            if (!((double)key.intValue() >= start)) continue;
            InsertionMarker insertionMarker = insertionMap.get(key);
            insertionMarkers.add(insertionMarker);
        }
        return insertionMarkers;
    }

    public void setSelected(String chrName, int position) {
        this.selectedInsertions.put(chrName, position);
    }

    public void clearSelected() {
        this.selectedInsertions.clear();
    }

    public InsertionMarker getSelectedInsertion(String chrName) {
        Integer selectedInsertion = this.selectedInsertions.get(chrName);
        Map<Integer, InsertionMarker> insertionMap = this.insertionMaps.get(chrName);
        return selectedInsertion == null || insertionMap == null ? null : insertionMap.get(selectedInsertion);
    }

    public synchronized void processAlignments(String chr, List<Alignment> alignments, AlignmentTrack.RenderOptions renderOptions) {
        List<Integer> positions;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        chr = genome == null ? chr : genome.getCanonicalChrName(chr);
        Map<Integer, InsertionMarker> insertionMap = this.insertionMaps.get(chr);
        if (insertionMap == null) {
            insertionMap = Collections.synchronizedMap(new HashMap());
            this.insertionMaps.put(chr, insertionMap);
        }
        if ((positions = this.positionsMap.get(chr)) == null) {
            positions = new ArrayList<Integer>();
            this.positionsMap.put(chr, positions);
        }
        int minLength = 0;
        if (renderOptions != null && renderOptions.isHideSmallIndels()) {
            minLength = renderOptions.getSmallIndelThreshold();
        }
        for (Alignment a : alignments) {
            AlignmentBlock[] blocks = a.getInsertions();
            if (blocks == null) continue;
            for (AlignmentBlock block : blocks) {
                if (block.getBases() == null || block.getBases().length < minLength) continue;
                Integer key = block.getStart();
                InsertionMarker insertionMarker = insertionMap.get(key);
                if (insertionMarker == null) {
                    insertionMarker = new InsertionMarker(block.getStart(), block.getLength());
                    insertionMap.put(key, insertionMarker);
                    positions.add(block.getStart());
                    continue;
                }
                insertionMarker.size = Math.max(insertionMarker.size, block.getLength());
            }
        }
        positions.addAll(insertionMap.keySet());
        positions.sort((o1, o2) -> o1 - o2);
    }
}

