/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.methyl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.methyl.BBMethylDataSource;
import org.broad.igv.methyl.CachingMethylSource;
import org.broad.igv.methyl.MethylDataSource;
import org.broad.igv.methyl.MethylScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class MethylTrack
extends AbstractTrack {
    public static final int FIVE_MB = 5000000;
    public static final int FIFTY_MB = 50000000;
    private MethylDataSource dataSource;
    private Range loadedRange;
    private Renderer renderer;
    private int resolutionThreshold;
    private boolean loading = false;

    public MethylTrack(ResourceLocator dataResourceLocator, BBFileReader reader, Genome genome) throws IOException {
        super(dataResourceLocator);
        this.setHeight(60);
        this.renderer = new PointsRenderer();
        if (reader.getAutoSql() != null && reader.getAutoSql().startsWith("table BisulfiteSeq")) {
            this.resolutionThreshold = 5000;
            this.dataSource = new CachingMethylSource(new BBMethylDataSource(reader, BBMethylDataSource.Type.USC, genome), this.resolutionThreshold);
        } else {
            boolean isWGBS = dataResourceLocator.getPath().contains("BiSeq_cpgMethylation");
            this.resolutionThreshold = (isWGBS ? 5000000 : 50000000) / 1000;
            this.dataSource = new CachingMethylSource(new BBMethylDataSource(reader, BBMethylDataSource.Type.ZILLER, genome), this.resolutionThreshold);
        }
        this.loadedRange = new Range("", -1, -1, Collections.emptyList());
        this.setDataRange(new DataRange(0.0f, 100.0f));
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        if (frame.getChrName().equals("All") || frame.getScale() > (double)this.resolutionThreshold) {
            return true;
        }
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        return this.loadedRange.contains(chr, start, end);
    }

    @Override
    public void load(ReferenceFrame frame) {
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        int width = (end - start) / 2;
        int expandedStart = Math.max(0, start - width);
        int expandedEnd = end + width;
        if (expandedEnd < 0) {
            expandedEnd = Integer.MAX_VALUE;
        }
        ArrayList<MethylScore> scores = new ArrayList<MethylScore>(1000);
        Iterator<MethylScore> iter = this.dataSource.query(chr, expandedStart, expandedEnd);
        while (iter.hasNext()) {
            scores.add(iter.next());
        }
        this.loadedRange = new Range(chr, expandedStart, expandedEnd, scores);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int end;
        int start;
        if (context.getChr().equals("All") || context.getScale() > (double)this.resolutionThreshold) {
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            Rectangle textRect = new Rectangle(rect);
            textRect.height = Math.min(rect.height, 20);
            textRect.height = Math.min(rect.height, 20);
            String message = context.getChr().equals("All") ? "Zoom in to see features." : "Zoom in to see features, or right-click to increase Feature Visibility Window.";
            GraphicUtils.drawCenteredText(message, textRect, g);
            return;
        }
        String chr = context.getChr();
        if (this.loadedRange.contains(chr, start = (int)context.getOrigin(), end = (int)context.getEndLocation())) {
            this.renderer.render(this.loadedRange.scores, context, rect, this);
        }
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    static class Range
    extends org.broad.igv.feature.Range {
        List<MethylScore> scores;

        Range(String chr, int start, int end, List<MethylScore> scores) {
            super(chr, start, end);
            this.scores = scores;
        }
    }
}

