/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.LittleEndianInputStream;

public class BigWigSectionHeader {
    private static Logger log = LogManager.getLogger(BigWigSectionHeader.class);
    public static final int SECTION_HEADER_SIZE = 24;
    public static final int FIXEDSTEP_ITEM_SIZE = 4;
    public static final int VARSTEP_ITEM_SIZE = 8;
    public static final int BEDGRAPH_ITEM_SIZE = 12;
    private int chromID;
    private int chromStart;
    private int chromEnd;
    private int itemStep;
    private int itemSpan;
    private WigItemType itemType;
    private byte reserved;
    private int itemCount;
    private boolean isValidType;
    private String itemDescription;

    public BigWigSectionHeader(LittleEndianInputStream lbdis) {
        byte type;
        try {
            this.chromID = lbdis.readInt();
            this.chromStart = lbdis.readInt();
            this.chromEnd = lbdis.readInt();
            this.itemStep = lbdis.readInt();
            this.itemSpan = lbdis.readInt();
            type = lbdis.readByte();
            this.reserved = lbdis.readByte();
            this.itemCount = lbdis.readUShort();
        }
        catch (IOException ex) {
            log.error("Error reading wig section header ", ex);
            throw new RuntimeException("Error reading wig section header", ex);
        }
        this.isValidType = this.getItemType(type);
    }

    public BigWigSectionHeader(DataInputStream bdis) {
        byte type;
        try {
            this.chromID = bdis.readInt();
            this.chromStart = bdis.readInt();
            this.chromEnd = bdis.readInt();
            this.itemStep = bdis.readInt();
            this.itemSpan = bdis.readInt();
            type = bdis.readByte();
            this.reserved = bdis.readByte();
            this.itemCount = (short)bdis.readUnsignedShort();
        }
        catch (IOException ex) {
            log.error("Error reading wig section header ", ex);
            throw new RuntimeException("Error reading wig section header", ex);
        }
        this.isValidType = this.getItemType(type);
    }

    public int getChromID() {
        return this.chromID;
    }

    public int getChromosomeStart() {
        return this.chromStart;
    }

    public int getChromosomeEnd() {
        return this.chromEnd;
    }

    public int getItemStep() {
        return this.itemStep;
    }

    public int getItemSpan() {
        return this.itemSpan;
    }

    public WigItemType getItemType() {
        return this.itemType;
    }

    public boolean IsValidType() {
        return this.isValidType;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public void print() {
        log.debug(" BigWig section header  for " + this.itemDescription + " data");
        log.debug("Chromosome ID = " + this.chromID);
        log.debug("ChromStart = " + this.chromStart);
        log.debug("ChromEnd = " + this.chromEnd);
        log.debug("ItemStep = " + this.itemStep);
        log.debug("ItemSpan = " + this.itemSpan);
        log.debug("ItemType = " + this.itemType);
        log.debug("mReserved = " + this.reserved);
        log.debug("mItemCount = " + this.itemCount);
    }

    private boolean getItemType(byte type) {
        boolean isValid;
        if (type == 1) {
            this.itemType = WigItemType.BedGraph;
            this.itemDescription = "Wig Bed Graph";
            isValid = true;
        } else if (type == 2) {
            this.itemType = WigItemType.VarStep;
            this.itemDescription = "Wig Variable Step";
            isValid = true;
        } else if (type == 3) {
            this.itemType = WigItemType.FixedStep;
            this.itemDescription = "Wig Fixed Step";
            isValid = true;
        } else {
            this.itemType = WigItemType.Unknown;
            this.itemDescription = "Wig Type Unknown";
            isValid = false;
        }
        return isValid;
    }

    public static enum WigItemType {
        BedGraph,
        VarStep,
        FixedStep,
        Unknown;

    }
}

