/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile.codecs;

import java.util.Collections;
import java.util.List;
import org.broad.igv.bbfile.BBUtils;
import org.broad.igv.bbfile.codecs.BBBedCodec;
import org.broad.igv.bbfile.codecs.BBCodec;
import org.broad.igv.bbfile.codecs.BBGenePredCodec;
import org.broad.igv.bbfile.codecs.BBNarowPeakCodec;

public class BBCodecFactory {
    public static BBCodec getCodec(String autosql, int standardFieldCount) {
        List<BBUtils.ASField> fields;
        if (autosql == null) {
            fields = Collections.EMPTY_LIST;
        } else {
            BBUtils.ASTable asTable = BBUtils.parseAutosql(autosql);
            fields = asTable.fields;
        }
        if (fields.size() > 15 && "cdsStartStat".equals(fields.get((int)13).name) && "exonFrames".equals(fields.get((int)15).name)) {
            return new BBGenePredCodec(standardFieldCount);
        }
        if (fields.size() > 9 && "signalValue".equals(fields.get((int)6).name) && "pValue".equals(fields.get((int)7).name) && "qValue".equals(fields.get((int)8).name)) {
            return new BBNarowPeakCodec(standardFieldCount);
        }
        return new BBBedCodec(standardFieldCount);
    }
}

