/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.jbrowse;

import htsjdk.tribble.Feature;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.jbrowse.Chord;
import org.broad.igv.jbrowse.CircViewAssembly;
import org.broad.igv.jbrowse.CircViewMessage;
import org.broad.igv.jbrowse.CircViewRegion;
import org.broad.igv.jbrowse.CircViewTrack;
import org.broad.igv.jbrowse.CircviewSocketWriter;
import org.broad.igv.sam.Alignment;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ChromosomeColors;
import org.broad.igv.util.Downsampler;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.vcf.MateVariant;

public class CircularViewUtilities {
    static int MAX_CHORDS = 10000;

    public static boolean ping() {
        try {
            String response = CircviewSocketWriter.send("{\"message\": \"ping\"}", true);
            return "OK".equals(response);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void sendBedpeToJBrowse(List<? extends BedPE> features, String trackName, Color color) {
        Chord[] chords = new Chord[features.size()];
        int index = 0;
        for (BedPE bedPE : features) {
            chords[index++] = Chord.fromBedPE(bedPE);
        }
        CircularViewUtilities.sendChordsToJBrowse(chords, trackName, color, "0.5");
    }

    public static void sendAlignmentsToJBrowse(List<Alignment> alignments, String trackName, Color color) {
        ArrayList<Chord> chords = new ArrayList<Chord>();
        for (Alignment a : alignments) {
            if (a.isPaired() && a.getMate().isMapped()) {
                chords.add(Chord.fromPEAlignment(a));
            }
            if (a.getAttribute("SA") == null) continue;
            chords.addAll(Chord.fromSAString(a));
        }
        Chord[] chordsArray = new Chord[chords.size()];
        chordsArray = chords.toArray(chordsArray);
        CircularViewUtilities.sendChordsToJBrowse(chordsArray, trackName, color, "0.1");
    }

    public static void sendVariantsToJBrowse(List<Feature> variants, String trackName, Color color) {
        Chord[] chords = new Chord[variants.size()];
        int index = 0;
        for (Feature f : variants) {
            if (!(f instanceof Variant)) continue;
            Variant v = f instanceof MateVariant ? ((MateVariant)f).mate : (Variant)f;
            chords[index++] = Chord.fromVariant(v);
        }
        CircularViewUtilities.sendChordsToJBrowse(chords, trackName, color, "0.5");
    }

    public static void sendChordsToJBrowse(Chord[] chords, String trackName, Color color, String alpha) {
        CircularViewUtilities.changeGenome(GenomeManager.getInstance().getCurrentGenome());
        if (chords.length > MAX_CHORDS) {
            Downsampler<Chord> ds = new Downsampler<Chord>();
            chords = ds.sample(chords, MAX_CHORDS);
        }
        String colorString = "rgba(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + alpha + ")";
        CircViewTrack t = new CircViewTrack(chords, trackName, colorString);
        CircViewMessage message = new CircViewMessage("addChords", t);
        String json = message.toJson();
        CircviewSocketWriter.send(json);
    }

    public static void changeGenome(Genome genome) {
        List<String> wgChrNames = genome.getLongChromosomeNames();
        CircViewRegion[] regions = new CircViewRegion[wgChrNames.size()];
        int idx = 0;
        for (String chr : wgChrNames) {
            Chromosome c = genome.getChromosome(chr);
            int length = c.getLength();
            Color color = ChromosomeColors.getColor(chr);
            String colorString = "rgb(" + ColorUtilities.colorToString(color) + ")";
            regions[idx++] = new CircViewRegion(chr, length, colorString);
        }
        CircViewAssembly assm = new CircViewAssembly(genome.getId(), genome.getDisplayName(), regions);
        CircViewMessage message = new CircViewMessage("setAssembly", assm);
        String json = message.toJson();
        CircviewSocketWriter.send(json);
    }

    public static void clearAll() {
        CircviewSocketWriter.send("{\"message\": \"clearChords\"}", true);
    }
}

