/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.ConvertOptions;

public class ConvertFileDialog
extends JDialog {
    ConvertOptions opts = new ConvertOptions();
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label;
    private JRadioButton forwardRadio;
    private JRadioButton reverseRadio;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JFormattedTextField startTextField;
    private JComboBox chromBox;
    private JPanel buttonBar;
    private JButton cancelButton;
    private JButton okButton;

    private ConvertFileDialog(Frame owner, String message, List<String> chromosomes) {
        super(owner);
        this.setModal(true);
        this.initComponents();
        this.label.setText("<html>" + message + "</html>");
        this.okButton.setText("Continue");
        DefaultComboBoxModel<String> boxModel = new DefaultComboBoxModel<String>();
        for (String chrom : chromosomes) {
            boxModel.addElement(chrom);
        }
        this.chromBox.setModel(boxModel);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public static ConvertOptions showConvertFileDialog(String message) {
        ConvertFileDialog dlg = new ConvertFileDialog(IGV.getInstance().getMainFrame(), message, GenomeManager.getInstance().getCurrentGenome().getAllChromosomeNames());
        dlg.setVisible(true);
        dlg.opts.chrom = dlg.chromBox.getSelectedItem().toString();
        dlg.opts.start = Integer.parseInt(dlg.startTextField.getText());
        if (dlg.reverseRadio.isSelected()) {
            dlg.opts.strand = "-";
        }
        return dlg.opts;
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.opts.doConvert = false;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.opts.doConvert = true;
        this.setVisible(false);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label = new JLabel();
        this.forwardRadio = new JRadioButton();
        this.reverseRadio = new JRadioButton();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.startTextField = new JFormattedTextField();
        this.chromBox = new JComboBox();
        this.buttonBar = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(null);
        this.label.setText("text");
        this.label.setFont(this.label.getFont().deriveFont(this.label.getFont().getStyle() & 0xFFFFFFFE));
        this.contentPanel.add(this.label);
        this.label.setBounds(0, 0, 415, 140);
        this.forwardRadio.setText("Forward");
        this.forwardRadio.setSelected(true);
        this.contentPanel.add(this.forwardRadio);
        this.forwardRadio.setBounds(65, 180, this.forwardRadio.getPreferredSize().width, 23);
        this.reverseRadio.setText("Reverse");
        this.contentPanel.add(this.reverseRadio);
        this.reverseRadio.setBounds(145, 180, this.reverseRadio.getPreferredSize().width, 23);
        this.label1.setText("Strand:");
        this.label1.setHorizontalAlignment(4);
        this.contentPanel.add(this.label1);
        this.label1.setBounds(5, 185, this.label1.getPreferredSize().width, 15);
        this.label2.setText("Chr:");
        this.label2.setHorizontalAlignment(4);
        this.contentPanel.add(this.label2);
        this.label2.setBounds(10, 155, 42, 15);
        this.label3.setText("Start:");
        this.label3.setHorizontalAlignment(4);
        this.contentPanel.add(this.label3);
        this.label3.setBounds(5, 215, 49, 15);
        this.startTextField.setText("1");
        this.contentPanel.add(this.startTextField);
        this.startTextField.setBounds(65, 210, 165, this.startTextField.getPreferredSize().height);
        this.chromBox.setMaximumRowCount(100);
        this.contentPanel.add(this.chromBox);
        this.chromBox.setBounds(65, 150, 165, this.chromBox.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.contentPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 0, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.okButton.setText("OK");
        this.okButton.addActionListener(e -> this.okButtonActionPerformed(e));
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(450, 355);
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.forwardRadio);
        buttonGroup1.add(this.reverseRadio);
    }
}

